package it.unimi.dsi.law.big.graph;

/*
 * Copyright (C) 2010-2020 Paolo Boldi, Massimo Santini and Sebastiano Vigna
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

import static org.junit.Assert.assertTrue;

import java.io.IOException;
import java.util.Arrays;

import org.junit.Test;

import it.unimi.dsi.Util;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.Transform;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.util.XoRoShiRo128PlusRandom;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import it.unimi.dsi.webgraph.examples.ErdosRenyiGraph;



//RELEASE-STATUS: DIST

public class LayeredLabelPropagationTest {

	@Test
	public void testStartPerm() throws IOException {

		for(int i = 100; i <= 1000; i += 100) {
			final XoRoShiRo128PlusRandom random = new XoRoShiRo128PlusRandom(0);
			final ImmutableGraph g = ImmutableGraph.wrap(new ArrayListMutableGraph(it.unimi.dsi.webgraph.Transform.symmetrize(new ErdosRenyiGraph(i, .02, 0, false))).immutableView());
			final long[][] startPerm = LongBigArrays.shuffle(Util.identity(g.numNodes()), random);
			final ImmutableGraph mg = ImmutableGraph.wrap(new ArrayListMutableGraph(ImmutableGraph.wrap(Transform.mapOffline(g, startPerm, 100000000))).immutableView());

			final LayeredLabelPropagation clustering0 = new LayeredLabelPropagation(g, startPerm, 1, 0, true);
			final LayeredLabelPropagation clustering1 = new LayeredLabelPropagation(mg, Util.identity(g.numNodes()), 1, 0, true);
			final LayeredLabelPropagation clustering2 = new LayeredLabelPropagation(mg, null, 1, 0, true);

			final double[] gammas = { 1/16., 1/32., 1/64., 1/128., 1/256. };
			final long[][] perm0 = clustering0.computePermutation(gammas, null, Integer.MAX_VALUE);
			final long[][] perm1 = clustering1.computePermutation(gammas, null, Integer.MAX_VALUE);
			final long[][] perm2 = clustering2.computePermutation(gammas, null, Integer.MAX_VALUE);

			assertTrue(Arrays.deepEquals(perm1, perm2));

			assertTrue(Transform.mapOffline(g, perm0, 100000000).equals(Transform.mapOffline(mg, perm1, 100000000)));
		}
	}
}
