package it.unimi.dsi.law.big.graph;

/*
 * Copyright (C) 2010-2020 Paolo Boldi, Massimo Santini and Sebastiano Vigna
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

import static org.junit.Assert.assertTrue;

import java.io.IOException;

import org.junit.Test;

import it.unimi.dsi.Util;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.Transform;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.util.XoRoShiRo128PlusRandom;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import it.unimi.dsi.webgraph.examples.ErdosRenyiGraph;



//RELEASE-STATUS: DIST

public class BFSTest {
	@Test
	public void testStartPerm() throws IOException {
		for (int i = 100; i <= 1000; i += 100) {
			final ImmutableGraph g = ImmutableGraph.wrap(new ArrayListMutableGraph(it.unimi.dsi.webgraph.Transform.symmetrize(new ErdosRenyiGraph(i, .02, 0, false))).immutableView());
			final long[][] startPerm = Util.identity(LongBigArrays.newBigArray(g.numNodes()));
			LongBigArrays.shuffle(startPerm, new XoRoShiRo128PlusRandom(1));
			final ImmutableGraph mg = ImmutableGraph.wrap(new ArrayListMutableGraph(ImmutableGraph.wrap(Transform.mapOffline(g, startPerm, 10000000))).immutableView());


			final long[][] perm0 = Util.invertPermutationInPlace(BFS.bfsperm(g, -1, startPerm, Integer.MAX_VALUE));
			final long[][] perm1 = Util.invertPermutationInPlace(BFS.bfsperm(mg, -1, Util.identity(LongBigArrays.newBigArray(g.numNodes())), Integer.MAX_VALUE));
			assertTrue(Transform.mapOffline(g, perm0, 1000000).equals(Transform.mapOffline(mg, perm1, 1000000)));

			BFS.bfs(g, -1, startPerm, Integer.MAX_VALUE);
			BFS.bfs(g, -1, Integer.MAX_VALUE);

		}
	}

	@Test
	public void testNoStartPerm() throws IOException {
		for (int i = 100; i <= 1000; i += 100) {
			final ImmutableGraph g = ImmutableGraph.wrap(new ArrayListMutableGraph(it.unimi.dsi.webgraph.Transform.symmetrize(new ErdosRenyiGraph(i, .02, 0, false))).immutableView());
			final long[][] startPerm = Util.identity(LongBigArrays.newBigArray(g.numNodes()));

			final long[][] perm0 = Util.invertPermutationInPlace(BFS.bfsperm(g, -1, startPerm, Integer.MAX_VALUE));
			final long[][] perm1 = Util.invertPermutationInPlace(BFS.bfsperm(g, -1, null, Integer.MAX_VALUE));

			assertTrue(BigArrays.equals(perm0, perm1));
			BFS.bfs(g, -1, startPerm, Integer.MAX_VALUE);
			BFS.bfs(g, -1, Integer.MAX_VALUE);
		}
	}
}
