package it.unimi.dsi.law.util;

/*
 * Copyright (C) 2007-2020 Paolo Boldi, Massimo Santini and Sebastiano Vigna
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

import it.unimi.dsi.lang.MutableString;

//RELEASE-STATUS: DIST

/** Provides static methods to compute 64-bit CRCs of strings and byte arrays. It
 * uses the primitive polynomial
 * <var>x</var><sup>64</sup>+<var>x</var><sup>4</sup>+<var>x</var><sup>3</sup>+<var>x</var>+1.
 */
public class CRC64 {

	private CRC64() {}

	/** This array stores precomputed values: T[i][j] is the CRC of j << 64+8*i. */
	private final static long[][] T =
	{
		{ 0x0000000000000000L, 0x1b00000000000000L, 0x3600000000000000L, 0x2d00000000000000L, 0x6c00000000000000L, 0x7700000000000000L, 0x5a00000000000000L, 0x4100000000000000L, 0xd800000000000000L, 0xc300000000000000L, 0xee00000000000000L, 0xf500000000000000L, 0xb400000000000000L, 0xaf00000000000000L, 0x8200000000000000L, 0x9900000000000000L, 0xb00000000000001bL, 0xab0000000000001bL, 0x860000000000001bL, 0x9d0000000000001bL, 0xdc0000000000001bL, 0xc70000000000001bL, 0xea0000000000001bL, 0xf10000000000001bL, 0x680000000000001bL, 0x730000000000001bL, 0x5e0000000000001bL, 0x450000000000001bL, 0x040000000000001bL, 0x1f0000000000001bL, 0x320000000000001bL, 0x290000000000001bL, 0x600000000000002dL, 0x7b0000000000002dL, 0x560000000000002dL, 0x4d0000000000002dL, 0x0c0000000000002dL, 0x170000000000002dL, 0x3a0000000000002dL, 0x210000000000002dL, 0xb80000000000002dL, 0xa30000000000002dL, 0x8e0000000000002dL, 0x950000000000002dL, 0xd40000000000002dL, 0xcf0000000000002dL, 0xe20000000000002dL, 0xf90000000000002dL, 0xd000000000000036L, 0xcb00000000000036L, 0xe600000000000036L, 0xfd00000000000036L, 0xbc00000000000036L, 0xa700000000000036L, 0x8a00000000000036L, 0x9100000000000036L, 0x0800000000000036L, 0x1300000000000036L, 0x3e00000000000036L, 0x2500000000000036L, 0x6400000000000036L, 0x7f00000000000036L, 0x5200000000000036L, 0x4900000000000036L, 0xc00000000000005aL, 0xdb0000000000005aL, 0xf60000000000005aL, 0xed0000000000005aL, 0xac0000000000005aL, 0xb70000000000005aL, 0x9a0000000000005aL, 0x810000000000005aL, 0x180000000000005aL, 0x030000000000005aL, 0x2e0000000000005aL, 0x350000000000005aL, 0x740000000000005aL, 0x6f0000000000005aL, 0x420000000000005aL, 0x590000000000005aL, 0x7000000000000041L, 0x6b00000000000041L, 0x4600000000000041L, 0x5d00000000000041L, 0x1c00000000000041L, 0x0700000000000041L, 0x2a00000000000041L, 0x3100000000000041L, 0xa800000000000041L, 0xb300000000000041L, 0x9e00000000000041L, 0x8500000000000041L, 0xc400000000000041L, 0xdf00000000000041L, 0xf200000000000041L, 0xe900000000000041L, 0xa000000000000077L, 0xbb00000000000077L, 0x9600000000000077L, 0x8d00000000000077L, 0xcc00000000000077L, 0xd700000000000077L, 0xfa00000000000077L, 0xe100000000000077L, 0x7800000000000077L, 0x6300000000000077L, 0x4e00000000000077L, 0x5500000000000077L, 0x1400000000000077L, 0x0f00000000000077L, 0x2200000000000077L, 0x3900000000000077L, 0x100000000000006cL, 0x0b0000000000006cL, 0x260000000000006cL, 0x3d0000000000006cL, 0x7c0000000000006cL, 0x670000000000006cL, 0x4a0000000000006cL, 0x510000000000006cL, 0xc80000000000006cL, 0xd30000000000006cL, 0xfe0000000000006cL, 0xe50000000000006cL, 0xa40000000000006cL, 0xbf0000000000006cL, 0x920000000000006cL, 0x890000000000006cL, 0x80000000000000afL, 0x9b000000000000afL, 0xb6000000000000afL, 0xad000000000000afL, 0xec000000000000afL, 0xf7000000000000afL, 0xda000000000000afL, 0xc1000000000000afL, 0x58000000000000afL, 0x43000000000000afL, 0x6e000000000000afL, 0x75000000000000afL, 0x34000000000000afL, 0x2f000000000000afL, 0x02000000000000afL, 0x19000000000000afL, 0x30000000000000b4L, 0x2b000000000000b4L, 0x06000000000000b4L, 0x1d000000000000b4L, 0x5c000000000000b4L, 0x47000000000000b4L, 0x6a000000000000b4L, 0x71000000000000b4L, 0xe8000000000000b4L, 0xf3000000000000b4L, 0xde000000000000b4L, 0xc5000000000000b4L, 0x84000000000000b4L, 0x9f000000000000b4L, 0xb2000000000000b4L, 0xa9000000000000b4L, 0xe000000000000082L, 0xfb00000000000082L, 0xd600000000000082L, 0xcd00000000000082L, 0x8c00000000000082L, 0x9700000000000082L, 0xba00000000000082L, 0xa100000000000082L, 0x3800000000000082L, 0x2300000000000082L, 0x0e00000000000082L, 0x1500000000000082L, 0x5400000000000082L, 0x4f00000000000082L, 0x6200000000000082L, 0x7900000000000082L, 0x5000000000000099L, 0x4b00000000000099L, 0x6600000000000099L, 0x7d00000000000099L, 0x3c00000000000099L, 0x2700000000000099L, 0x0a00000000000099L, 0x1100000000000099L, 0x8800000000000099L, 0x9300000000000099L, 0xbe00000000000099L, 0xa500000000000099L, 0xe400000000000099L, 0xff00000000000099L, 0xd200000000000099L, 0xc900000000000099L, 0x40000000000000f5L, 0x5b000000000000f5L, 0x76000000000000f5L, 0x6d000000000000f5L, 0x2c000000000000f5L, 0x37000000000000f5L, 0x1a000000000000f5L, 0x01000000000000f5L, 0x98000000000000f5L, 0x83000000000000f5L, 0xae000000000000f5L, 0xb5000000000000f5L, 0xf4000000000000f5L, 0xef000000000000f5L, 0xc2000000000000f5L, 0xd9000000000000f5L, 0xf0000000000000eeL, 0xeb000000000000eeL, 0xc6000000000000eeL, 0xdd000000000000eeL, 0x9c000000000000eeL, 0x87000000000000eeL, 0xaa000000000000eeL, 0xb1000000000000eeL, 0x28000000000000eeL, 0x33000000000000eeL, 0x1e000000000000eeL, 0x05000000000000eeL, 0x44000000000000eeL, 0x5f000000000000eeL, 0x72000000000000eeL, 0x69000000000000eeL, 0x20000000000000d8L, 0x3b000000000000d8L, 0x16000000000000d8L, 0x0d000000000000d8L, 0x4c000000000000d8L, 0x57000000000000d8L, 0x7a000000000000d8L, 0x61000000000000d8L, 0xf8000000000000d8L, 0xe3000000000000d8L, 0xce000000000000d8L, 0xd5000000000000d8L, 0x94000000000000d8L, 0x8f000000000000d8L, 0xa2000000000000d8L, 0xb9000000000000d8L, 0x90000000000000c3L, 0x8b000000000000c3L, 0xa6000000000000c3L, 0xbd000000000000c3L, 0xfc000000000000c3L, 0xe7000000000000c3L, 0xca000000000000c3L, 0xd1000000000000c3L, 0x48000000000000c3L, 0x53000000000000c3L, 0x7e000000000000c3L, 0x65000000000000c3L, 0x24000000000000c3L, 0x3f000000000000c3L, 0x12000000000000c3L, 0x09000000000000c3L },
		{ 0x0000000000000000L, 0x001b000000000000L, 0x0036000000000000L, 0x002d000000000000L, 0x006c000000000000L, 0x0077000000000000L, 0x005a000000000000L, 0x0041000000000000L, 0x00d8000000000000L, 0x00c3000000000000L, 0x00ee000000000000L, 0x00f5000000000000L, 0x00b4000000000000L, 0x00af000000000000L, 0x0082000000000000L, 0x0099000000000000L, 0x01b0000000000000L, 0x01ab000000000000L, 0x0186000000000000L, 0x019d000000000000L, 0x01dc000000000000L, 0x01c7000000000000L, 0x01ea000000000000L, 0x01f1000000000000L, 0x0168000000000000L, 0x0173000000000000L, 0x015e000000000000L, 0x0145000000000000L, 0x0104000000000000L, 0x011f000000000000L, 0x0132000000000000L, 0x0129000000000000L, 0x0360000000000000L, 0x037b000000000000L, 0x0356000000000000L, 0x034d000000000000L, 0x030c000000000000L, 0x0317000000000000L, 0x033a000000000000L, 0x0321000000000000L, 0x03b8000000000000L, 0x03a3000000000000L, 0x038e000000000000L, 0x0395000000000000L, 0x03d4000000000000L, 0x03cf000000000000L, 0x03e2000000000000L, 0x03f9000000000000L, 0x02d0000000000000L, 0x02cb000000000000L, 0x02e6000000000000L, 0x02fd000000000000L, 0x02bc000000000000L, 0x02a7000000000000L, 0x028a000000000000L, 0x0291000000000000L, 0x0208000000000000L, 0x0213000000000000L, 0x023e000000000000L, 0x0225000000000000L, 0x0264000000000000L, 0x027f000000000000L, 0x0252000000000000L, 0x0249000000000000L, 0x06c0000000000000L, 0x06db000000000000L, 0x06f6000000000000L, 0x06ed000000000000L, 0x06ac000000000000L, 0x06b7000000000000L, 0x069a000000000000L, 0x0681000000000000L, 0x0618000000000000L, 0x0603000000000000L, 0x062e000000000000L, 0x0635000000000000L, 0x0674000000000000L, 0x066f000000000000L, 0x0642000000000000L, 0x0659000000000000L, 0x0770000000000000L, 0x076b000000000000L, 0x0746000000000000L, 0x075d000000000000L, 0x071c000000000000L, 0x0707000000000000L, 0x072a000000000000L, 0x0731000000000000L, 0x07a8000000000000L, 0x07b3000000000000L, 0x079e000000000000L, 0x0785000000000000L, 0x07c4000000000000L, 0x07df000000000000L, 0x07f2000000000000L, 0x07e9000000000000L, 0x05a0000000000000L, 0x05bb000000000000L, 0x0596000000000000L, 0x058d000000000000L, 0x05cc000000000000L, 0x05d7000000000000L, 0x05fa000000000000L, 0x05e1000000000000L, 0x0578000000000000L, 0x0563000000000000L, 0x054e000000000000L, 0x0555000000000000L, 0x0514000000000000L, 0x050f000000000000L, 0x0522000000000000L, 0x0539000000000000L, 0x0410000000000000L, 0x040b000000000000L, 0x0426000000000000L, 0x043d000000000000L, 0x047c000000000000L, 0x0467000000000000L, 0x044a000000000000L, 0x0451000000000000L, 0x04c8000000000000L, 0x04d3000000000000L, 0x04fe000000000000L, 0x04e5000000000000L, 0x04a4000000000000L, 0x04bf000000000000L, 0x0492000000000000L, 0x0489000000000000L, 0x0d80000000000000L, 0x0d9b000000000000L, 0x0db6000000000000L, 0x0dad000000000000L, 0x0dec000000000000L, 0x0df7000000000000L, 0x0dda000000000000L, 0x0dc1000000000000L, 0x0d58000000000000L, 0x0d43000000000000L, 0x0d6e000000000000L, 0x0d75000000000000L, 0x0d34000000000000L, 0x0d2f000000000000L, 0x0d02000000000000L, 0x0d19000000000000L, 0x0c30000000000000L, 0x0c2b000000000000L, 0x0c06000000000000L, 0x0c1d000000000000L, 0x0c5c000000000000L, 0x0c47000000000000L, 0x0c6a000000000000L, 0x0c71000000000000L, 0x0ce8000000000000L, 0x0cf3000000000000L, 0x0cde000000000000L, 0x0cc5000000000000L, 0x0c84000000000000L, 0x0c9f000000000000L, 0x0cb2000000000000L, 0x0ca9000000000000L, 0x0ee0000000000000L, 0x0efb000000000000L, 0x0ed6000000000000L, 0x0ecd000000000000L, 0x0e8c000000000000L, 0x0e97000000000000L, 0x0eba000000000000L, 0x0ea1000000000000L, 0x0e38000000000000L, 0x0e23000000000000L, 0x0e0e000000000000L, 0x0e15000000000000L, 0x0e54000000000000L, 0x0e4f000000000000L, 0x0e62000000000000L, 0x0e79000000000000L, 0x0f50000000000000L, 0x0f4b000000000000L, 0x0f66000000000000L, 0x0f7d000000000000L, 0x0f3c000000000000L, 0x0f27000000000000L, 0x0f0a000000000000L, 0x0f11000000000000L, 0x0f88000000000000L, 0x0f93000000000000L, 0x0fbe000000000000L, 0x0fa5000000000000L, 0x0fe4000000000000L, 0x0fff000000000000L, 0x0fd2000000000000L, 0x0fc9000000000000L, 0x0b40000000000000L, 0x0b5b000000000000L, 0x0b76000000000000L, 0x0b6d000000000000L, 0x0b2c000000000000L, 0x0b37000000000000L, 0x0b1a000000000000L, 0x0b01000000000000L, 0x0b98000000000000L, 0x0b83000000000000L, 0x0bae000000000000L, 0x0bb5000000000000L, 0x0bf4000000000000L, 0x0bef000000000000L, 0x0bc2000000000000L, 0x0bd9000000000000L, 0x0af0000000000000L, 0x0aeb000000000000L, 0x0ac6000000000000L, 0x0add000000000000L, 0x0a9c000000000000L, 0x0a87000000000000L, 0x0aaa000000000000L, 0x0ab1000000000000L, 0x0a28000000000000L, 0x0a33000000000000L, 0x0a1e000000000000L, 0x0a05000000000000L, 0x0a44000000000000L, 0x0a5f000000000000L, 0x0a72000000000000L, 0x0a69000000000000L, 0x0820000000000000L, 0x083b000000000000L, 0x0816000000000000L, 0x080d000000000000L, 0x084c000000000000L, 0x0857000000000000L, 0x087a000000000000L, 0x0861000000000000L, 0x08f8000000000000L, 0x08e3000000000000L, 0x08ce000000000000L, 0x08d5000000000000L, 0x0894000000000000L, 0x088f000000000000L, 0x08a2000000000000L, 0x08b9000000000000L, 0x0990000000000000L, 0x098b000000000000L, 0x09a6000000000000L, 0x09bd000000000000L, 0x09fc000000000000L, 0x09e7000000000000L, 0x09ca000000000000L, 0x09d1000000000000L, 0x0948000000000000L, 0x0953000000000000L, 0x097e000000000000L, 0x0965000000000000L, 0x0924000000000000L, 0x093f000000000000L, 0x0912000000000000L, 0x0909000000000000L },
		{ 0x0000000000000000L, 0x00001b0000000000L, 0x0000360000000000L, 0x00002d0000000000L, 0x00006c0000000000L, 0x0000770000000000L, 0x00005a0000000000L, 0x0000410000000000L, 0x0000d80000000000L, 0x0000c30000000000L, 0x0000ee0000000000L, 0x0000f50000000000L, 0x0000b40000000000L, 0x0000af0000000000L, 0x0000820000000000L, 0x0000990000000000L, 0x0001b00000000000L, 0x0001ab0000000000L, 0x0001860000000000L, 0x00019d0000000000L, 0x0001dc0000000000L, 0x0001c70000000000L, 0x0001ea0000000000L, 0x0001f10000000000L, 0x0001680000000000L, 0x0001730000000000L, 0x00015e0000000000L, 0x0001450000000000L, 0x0001040000000000L, 0x00011f0000000000L, 0x0001320000000000L, 0x0001290000000000L, 0x0003600000000000L, 0x00037b0000000000L, 0x0003560000000000L, 0x00034d0000000000L, 0x00030c0000000000L, 0x0003170000000000L, 0x00033a0000000000L, 0x0003210000000000L, 0x0003b80000000000L, 0x0003a30000000000L, 0x00038e0000000000L, 0x0003950000000000L, 0x0003d40000000000L, 0x0003cf0000000000L, 0x0003e20000000000L, 0x0003f90000000000L, 0x0002d00000000000L, 0x0002cb0000000000L, 0x0002e60000000000L, 0x0002fd0000000000L, 0x0002bc0000000000L, 0x0002a70000000000L, 0x00028a0000000000L, 0x0002910000000000L, 0x0002080000000000L, 0x0002130000000000L, 0x00023e0000000000L, 0x0002250000000000L, 0x0002640000000000L, 0x00027f0000000000L, 0x0002520000000000L, 0x0002490000000000L, 0x0006c00000000000L, 0x0006db0000000000L, 0x0006f60000000000L, 0x0006ed0000000000L, 0x0006ac0000000000L, 0x0006b70000000000L, 0x00069a0000000000L, 0x0006810000000000L, 0x0006180000000000L, 0x0006030000000000L, 0x00062e0000000000L, 0x0006350000000000L, 0x0006740000000000L, 0x00066f0000000000L, 0x0006420000000000L, 0x0006590000000000L, 0x0007700000000000L, 0x00076b0000000000L, 0x0007460000000000L, 0x00075d0000000000L, 0x00071c0000000000L, 0x0007070000000000L, 0x00072a0000000000L, 0x0007310000000000L, 0x0007a80000000000L, 0x0007b30000000000L, 0x00079e0000000000L, 0x0007850000000000L, 0x0007c40000000000L, 0x0007df0000000000L, 0x0007f20000000000L, 0x0007e90000000000L, 0x0005a00000000000L, 0x0005bb0000000000L, 0x0005960000000000L, 0x00058d0000000000L, 0x0005cc0000000000L, 0x0005d70000000000L, 0x0005fa0000000000L, 0x0005e10000000000L, 0x0005780000000000L, 0x0005630000000000L, 0x00054e0000000000L, 0x0005550000000000L, 0x0005140000000000L, 0x00050f0000000000L, 0x0005220000000000L, 0x0005390000000000L, 0x0004100000000000L, 0x00040b0000000000L, 0x0004260000000000L, 0x00043d0000000000L, 0x00047c0000000000L, 0x0004670000000000L, 0x00044a0000000000L, 0x0004510000000000L, 0x0004c80000000000L, 0x0004d30000000000L, 0x0004fe0000000000L, 0x0004e50000000000L, 0x0004a40000000000L, 0x0004bf0000000000L, 0x0004920000000000L, 0x0004890000000000L, 0x000d800000000000L, 0x000d9b0000000000L, 0x000db60000000000L, 0x000dad0000000000L, 0x000dec0000000000L, 0x000df70000000000L, 0x000dda0000000000L, 0x000dc10000000000L, 0x000d580000000000L, 0x000d430000000000L, 0x000d6e0000000000L, 0x000d750000000000L, 0x000d340000000000L, 0x000d2f0000000000L, 0x000d020000000000L, 0x000d190000000000L, 0x000c300000000000L, 0x000c2b0000000000L, 0x000c060000000000L, 0x000c1d0000000000L, 0x000c5c0000000000L, 0x000c470000000000L, 0x000c6a0000000000L, 0x000c710000000000L, 0x000ce80000000000L, 0x000cf30000000000L, 0x000cde0000000000L, 0x000cc50000000000L, 0x000c840000000000L, 0x000c9f0000000000L, 0x000cb20000000000L, 0x000ca90000000000L, 0x000ee00000000000L, 0x000efb0000000000L, 0x000ed60000000000L, 0x000ecd0000000000L, 0x000e8c0000000000L, 0x000e970000000000L, 0x000eba0000000000L, 0x000ea10000000000L, 0x000e380000000000L, 0x000e230000000000L, 0x000e0e0000000000L, 0x000e150000000000L, 0x000e540000000000L, 0x000e4f0000000000L, 0x000e620000000000L, 0x000e790000000000L, 0x000f500000000000L, 0x000f4b0000000000L, 0x000f660000000000L, 0x000f7d0000000000L, 0x000f3c0000000000L, 0x000f270000000000L, 0x000f0a0000000000L, 0x000f110000000000L, 0x000f880000000000L, 0x000f930000000000L, 0x000fbe0000000000L, 0x000fa50000000000L, 0x000fe40000000000L, 0x000fff0000000000L, 0x000fd20000000000L, 0x000fc90000000000L, 0x000b400000000000L, 0x000b5b0000000000L, 0x000b760000000000L, 0x000b6d0000000000L, 0x000b2c0000000000L, 0x000b370000000000L, 0x000b1a0000000000L, 0x000b010000000000L, 0x000b980000000000L, 0x000b830000000000L, 0x000bae0000000000L, 0x000bb50000000000L, 0x000bf40000000000L, 0x000bef0000000000L, 0x000bc20000000000L, 0x000bd90000000000L, 0x000af00000000000L, 0x000aeb0000000000L, 0x000ac60000000000L, 0x000add0000000000L, 0x000a9c0000000000L, 0x000a870000000000L, 0x000aaa0000000000L, 0x000ab10000000000L, 0x000a280000000000L, 0x000a330000000000L, 0x000a1e0000000000L, 0x000a050000000000L, 0x000a440000000000L, 0x000a5f0000000000L, 0x000a720000000000L, 0x000a690000000000L, 0x0008200000000000L, 0x00083b0000000000L, 0x0008160000000000L, 0x00080d0000000000L, 0x00084c0000000000L, 0x0008570000000000L, 0x00087a0000000000L, 0x0008610000000000L, 0x0008f80000000000L, 0x0008e30000000000L, 0x0008ce0000000000L, 0x0008d50000000000L, 0x0008940000000000L, 0x00088f0000000000L, 0x0008a20000000000L, 0x0008b90000000000L, 0x0009900000000000L, 0x00098b0000000000L, 0x0009a60000000000L, 0x0009bd0000000000L, 0x0009fc0000000000L, 0x0009e70000000000L, 0x0009ca0000000000L, 0x0009d10000000000L, 0x0009480000000000L, 0x0009530000000000L, 0x00097e0000000000L, 0x0009650000000000L, 0x0009240000000000L, 0x00093f0000000000L, 0x0009120000000000L, 0x0009090000000000L },
		{ 0x0000000000000000L, 0x0000001b00000000L, 0x0000003600000000L, 0x0000002d00000000L, 0x0000006c00000000L, 0x0000007700000000L, 0x0000005a00000000L, 0x0000004100000000L, 0x000000d800000000L, 0x000000c300000000L, 0x000000ee00000000L, 0x000000f500000000L, 0x000000b400000000L, 0x000000af00000000L, 0x0000008200000000L, 0x0000009900000000L, 0x000001b000000000L, 0x000001ab00000000L, 0x0000018600000000L, 0x0000019d00000000L, 0x000001dc00000000L, 0x000001c700000000L, 0x000001ea00000000L, 0x000001f100000000L, 0x0000016800000000L, 0x0000017300000000L, 0x0000015e00000000L, 0x0000014500000000L, 0x0000010400000000L, 0x0000011f00000000L, 0x0000013200000000L, 0x0000012900000000L, 0x0000036000000000L, 0x0000037b00000000L, 0x0000035600000000L, 0x0000034d00000000L, 0x0000030c00000000L, 0x0000031700000000L, 0x0000033a00000000L, 0x0000032100000000L, 0x000003b800000000L, 0x000003a300000000L, 0x0000038e00000000L, 0x0000039500000000L, 0x000003d400000000L, 0x000003cf00000000L, 0x000003e200000000L, 0x000003f900000000L, 0x000002d000000000L, 0x000002cb00000000L, 0x000002e600000000L, 0x000002fd00000000L, 0x000002bc00000000L, 0x000002a700000000L, 0x0000028a00000000L, 0x0000029100000000L, 0x0000020800000000L, 0x0000021300000000L, 0x0000023e00000000L, 0x0000022500000000L, 0x0000026400000000L, 0x0000027f00000000L, 0x0000025200000000L, 0x0000024900000000L, 0x000006c000000000L, 0x000006db00000000L, 0x000006f600000000L, 0x000006ed00000000L, 0x000006ac00000000L, 0x000006b700000000L, 0x0000069a00000000L, 0x0000068100000000L, 0x0000061800000000L, 0x0000060300000000L, 0x0000062e00000000L, 0x0000063500000000L, 0x0000067400000000L, 0x0000066f00000000L, 0x0000064200000000L, 0x0000065900000000L, 0x0000077000000000L, 0x0000076b00000000L, 0x0000074600000000L, 0x0000075d00000000L, 0x0000071c00000000L, 0x0000070700000000L, 0x0000072a00000000L, 0x0000073100000000L, 0x000007a800000000L, 0x000007b300000000L, 0x0000079e00000000L, 0x0000078500000000L, 0x000007c400000000L, 0x000007df00000000L, 0x000007f200000000L, 0x000007e900000000L, 0x000005a000000000L, 0x000005bb00000000L, 0x0000059600000000L, 0x0000058d00000000L, 0x000005cc00000000L, 0x000005d700000000L, 0x000005fa00000000L, 0x000005e100000000L, 0x0000057800000000L, 0x0000056300000000L, 0x0000054e00000000L, 0x0000055500000000L, 0x0000051400000000L, 0x0000050f00000000L, 0x0000052200000000L, 0x0000053900000000L, 0x0000041000000000L, 0x0000040b00000000L, 0x0000042600000000L, 0x0000043d00000000L, 0x0000047c00000000L, 0x0000046700000000L, 0x0000044a00000000L, 0x0000045100000000L, 0x000004c800000000L, 0x000004d300000000L, 0x000004fe00000000L, 0x000004e500000000L, 0x000004a400000000L, 0x000004bf00000000L, 0x0000049200000000L, 0x0000048900000000L, 0x00000d8000000000L, 0x00000d9b00000000L, 0x00000db600000000L, 0x00000dad00000000L, 0x00000dec00000000L, 0x00000df700000000L, 0x00000dda00000000L, 0x00000dc100000000L, 0x00000d5800000000L, 0x00000d4300000000L, 0x00000d6e00000000L, 0x00000d7500000000L, 0x00000d3400000000L, 0x00000d2f00000000L, 0x00000d0200000000L, 0x00000d1900000000L, 0x00000c3000000000L, 0x00000c2b00000000L, 0x00000c0600000000L, 0x00000c1d00000000L, 0x00000c5c00000000L, 0x00000c4700000000L, 0x00000c6a00000000L, 0x00000c7100000000L, 0x00000ce800000000L, 0x00000cf300000000L, 0x00000cde00000000L, 0x00000cc500000000L, 0x00000c8400000000L, 0x00000c9f00000000L, 0x00000cb200000000L, 0x00000ca900000000L, 0x00000ee000000000L, 0x00000efb00000000L, 0x00000ed600000000L, 0x00000ecd00000000L, 0x00000e8c00000000L, 0x00000e9700000000L, 0x00000eba00000000L, 0x00000ea100000000L, 0x00000e3800000000L, 0x00000e2300000000L, 0x00000e0e00000000L, 0x00000e1500000000L, 0x00000e5400000000L, 0x00000e4f00000000L, 0x00000e6200000000L, 0x00000e7900000000L, 0x00000f5000000000L, 0x00000f4b00000000L, 0x00000f6600000000L, 0x00000f7d00000000L, 0x00000f3c00000000L, 0x00000f2700000000L, 0x00000f0a00000000L, 0x00000f1100000000L, 0x00000f8800000000L, 0x00000f9300000000L, 0x00000fbe00000000L, 0x00000fa500000000L, 0x00000fe400000000L, 0x00000fff00000000L, 0x00000fd200000000L, 0x00000fc900000000L, 0x00000b4000000000L, 0x00000b5b00000000L, 0x00000b7600000000L, 0x00000b6d00000000L, 0x00000b2c00000000L, 0x00000b3700000000L, 0x00000b1a00000000L, 0x00000b0100000000L, 0x00000b9800000000L, 0x00000b8300000000L, 0x00000bae00000000L, 0x00000bb500000000L, 0x00000bf400000000L, 0x00000bef00000000L, 0x00000bc200000000L, 0x00000bd900000000L, 0x00000af000000000L, 0x00000aeb00000000L, 0x00000ac600000000L, 0x00000add00000000L, 0x00000a9c00000000L, 0x00000a8700000000L, 0x00000aaa00000000L, 0x00000ab100000000L, 0x00000a2800000000L, 0x00000a3300000000L, 0x00000a1e00000000L, 0x00000a0500000000L, 0x00000a4400000000L, 0x00000a5f00000000L, 0x00000a7200000000L, 0x00000a6900000000L, 0x0000082000000000L, 0x0000083b00000000L, 0x0000081600000000L, 0x0000080d00000000L, 0x0000084c00000000L, 0x0000085700000000L, 0x0000087a00000000L, 0x0000086100000000L, 0x000008f800000000L, 0x000008e300000000L, 0x000008ce00000000L, 0x000008d500000000L, 0x0000089400000000L, 0x0000088f00000000L, 0x000008a200000000L, 0x000008b900000000L, 0x0000099000000000L, 0x0000098b00000000L, 0x000009a600000000L, 0x000009bd00000000L, 0x000009fc00000000L, 0x000009e700000000L, 0x000009ca00000000L, 0x000009d100000000L, 0x0000094800000000L, 0x0000095300000000L, 0x0000097e00000000L, 0x0000096500000000L, 0x0000092400000000L, 0x0000093f00000000L, 0x0000091200000000L, 0x0000090900000000L },
		{ 0x0000000000000000L, 0x000000001b000000L, 0x0000000036000000L, 0x000000002d000000L, 0x000000006c000000L, 0x0000000077000000L, 0x000000005a000000L, 0x0000000041000000L, 0x00000000d8000000L, 0x00000000c3000000L, 0x00000000ee000000L, 0x00000000f5000000L, 0x00000000b4000000L, 0x00000000af000000L, 0x0000000082000000L, 0x0000000099000000L, 0x00000001b0000000L, 0x00000001ab000000L, 0x0000000186000000L, 0x000000019d000000L, 0x00000001dc000000L, 0x00000001c7000000L, 0x00000001ea000000L, 0x00000001f1000000L, 0x0000000168000000L, 0x0000000173000000L, 0x000000015e000000L, 0x0000000145000000L, 0x0000000104000000L, 0x000000011f000000L, 0x0000000132000000L, 0x0000000129000000L, 0x0000000360000000L, 0x000000037b000000L, 0x0000000356000000L, 0x000000034d000000L, 0x000000030c000000L, 0x0000000317000000L, 0x000000033a000000L, 0x0000000321000000L, 0x00000003b8000000L, 0x00000003a3000000L, 0x000000038e000000L, 0x0000000395000000L, 0x00000003d4000000L, 0x00000003cf000000L, 0x00000003e2000000L, 0x00000003f9000000L, 0x00000002d0000000L, 0x00000002cb000000L, 0x00000002e6000000L, 0x00000002fd000000L, 0x00000002bc000000L, 0x00000002a7000000L, 0x000000028a000000L, 0x0000000291000000L, 0x0000000208000000L, 0x0000000213000000L, 0x000000023e000000L, 0x0000000225000000L, 0x0000000264000000L, 0x000000027f000000L, 0x0000000252000000L, 0x0000000249000000L, 0x00000006c0000000L, 0x00000006db000000L, 0x00000006f6000000L, 0x00000006ed000000L, 0x00000006ac000000L, 0x00000006b7000000L, 0x000000069a000000L, 0x0000000681000000L, 0x0000000618000000L, 0x0000000603000000L, 0x000000062e000000L, 0x0000000635000000L, 0x0000000674000000L, 0x000000066f000000L, 0x0000000642000000L, 0x0000000659000000L, 0x0000000770000000L, 0x000000076b000000L, 0x0000000746000000L, 0x000000075d000000L, 0x000000071c000000L, 0x0000000707000000L, 0x000000072a000000L, 0x0000000731000000L, 0x00000007a8000000L, 0x00000007b3000000L, 0x000000079e000000L, 0x0000000785000000L, 0x00000007c4000000L, 0x00000007df000000L, 0x00000007f2000000L, 0x00000007e9000000L, 0x00000005a0000000L, 0x00000005bb000000L, 0x0000000596000000L, 0x000000058d000000L, 0x00000005cc000000L, 0x00000005d7000000L, 0x00000005fa000000L, 0x00000005e1000000L, 0x0000000578000000L, 0x0000000563000000L, 0x000000054e000000L, 0x0000000555000000L, 0x0000000514000000L, 0x000000050f000000L, 0x0000000522000000L, 0x0000000539000000L, 0x0000000410000000L, 0x000000040b000000L, 0x0000000426000000L, 0x000000043d000000L, 0x000000047c000000L, 0x0000000467000000L, 0x000000044a000000L, 0x0000000451000000L, 0x00000004c8000000L, 0x00000004d3000000L, 0x00000004fe000000L, 0x00000004e5000000L, 0x00000004a4000000L, 0x00000004bf000000L, 0x0000000492000000L, 0x0000000489000000L, 0x0000000d80000000L, 0x0000000d9b000000L, 0x0000000db6000000L, 0x0000000dad000000L, 0x0000000dec000000L, 0x0000000df7000000L, 0x0000000dda000000L, 0x0000000dc1000000L, 0x0000000d58000000L, 0x0000000d43000000L, 0x0000000d6e000000L, 0x0000000d75000000L, 0x0000000d34000000L, 0x0000000d2f000000L, 0x0000000d02000000L, 0x0000000d19000000L, 0x0000000c30000000L, 0x0000000c2b000000L, 0x0000000c06000000L, 0x0000000c1d000000L, 0x0000000c5c000000L, 0x0000000c47000000L, 0x0000000c6a000000L, 0x0000000c71000000L, 0x0000000ce8000000L, 0x0000000cf3000000L, 0x0000000cde000000L, 0x0000000cc5000000L, 0x0000000c84000000L, 0x0000000c9f000000L, 0x0000000cb2000000L, 0x0000000ca9000000L, 0x0000000ee0000000L, 0x0000000efb000000L, 0x0000000ed6000000L, 0x0000000ecd000000L, 0x0000000e8c000000L, 0x0000000e97000000L, 0x0000000eba000000L, 0x0000000ea1000000L, 0x0000000e38000000L, 0x0000000e23000000L, 0x0000000e0e000000L, 0x0000000e15000000L, 0x0000000e54000000L, 0x0000000e4f000000L, 0x0000000e62000000L, 0x0000000e79000000L, 0x0000000f50000000L, 0x0000000f4b000000L, 0x0000000f66000000L, 0x0000000f7d000000L, 0x0000000f3c000000L, 0x0000000f27000000L, 0x0000000f0a000000L, 0x0000000f11000000L, 0x0000000f88000000L, 0x0000000f93000000L, 0x0000000fbe000000L, 0x0000000fa5000000L, 0x0000000fe4000000L, 0x0000000fff000000L, 0x0000000fd2000000L, 0x0000000fc9000000L, 0x0000000b40000000L, 0x0000000b5b000000L, 0x0000000b76000000L, 0x0000000b6d000000L, 0x0000000b2c000000L, 0x0000000b37000000L, 0x0000000b1a000000L, 0x0000000b01000000L, 0x0000000b98000000L, 0x0000000b83000000L, 0x0000000bae000000L, 0x0000000bb5000000L, 0x0000000bf4000000L, 0x0000000bef000000L, 0x0000000bc2000000L, 0x0000000bd9000000L, 0x0000000af0000000L, 0x0000000aeb000000L, 0x0000000ac6000000L, 0x0000000add000000L, 0x0000000a9c000000L, 0x0000000a87000000L, 0x0000000aaa000000L, 0x0000000ab1000000L, 0x0000000a28000000L, 0x0000000a33000000L, 0x0000000a1e000000L, 0x0000000a05000000L, 0x0000000a44000000L, 0x0000000a5f000000L, 0x0000000a72000000L, 0x0000000a69000000L, 0x0000000820000000L, 0x000000083b000000L, 0x0000000816000000L, 0x000000080d000000L, 0x000000084c000000L, 0x0000000857000000L, 0x000000087a000000L, 0x0000000861000000L, 0x00000008f8000000L, 0x00000008e3000000L, 0x00000008ce000000L, 0x00000008d5000000L, 0x0000000894000000L, 0x000000088f000000L, 0x00000008a2000000L, 0x00000008b9000000L, 0x0000000990000000L, 0x000000098b000000L, 0x00000009a6000000L, 0x00000009bd000000L, 0x00000009fc000000L, 0x00000009e7000000L, 0x00000009ca000000L, 0x00000009d1000000L, 0x0000000948000000L, 0x0000000953000000L, 0x000000097e000000L, 0x0000000965000000L, 0x0000000924000000L, 0x000000093f000000L, 0x0000000912000000L, 0x0000000909000000L },
		{ 0x0000000000000000L, 0x00000000001b0000L, 0x0000000000360000L, 0x00000000002d0000L, 0x00000000006c0000L, 0x0000000000770000L, 0x00000000005a0000L, 0x0000000000410000L, 0x0000000000d80000L, 0x0000000000c30000L, 0x0000000000ee0000L, 0x0000000000f50000L, 0x0000000000b40000L, 0x0000000000af0000L, 0x0000000000820000L, 0x0000000000990000L, 0x0000000001b00000L, 0x0000000001ab0000L, 0x0000000001860000L, 0x00000000019d0000L, 0x0000000001dc0000L, 0x0000000001c70000L, 0x0000000001ea0000L, 0x0000000001f10000L, 0x0000000001680000L, 0x0000000001730000L, 0x00000000015e0000L, 0x0000000001450000L, 0x0000000001040000L, 0x00000000011f0000L, 0x0000000001320000L, 0x0000000001290000L, 0x0000000003600000L, 0x00000000037b0000L, 0x0000000003560000L, 0x00000000034d0000L, 0x00000000030c0000L, 0x0000000003170000L, 0x00000000033a0000L, 0x0000000003210000L, 0x0000000003b80000L, 0x0000000003a30000L, 0x00000000038e0000L, 0x0000000003950000L, 0x0000000003d40000L, 0x0000000003cf0000L, 0x0000000003e20000L, 0x0000000003f90000L, 0x0000000002d00000L, 0x0000000002cb0000L, 0x0000000002e60000L, 0x0000000002fd0000L, 0x0000000002bc0000L, 0x0000000002a70000L, 0x00000000028a0000L, 0x0000000002910000L, 0x0000000002080000L, 0x0000000002130000L, 0x00000000023e0000L, 0x0000000002250000L, 0x0000000002640000L, 0x00000000027f0000L, 0x0000000002520000L, 0x0000000002490000L, 0x0000000006c00000L, 0x0000000006db0000L, 0x0000000006f60000L, 0x0000000006ed0000L, 0x0000000006ac0000L, 0x0000000006b70000L, 0x00000000069a0000L, 0x0000000006810000L, 0x0000000006180000L, 0x0000000006030000L, 0x00000000062e0000L, 0x0000000006350000L, 0x0000000006740000L, 0x00000000066f0000L, 0x0000000006420000L, 0x0000000006590000L, 0x0000000007700000L, 0x00000000076b0000L, 0x0000000007460000L, 0x00000000075d0000L, 0x00000000071c0000L, 0x0000000007070000L, 0x00000000072a0000L, 0x0000000007310000L, 0x0000000007a80000L, 0x0000000007b30000L, 0x00000000079e0000L, 0x0000000007850000L, 0x0000000007c40000L, 0x0000000007df0000L, 0x0000000007f20000L, 0x0000000007e90000L, 0x0000000005a00000L, 0x0000000005bb0000L, 0x0000000005960000L, 0x00000000058d0000L, 0x0000000005cc0000L, 0x0000000005d70000L, 0x0000000005fa0000L, 0x0000000005e10000L, 0x0000000005780000L, 0x0000000005630000L, 0x00000000054e0000L, 0x0000000005550000L, 0x0000000005140000L, 0x00000000050f0000L, 0x0000000005220000L, 0x0000000005390000L, 0x0000000004100000L, 0x00000000040b0000L, 0x0000000004260000L, 0x00000000043d0000L, 0x00000000047c0000L, 0x0000000004670000L, 0x00000000044a0000L, 0x0000000004510000L, 0x0000000004c80000L, 0x0000000004d30000L, 0x0000000004fe0000L, 0x0000000004e50000L, 0x0000000004a40000L, 0x0000000004bf0000L, 0x0000000004920000L, 0x0000000004890000L, 0x000000000d800000L, 0x000000000d9b0000L, 0x000000000db60000L, 0x000000000dad0000L, 0x000000000dec0000L, 0x000000000df70000L, 0x000000000dda0000L, 0x000000000dc10000L, 0x000000000d580000L, 0x000000000d430000L, 0x000000000d6e0000L, 0x000000000d750000L, 0x000000000d340000L, 0x000000000d2f0000L, 0x000000000d020000L, 0x000000000d190000L, 0x000000000c300000L, 0x000000000c2b0000L, 0x000000000c060000L, 0x000000000c1d0000L, 0x000000000c5c0000L, 0x000000000c470000L, 0x000000000c6a0000L, 0x000000000c710000L, 0x000000000ce80000L, 0x000000000cf30000L, 0x000000000cde0000L, 0x000000000cc50000L, 0x000000000c840000L, 0x000000000c9f0000L, 0x000000000cb20000L, 0x000000000ca90000L, 0x000000000ee00000L, 0x000000000efb0000L, 0x000000000ed60000L, 0x000000000ecd0000L, 0x000000000e8c0000L, 0x000000000e970000L, 0x000000000eba0000L, 0x000000000ea10000L, 0x000000000e380000L, 0x000000000e230000L, 0x000000000e0e0000L, 0x000000000e150000L, 0x000000000e540000L, 0x000000000e4f0000L, 0x000000000e620000L, 0x000000000e790000L, 0x000000000f500000L, 0x000000000f4b0000L, 0x000000000f660000L, 0x000000000f7d0000L, 0x000000000f3c0000L, 0x000000000f270000L, 0x000000000f0a0000L, 0x000000000f110000L, 0x000000000f880000L, 0x000000000f930000L, 0x000000000fbe0000L, 0x000000000fa50000L, 0x000000000fe40000L, 0x000000000fff0000L, 0x000000000fd20000L, 0x000000000fc90000L, 0x000000000b400000L, 0x000000000b5b0000L, 0x000000000b760000L, 0x000000000b6d0000L, 0x000000000b2c0000L, 0x000000000b370000L, 0x000000000b1a0000L, 0x000000000b010000L, 0x000000000b980000L, 0x000000000b830000L, 0x000000000bae0000L, 0x000000000bb50000L, 0x000000000bf40000L, 0x000000000bef0000L, 0x000000000bc20000L, 0x000000000bd90000L, 0x000000000af00000L, 0x000000000aeb0000L, 0x000000000ac60000L, 0x000000000add0000L, 0x000000000a9c0000L, 0x000000000a870000L, 0x000000000aaa0000L, 0x000000000ab10000L, 0x000000000a280000L, 0x000000000a330000L, 0x000000000a1e0000L, 0x000000000a050000L, 0x000000000a440000L, 0x000000000a5f0000L, 0x000000000a720000L, 0x000000000a690000L, 0x0000000008200000L, 0x00000000083b0000L, 0x0000000008160000L, 0x00000000080d0000L, 0x00000000084c0000L, 0x0000000008570000L, 0x00000000087a0000L, 0x0000000008610000L, 0x0000000008f80000L, 0x0000000008e30000L, 0x0000000008ce0000L, 0x0000000008d50000L, 0x0000000008940000L, 0x00000000088f0000L, 0x0000000008a20000L, 0x0000000008b90000L, 0x0000000009900000L, 0x00000000098b0000L, 0x0000000009a60000L, 0x0000000009bd0000L, 0x0000000009fc0000L, 0x0000000009e70000L, 0x0000000009ca0000L, 0x0000000009d10000L, 0x0000000009480000L, 0x0000000009530000L, 0x00000000097e0000L, 0x0000000009650000L, 0x0000000009240000L, 0x00000000093f0000L, 0x0000000009120000L, 0x0000000009090000L },
		{ 0x0000000000000000L, 0x0000000000001b00L, 0x0000000000003600L, 0x0000000000002d00L, 0x0000000000006c00L, 0x0000000000007700L, 0x0000000000005a00L, 0x0000000000004100L, 0x000000000000d800L, 0x000000000000c300L, 0x000000000000ee00L, 0x000000000000f500L, 0x000000000000b400L, 0x000000000000af00L, 0x0000000000008200L, 0x0000000000009900L, 0x000000000001b000L, 0x000000000001ab00L, 0x0000000000018600L, 0x0000000000019d00L, 0x000000000001dc00L, 0x000000000001c700L, 0x000000000001ea00L, 0x000000000001f100L, 0x0000000000016800L, 0x0000000000017300L, 0x0000000000015e00L, 0x0000000000014500L, 0x0000000000010400L, 0x0000000000011f00L, 0x0000000000013200L, 0x0000000000012900L, 0x0000000000036000L, 0x0000000000037b00L, 0x0000000000035600L, 0x0000000000034d00L, 0x0000000000030c00L, 0x0000000000031700L, 0x0000000000033a00L, 0x0000000000032100L, 0x000000000003b800L, 0x000000000003a300L, 0x0000000000038e00L, 0x0000000000039500L, 0x000000000003d400L, 0x000000000003cf00L, 0x000000000003e200L, 0x000000000003f900L, 0x000000000002d000L, 0x000000000002cb00L, 0x000000000002e600L, 0x000000000002fd00L, 0x000000000002bc00L, 0x000000000002a700L, 0x0000000000028a00L, 0x0000000000029100L, 0x0000000000020800L, 0x0000000000021300L, 0x0000000000023e00L, 0x0000000000022500L, 0x0000000000026400L, 0x0000000000027f00L, 0x0000000000025200L, 0x0000000000024900L, 0x000000000006c000L, 0x000000000006db00L, 0x000000000006f600L, 0x000000000006ed00L, 0x000000000006ac00L, 0x000000000006b700L, 0x0000000000069a00L, 0x0000000000068100L, 0x0000000000061800L, 0x0000000000060300L, 0x0000000000062e00L, 0x0000000000063500L, 0x0000000000067400L, 0x0000000000066f00L, 0x0000000000064200L, 0x0000000000065900L, 0x0000000000077000L, 0x0000000000076b00L, 0x0000000000074600L, 0x0000000000075d00L, 0x0000000000071c00L, 0x0000000000070700L, 0x0000000000072a00L, 0x0000000000073100L, 0x000000000007a800L, 0x000000000007b300L, 0x0000000000079e00L, 0x0000000000078500L, 0x000000000007c400L, 0x000000000007df00L, 0x000000000007f200L, 0x000000000007e900L, 0x000000000005a000L, 0x000000000005bb00L, 0x0000000000059600L, 0x0000000000058d00L, 0x000000000005cc00L, 0x000000000005d700L, 0x000000000005fa00L, 0x000000000005e100L, 0x0000000000057800L, 0x0000000000056300L, 0x0000000000054e00L, 0x0000000000055500L, 0x0000000000051400L, 0x0000000000050f00L, 0x0000000000052200L, 0x0000000000053900L, 0x0000000000041000L, 0x0000000000040b00L, 0x0000000000042600L, 0x0000000000043d00L, 0x0000000000047c00L, 0x0000000000046700L, 0x0000000000044a00L, 0x0000000000045100L, 0x000000000004c800L, 0x000000000004d300L, 0x000000000004fe00L, 0x000000000004e500L, 0x000000000004a400L, 0x000000000004bf00L, 0x0000000000049200L, 0x0000000000048900L, 0x00000000000d8000L, 0x00000000000d9b00L, 0x00000000000db600L, 0x00000000000dad00L, 0x00000000000dec00L, 0x00000000000df700L, 0x00000000000dda00L, 0x00000000000dc100L, 0x00000000000d5800L, 0x00000000000d4300L, 0x00000000000d6e00L, 0x00000000000d7500L, 0x00000000000d3400L, 0x00000000000d2f00L, 0x00000000000d0200L, 0x00000000000d1900L, 0x00000000000c3000L, 0x00000000000c2b00L, 0x00000000000c0600L, 0x00000000000c1d00L, 0x00000000000c5c00L, 0x00000000000c4700L, 0x00000000000c6a00L, 0x00000000000c7100L, 0x00000000000ce800L, 0x00000000000cf300L, 0x00000000000cde00L, 0x00000000000cc500L, 0x00000000000c8400L, 0x00000000000c9f00L, 0x00000000000cb200L, 0x00000000000ca900L, 0x00000000000ee000L, 0x00000000000efb00L, 0x00000000000ed600L, 0x00000000000ecd00L, 0x00000000000e8c00L, 0x00000000000e9700L, 0x00000000000eba00L, 0x00000000000ea100L, 0x00000000000e3800L, 0x00000000000e2300L, 0x00000000000e0e00L, 0x00000000000e1500L, 0x00000000000e5400L, 0x00000000000e4f00L, 0x00000000000e6200L, 0x00000000000e7900L, 0x00000000000f5000L, 0x00000000000f4b00L, 0x00000000000f6600L, 0x00000000000f7d00L, 0x00000000000f3c00L, 0x00000000000f2700L, 0x00000000000f0a00L, 0x00000000000f1100L, 0x00000000000f8800L, 0x00000000000f9300L, 0x00000000000fbe00L, 0x00000000000fa500L, 0x00000000000fe400L, 0x00000000000fff00L, 0x00000000000fd200L, 0x00000000000fc900L, 0x00000000000b4000L, 0x00000000000b5b00L, 0x00000000000b7600L, 0x00000000000b6d00L, 0x00000000000b2c00L, 0x00000000000b3700L, 0x00000000000b1a00L, 0x00000000000b0100L, 0x00000000000b9800L, 0x00000000000b8300L, 0x00000000000bae00L, 0x00000000000bb500L, 0x00000000000bf400L, 0x00000000000bef00L, 0x00000000000bc200L, 0x00000000000bd900L, 0x00000000000af000L, 0x00000000000aeb00L, 0x00000000000ac600L, 0x00000000000add00L, 0x00000000000a9c00L, 0x00000000000a8700L, 0x00000000000aaa00L, 0x00000000000ab100L, 0x00000000000a2800L, 0x00000000000a3300L, 0x00000000000a1e00L, 0x00000000000a0500L, 0x00000000000a4400L, 0x00000000000a5f00L, 0x00000000000a7200L, 0x00000000000a6900L, 0x0000000000082000L, 0x0000000000083b00L, 0x0000000000081600L, 0x0000000000080d00L, 0x0000000000084c00L, 0x0000000000085700L, 0x0000000000087a00L, 0x0000000000086100L, 0x000000000008f800L, 0x000000000008e300L, 0x000000000008ce00L, 0x000000000008d500L, 0x0000000000089400L, 0x0000000000088f00L, 0x000000000008a200L, 0x000000000008b900L, 0x0000000000099000L, 0x0000000000098b00L, 0x000000000009a600L, 0x000000000009bd00L, 0x000000000009fc00L, 0x000000000009e700L, 0x000000000009ca00L, 0x000000000009d100L, 0x0000000000094800L, 0x0000000000095300L, 0x0000000000097e00L, 0x0000000000096500L, 0x0000000000092400L, 0x0000000000093f00L, 0x0000000000091200L, 0x0000000000090900L },
		{ 0x0000000000000000L, 0x000000000000001bL, 0x0000000000000036L, 0x000000000000002dL, 0x000000000000006cL, 0x0000000000000077L, 0x000000000000005aL, 0x0000000000000041L, 0x00000000000000d8L, 0x00000000000000c3L, 0x00000000000000eeL, 0x00000000000000f5L, 0x00000000000000b4L, 0x00000000000000afL, 0x0000000000000082L, 0x0000000000000099L, 0x00000000000001b0L, 0x00000000000001abL, 0x0000000000000186L, 0x000000000000019dL, 0x00000000000001dcL, 0x00000000000001c7L, 0x00000000000001eaL, 0x00000000000001f1L, 0x0000000000000168L, 0x0000000000000173L, 0x000000000000015eL, 0x0000000000000145L, 0x0000000000000104L, 0x000000000000011fL, 0x0000000000000132L, 0x0000000000000129L, 0x0000000000000360L, 0x000000000000037bL, 0x0000000000000356L, 0x000000000000034dL, 0x000000000000030cL, 0x0000000000000317L, 0x000000000000033aL, 0x0000000000000321L, 0x00000000000003b8L, 0x00000000000003a3L, 0x000000000000038eL, 0x0000000000000395L, 0x00000000000003d4L, 0x00000000000003cfL, 0x00000000000003e2L, 0x00000000000003f9L, 0x00000000000002d0L, 0x00000000000002cbL, 0x00000000000002e6L, 0x00000000000002fdL, 0x00000000000002bcL, 0x00000000000002a7L, 0x000000000000028aL, 0x0000000000000291L, 0x0000000000000208L, 0x0000000000000213L, 0x000000000000023eL, 0x0000000000000225L, 0x0000000000000264L, 0x000000000000027fL, 0x0000000000000252L, 0x0000000000000249L, 0x00000000000006c0L, 0x00000000000006dbL, 0x00000000000006f6L, 0x00000000000006edL, 0x00000000000006acL, 0x00000000000006b7L, 0x000000000000069aL, 0x0000000000000681L, 0x0000000000000618L, 0x0000000000000603L, 0x000000000000062eL, 0x0000000000000635L, 0x0000000000000674L, 0x000000000000066fL, 0x0000000000000642L, 0x0000000000000659L, 0x0000000000000770L, 0x000000000000076bL, 0x0000000000000746L, 0x000000000000075dL, 0x000000000000071cL, 0x0000000000000707L, 0x000000000000072aL, 0x0000000000000731L, 0x00000000000007a8L, 0x00000000000007b3L, 0x000000000000079eL, 0x0000000000000785L, 0x00000000000007c4L, 0x00000000000007dfL, 0x00000000000007f2L, 0x00000000000007e9L, 0x00000000000005a0L, 0x00000000000005bbL, 0x0000000000000596L, 0x000000000000058dL, 0x00000000000005ccL, 0x00000000000005d7L, 0x00000000000005faL, 0x00000000000005e1L, 0x0000000000000578L, 0x0000000000000563L, 0x000000000000054eL, 0x0000000000000555L, 0x0000000000000514L, 0x000000000000050fL, 0x0000000000000522L, 0x0000000000000539L, 0x0000000000000410L, 0x000000000000040bL, 0x0000000000000426L, 0x000000000000043dL, 0x000000000000047cL, 0x0000000000000467L, 0x000000000000044aL, 0x0000000000000451L, 0x00000000000004c8L, 0x00000000000004d3L, 0x00000000000004feL, 0x00000000000004e5L, 0x00000000000004a4L, 0x00000000000004bfL, 0x0000000000000492L, 0x0000000000000489L, 0x0000000000000d80L, 0x0000000000000d9bL, 0x0000000000000db6L, 0x0000000000000dadL, 0x0000000000000decL, 0x0000000000000df7L, 0x0000000000000ddaL, 0x0000000000000dc1L, 0x0000000000000d58L, 0x0000000000000d43L, 0x0000000000000d6eL, 0x0000000000000d75L, 0x0000000000000d34L, 0x0000000000000d2fL, 0x0000000000000d02L, 0x0000000000000d19L, 0x0000000000000c30L, 0x0000000000000c2bL, 0x0000000000000c06L, 0x0000000000000c1dL, 0x0000000000000c5cL, 0x0000000000000c47L, 0x0000000000000c6aL, 0x0000000000000c71L, 0x0000000000000ce8L, 0x0000000000000cf3L, 0x0000000000000cdeL, 0x0000000000000cc5L, 0x0000000000000c84L, 0x0000000000000c9fL, 0x0000000000000cb2L, 0x0000000000000ca9L, 0x0000000000000ee0L, 0x0000000000000efbL, 0x0000000000000ed6L, 0x0000000000000ecdL, 0x0000000000000e8cL, 0x0000000000000e97L, 0x0000000000000ebaL, 0x0000000000000ea1L, 0x0000000000000e38L, 0x0000000000000e23L, 0x0000000000000e0eL, 0x0000000000000e15L, 0x0000000000000e54L, 0x0000000000000e4fL, 0x0000000000000e62L, 0x0000000000000e79L, 0x0000000000000f50L, 0x0000000000000f4bL, 0x0000000000000f66L, 0x0000000000000f7dL, 0x0000000000000f3cL, 0x0000000000000f27L, 0x0000000000000f0aL, 0x0000000000000f11L, 0x0000000000000f88L, 0x0000000000000f93L, 0x0000000000000fbeL, 0x0000000000000fa5L, 0x0000000000000fe4L, 0x0000000000000fffL, 0x0000000000000fd2L, 0x0000000000000fc9L, 0x0000000000000b40L, 0x0000000000000b5bL, 0x0000000000000b76L, 0x0000000000000b6dL, 0x0000000000000b2cL, 0x0000000000000b37L, 0x0000000000000b1aL, 0x0000000000000b01L, 0x0000000000000b98L, 0x0000000000000b83L, 0x0000000000000baeL, 0x0000000000000bb5L, 0x0000000000000bf4L, 0x0000000000000befL, 0x0000000000000bc2L, 0x0000000000000bd9L, 0x0000000000000af0L, 0x0000000000000aebL, 0x0000000000000ac6L, 0x0000000000000addL, 0x0000000000000a9cL, 0x0000000000000a87L, 0x0000000000000aaaL, 0x0000000000000ab1L, 0x0000000000000a28L, 0x0000000000000a33L, 0x0000000000000a1eL, 0x0000000000000a05L, 0x0000000000000a44L, 0x0000000000000a5fL, 0x0000000000000a72L, 0x0000000000000a69L, 0x0000000000000820L, 0x000000000000083bL, 0x0000000000000816L, 0x000000000000080dL, 0x000000000000084cL, 0x0000000000000857L, 0x000000000000087aL, 0x0000000000000861L, 0x00000000000008f8L, 0x00000000000008e3L, 0x00000000000008ceL, 0x00000000000008d5L, 0x0000000000000894L, 0x000000000000088fL, 0x00000000000008a2L, 0x00000000000008b9L, 0x0000000000000990L, 0x000000000000098bL, 0x00000000000009a6L, 0x00000000000009bdL, 0x00000000000009fcL, 0x00000000000009e7L, 0x00000000000009caL, 0x00000000000009d1L, 0x0000000000000948L, 0x0000000000000953L, 0x000000000000097eL, 0x0000000000000965L, 0x0000000000000924L, 0x000000000000093fL, 0x0000000000000912L, 0x0000000000000909L },
	};

	/**
	 * Computes the 64 bit CRC of a byte array.
	 *
	 * @param x the byte array to CRC.
	 * @return the CRC.
	 */
	public static long compute(final byte x[]) {
		long w1 = 0, w2 = 0;
		int i;
		final int l = x.length, /* The length of the argument. */
		r = l % 8; /* The length mod 8. */

		/* We must prefix the array with 1. */

		w1 = 1L << 8 * r;
		for (i = 0; i < r; i++)
			w1 |= ((long)x[i] & 0xFF) << 8 * (r - 1 - i);

		w2 = T[0][(int)(w1 >>> 56)] ^ T[1][(int)(w1 >>> 48 & 0xFF)] ^ T[2][(int)(w1 >>> 40 & 0xFF)] ^ T[3][(int)(w1 >>> 32 & 0xFF)] ^ T[4][(int)(w1 >>> 24 & 0xFF)]
				^ T[5][(int)(w1 >>> 16 & 0xFF)] ^ T[6][(int)(w1 >>> 8 & 0xFF)] ^ T[7][(int)(w1 & 0xFF)];

		for (; i < l; i += 8) {


			w1 = w2
					^ (((long)x[i] & 0xFF) << 56 | ((long)x[i + 1] & 0xFF) << 48 | ((long)x[i + 2] & 0xFF) << 40 | ((long)x[i + 3] & 0xFF) << 32 | ((long)x[i + 4] & 0xFF) << 24
							| ((long)x[i + 5] & 0xFF) << 16 | ((long)x[i + 6] & 0xFF) << 8 | ((long)x[i + 7] & 0xFF));

			w2 = T[0][(int)(w1 >>> 56)] ^ T[1][(int)(w1 >>> 48 & 0xFF)] ^ T[2][(int)(w1 >>> 40 & 0xFF)] ^ T[3][(int)(w1 >>> 32 & 0xFF)] ^ T[4][(int)(w1 >>> 24 & 0xFF)]
					^ T[5][(int)(w1 >>> 16 & 0xFF)] ^ T[6][(int)(w1 >>> 8 & 0xFF)] ^ T[7][(int)(w1 & 0xFF)];

		}

		return w1;
	}

	/**
	 * Computes the 64 bit CRC of a character array fragment.
	 *
	 * @param x the array to CRC.
	 * @param off the offset inside <code>x</code>.
	 * @param len the number of characters to CRC.
	 * @return the CRC.
	 */
	public static long compute(final char x[], final int off, final int len) {
		long w1 = 0, w2 = 0;
		int i, r = len % 8; /* The length mod 8. */

		/* We must prefix the array with 1. */

		w1 = 1L << 8 * r;
		for (i = 0; i < r; i++)
			w1 |= ((long)x[off + i] & 0xFF) << 8 * (r - 1 - i);

		w2 = T[0][(int)(w1 >>> 56)] ^ T[1][(int)(w1 >>> 48 & 0xFF)] ^ T[2][(int)(w1 >>> 40 & 0xFF)] ^ T[3][(int)(w1 >>> 32 & 0xFF)] ^ T[4][(int)(w1 >>> 24 & 0xFF)]
				^ T[5][(int)(w1 >>> 16 & 0xFF)] ^ T[6][(int)(w1 >>> 8 & 0xFF)] ^ T[7][(int)(w1 & 0xFF)];

		for (; i < len; i += 8) {


			w1 = w2
					^ (((long)x[off + i] & 0xFF) << 56 | ((long)x[off + i + 1] & 0xFF) << 48 | ((long)x[off + i + 2] & 0xFF) << 40 | ((long)x[off + i + 3] & 0xFF) << 32
							| ((long)x[off + i + 4] & 0xFF) << 24 | ((long)x[off + i + 5] & 0xFF) << 16 | ((long)x[off + i + 6] & 0xFF) << 8 | ((long)x[off + i + 7] & 0xFF));

			w2 = T[0][(int)(w1 >>> 56)] ^ T[1][(int)(w1 >>> 48 & 0xFF)] ^ T[2][(int)(w1 >>> 40 & 0xFF)] ^ T[3][(int)(w1 >>> 32 & 0xFF)] ^ T[4][(int)(w1 >>> 24 & 0xFF)]
					^ T[5][(int)(w1 >>> 16 & 0xFF)] ^ T[6][(int)(w1 >>> 8 & 0xFF)] ^ T[7][(int)(w1 & 0xFF)];

		}

		return w1;
	}

	/**
	 * Computes the 64 bit CRC of a string, using the ISO8859-1 representation of its Unicode
	 * characters.
	 *
	 * @param s the byte array to CRC.
	 * @return the CRC.
	 */
	public static long compute(String s) {
		try {
			return compute(s.getBytes("ISO8859-1"));
		}
		catch (java.io.UnsupportedEncodingException cantHappen) {
			// Every Java release should know about ISO8859-1 encoding!
			return 0;
		}
	}

	/**
	 * Computes the 64 bit CRC of a mutable string, using the ISO8859-1 representation of its
	 * Unicode characters.
	 *
	 * @param s the mutable string to CRC.
	 * @return the CRC.
	 */
	public static long compute(MutableString s) {
		return compute(s.array(), 0, s.length());
	}

}
