package it.unimi.dsi.law.fibrations;

/*
 * Copyright (C) 2005-2020 Sebastiano Vigna
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

//RELEASE-STATUS: DIST

/** A colouring on the nodes. It is given by a {@link #colour(int)} function
 * that returns the colour of a node.
 */
public interface NodeColouringStrategy {
	/** Returns the colour for node <code>x</code>.
	 *
	 * @param x a node.
	 * @return the colour of <code>x</code>.
	 */

	public int colour(int x);
}
