package it.unimi.dsi.law.fibrations;

/*
 * Copyright (C) 2005-2020 Sebastiano Vigna
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

//RELEASE-STATUS: DIST

/** A colouring on the arcs. It is given by a {@link #colour(int, int)} function
 * that returns the colour of the arc between two nodes. For simplicity of implementation,
 * the function is allowed to return a value <em>even if the arc does not exist</em>.
 */
public interface ArcColouringStrategy {
	/** Returns the colour for the arc from <code>x</code> to <code>y</code>.
	 *
	 * <p>This method is allows to return a value even if there is not
	 * arc from <code>x</code> to <code>y</code>.
	 *
	 * @param x a node.
	 * @param y another node.
	 * @return the colour on the arc from <code>x</code> to <code>y</code>, or
	 * an undefined value if no such arc exists.
	 */

	public int colour(int x, int y);
}
