/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.util;

import java.util.Arrays;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.util.EncodingUtils;
import org.apache.http.util.EntityUtils;

public class StringHttpMessages {
    private static final ProtocolVersion PROTOCOL_VERSION = new ProtocolVersion("HTTP", 1, 1);

    public static class HttpResponse
    extends AbstractHttpMessage
    implements org.apache.http.HttpResponse {
        private final StatusLine statusLine;
        private final HttpEntity entity;

        public HttpResponse(int status, String reason, byte[] content, int contentLength, ContentType type) {
            this.statusLine = new BasicStatusLine(PROTOCOL_VERSION, status, reason);
            this.addHeader("Content-Length", Integer.toString(contentLength));
            this.addHeader("Content-Type", type.toString());
            this.entity = new ByteArrayEntity(content, 0, contentLength, type);
        }

        public HttpResponse(String content) {
            this(200, "OK", content, ContentType.TEXT_HTML);
        }

        public HttpResponse(String content, ContentType type) {
            this(200, "OK", content, type);
        }

        public HttpResponse(int status, String reason, String content, ContentType type) {
            this(status, reason, EncodingUtils.getBytes((String)content, (String)type.getCharset().toString()), type);
        }

        public HttpResponse(int status, String reason, byte[] content, ContentType type) {
            this(status, reason, content, content.length, type);
        }

        public ProtocolVersion getProtocolVersion() {
            return PROTOCOL_VERSION;
        }

        public StatusLine getStatusLine() {
            return this.statusLine;
        }

        public HttpEntity getEntity() {
            return this.entity;
        }

        public String toString() {
            try {
                return "StatusLine: " + this.statusLine.toString() + "\nHeaders: " + Arrays.toString(this.getAllHeaders()) + "\nContent: " + EntityUtils.toString((HttpEntity)this.entity);
            }
            catch (Exception ingored) {
                return "";
            }
        }

        public void setStatusLine(StatusLine statusline) {
            throw new UnsupportedOperationException();
        }

        public void setStatusLine(ProtocolVersion ver, int code) {
            throw new UnsupportedOperationException();
        }

        public void setStatusLine(ProtocolVersion ver, int code, String reason) {
            throw new UnsupportedOperationException();
        }

        public void setStatusCode(int code) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public void setReasonPhrase(String reason) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public void setEntity(HttpEntity entity) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public Locale getLocale() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public void setLocale(Locale loc) {
            throw new UnsupportedOperationException();
        }
    }

    public static class HttpRequest
    extends AbstractHttpMessage
    implements org.apache.http.HttpRequest {
        private final RequestLine requestLine;

        public HttpRequest(String method, String url) {
            this.requestLine = new BasicRequestLine(method, url, PROTOCOL_VERSION);
        }

        public ProtocolVersion getProtocolVersion() {
            return PROTOCOL_VERSION;
        }

        public RequestLine getRequestLine() {
            return this.requestLine;
        }
    }
}

