/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.util;

import it.unimi.di.law.bubing.util.TooSlowException;
import it.unimi.dsi.fastutil.io.InspectableFileCachedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.http.HttpEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class InspectableCachedHttpEntity
extends HttpEntityWrapper {
    private static final int BUFFER_SIZE = 8192;
    private static final HttpEntity THROW_AWAY_ENTITY = new BasicHttpEntity();
    private final InspectableFileCachedInputStream cachedContent;
    private final byte[] buffer;
    private final ByteBuffer byteBuffer;

    public InspectableCachedHttpEntity(InspectableFileCachedInputStream cachedContent) {
        super(THROW_AWAY_ENTITY);
        this.cachedContent = cachedContent;
        this.buffer = new byte[8192];
        this.byteBuffer = ByteBuffer.wrap(this.buffer);
    }

    public void setEntity(HttpEntity wrappedEntity) throws IOException {
        this.wrappedEntity = wrappedEntity;
        this.cachedContent.clear();
    }

    public boolean copyContent(long maxLength, long startTime, long minDelay, long minBytesPerSecond) throws IOException, TooSlowException {
        if (this.wrappedEntity == THROW_AWAY_ENTITY) {
            throw new IllegalStateException();
        }
        InputStream content = this.wrappedEntity.getContent();
        if (maxLength != 0L) {
            int r;
            long count = 0L;
            while ((r = content.read(this.buffer, 0, (int)Math.min(8192L, maxLength - count))) != -1) {
                this.byteBuffer.clear().limit(r);
                this.cachedContent.write(this.byteBuffer);
                if ((count += (long)r) == maxLength) break;
                long delay = System.currentTimeMillis() - startTime;
                double bytesPerSecond = (double)count / ((double)delay / 1000.0);
                if (delay <= minDelay || !(bytesPerSecond < (double)minBytesPerSecond)) continue;
                throw new TooSlowException(bytesPerSecond + " B/s");
            }
        }
        return content.read(this.buffer, 0, 1) != -1;
    }

    public void clear() throws IOException {
        this.cachedContent.clear();
    }

    public InputStream getContent() throws IOException {
        if (this.cachedContent == null) {
            throw new IllegalStateException();
        }
        this.cachedContent.reopen();
        return this.cachedContent;
    }

    public long getContentLength() {
        if (this.cachedContent == null) {
            throw new IllegalStateException();
        }
        long length = -1L;
        try {
            length = this.cachedContent.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return length;
    }
}

