/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.util;

import com.google.common.io.ByteStreams;
import it.unimi.di.law.warc.util.HttpEntityFactory;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class FastByteArrayInputStreamHttpEntityFactory
implements HttpEntityFactory {
    protected FastByteArrayOutputStream cachedContent = new FastByteArrayOutputStream();

    @Override
    public HttpEntity newEntity(HttpEntity from) throws IOException {
        return new HttpEntityWrapper(from){
            private FastByteArrayInputStream content;
            {
                this.content = null;
            }

            public InputStream getContent() throws IOException {
                if (this.content != null) {
                    return this.content;
                }
                InputStream in = this.wrappedEntity.getContent();
                try {
                    ByteStreams.copy((InputStream)in, (OutputStream)FastByteArrayInputStreamHttpEntityFactory.this.cachedContent);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                this.content = new FastByteArrayInputStream(FastByteArrayInputStreamHttpEntityFactory.this.cachedContent.array, 0, FastByteArrayInputStreamHttpEntityFactory.this.cachedContent.length);
                this.content.position(0L);
                return this.content;
            }

            public long getContentLength() {
                if (this.content == null) {
                    throw new IllegalStateException();
                }
                return FastByteArrayInputStreamHttpEntityFactory.this.cachedContent.length;
            }
        };
    }
}

