/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.di.law.warc.io.CompressedWarcWriter;
import it.unimi.di.law.warc.io.UncompressedWarcReader;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarcCompressor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WarcCompressor.class);

    public static void main(String[] arg) throws IOException, InterruptedException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(WarcCompressor.class.getName(), "Given a store uncompressed, write a compressed store.", new Parameter[]{new FlaggedOption("output", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, 'o', "output", "The output filename  (- for stdout)."), new UnflaggedOption("store", (StringParser)JSAP.STRING_PARSER, false, "The name of the store (if omitted, stdin).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        InputStream in = jsapResult.userSpecified("store") ? new FastBufferedInputStream((InputStream)new FileInputStream(jsapResult.getString("store"))) : System.in;
        UncompressedWarcReader reader = new UncompressedWarcReader(in);
        ProgressLogger pl = new ProgressLogger(LOGGER, 1L, TimeUnit.MINUTES, "records");
        String output = jsapResult.getString("output");
        PrintStream out = "-".equals(output) ? System.out : new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(output)), false, "UTF-8");
        CompressedWarcWriter writer = new CompressedWarcWriter(out);
        pl.itemsName = "records";
        pl.displayFreeMemory = true;
        pl.displayLocalSpeed = true;
        pl.start((CharSequence)"Scanning...");
        long storePosition = 0L;
        while (true) {
            block4: {
                LOGGER.trace("STOREPOSITION " + storePosition);
                WarcRecord record = null;
                try {
                    record = reader.read();
                }
                catch (Exception e) {
                    LOGGER.error("Exception while reading record " + storePosition + " ");
                    LOGGER.error(e.getMessage());
                    e.printStackTrace();
                    break block4;
                }
                if (record == null) break;
                writer.write(record);
                pl.lightUpdate();
            }
            ++storePosition;
        }
        pl.done();
        writer.close();
    }
}

