/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.records;

import it.unimi.di.law.warc.records.HttpRequestWarcRecord;
import it.unimi.di.law.warc.records.HttpResponseWarcRecord;
import it.unimi.di.law.warc.records.InfoWarcRecord;
import it.unimi.di.law.warc.records.WarcHeader;
import it.unimi.di.law.warc.util.BoundSessionInputBuffer;
import it.unimi.di.law.warc.util.ByteArraySessionOutputBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Date;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.HeaderGroup;

public interface WarcRecord {
    public static final ProtocolVersion PROTOCOL_VERSION = new ProtocolVersion("WARC", 1, 0);

    public void write(OutputStream var1, ByteArraySessionOutputBuffer var2) throws IOException;

    public HeaderGroup getWarcHeaders();

    public Header getWarcHeader(WarcHeader.Name var1);

    public UUID getWarcRecordId();

    public Type getWarcType();

    public Date getWarcDate();

    public long getWarcContentLength();

    public URI getWarcTargetURI();

    public static enum Type {
        REQUEST("request"),
        RESPONSE("response"),
        WARCINFO("warcinfo");

        private final String value;
        static final Method REQUEST_READ_PAYLOAD;
        static final Method RESPONSE_READ_PAYLOAD;
        static final Method WARCINFO_READ_PAYLOAD;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Header warcHeader(Type type) {
            return new WarcHeader(WarcHeader.Name.WARC_TYPE, type.value);
        }

        public static Type valueOf(Header header) {
            if (!header.getName().equals(WarcHeader.Name.WARC_TYPE.value)) {
                throw new IllegalArgumentException("Wrong header type " + header.getName());
            }
            String type = header.getValue();
            if (type.equals(Type.RESPONSE.value)) {
                return RESPONSE;
            }
            if (type.equals(Type.REQUEST.value)) {
                return REQUEST;
            }
            if (type.equals(Type.WARCINFO.value)) {
                return WARCINFO;
            }
            throw new IllegalArgumentException("Unrecognized type " + type);
        }

        public static Method fromPayloadMethod(Header header) {
            String type = header.getValue();
            if (type.equals(Type.RESPONSE.value)) {
                return RESPONSE_READ_PAYLOAD;
            }
            if (type.equals(Type.REQUEST.value)) {
                return REQUEST_READ_PAYLOAD;
            }
            if (type.equals(Type.WARCINFO.value)) {
                return WARCINFO_READ_PAYLOAD;
            }
            throw new IllegalArgumentException("Unrecognized type " + type);
        }

        static {
            Method requestReadPayload = null;
            Method responseReadPayload = null;
            Method warcinfoReadPayload = null;
            try {
                requestReadPayload = HttpRequestWarcRecord.class.getMethod("fromPayload", HeaderGroup.class, BoundSessionInputBuffer.class);
                responseReadPayload = HttpResponseWarcRecord.class.getMethod("fromPayload", HeaderGroup.class, BoundSessionInputBuffer.class);
                warcinfoReadPayload = InfoWarcRecord.class.getMethod("fromPayload", HeaderGroup.class, BoundSessionInputBuffer.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            REQUEST_READ_PAYLOAD = requestReadPayload;
            RESPONSE_READ_PAYLOAD = responseReadPayload;
            WARCINFO_READ_PAYLOAD = warcinfoReadPayload;
        }
    }
}

