/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.records;

import it.unimi.di.law.warc.filters.URIResponse;
import it.unimi.di.law.warc.io.WarcFormatException;
import it.unimi.di.law.warc.records.AbstractWarcRecord;
import it.unimi.di.law.warc.records.WarcHeader;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.di.law.warc.util.BoundSessionInputBuffer;
import it.unimi.di.law.warc.util.ByteArraySessionOutputBuffer;
import it.unimi.di.law.warc.util.HttpEntityFactory;
import it.unimi.di.law.warc.util.IdentityHttpEntityFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.impl.io.DefaultHttpResponseParser;
import org.apache.http.impl.io.DefaultHttpResponseWriter;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.message.HeaderGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseWarcRecord
extends AbstractWarcRecord
implements HttpResponse,
URIResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseWarcRecord.class);
    public static final String HTTP_RESPONSE_MSGTYPE = "application/http;msgtype=response";
    private final ProtocolVersion protocolVersion;
    private final StatusLine statusLine;
    private final HttpEntity entity;

    public HttpResponseWarcRecord(URI targetURI, HttpResponse response) throws IOException {
        this(null, targetURI, response, null);
    }

    public HttpResponseWarcRecord(URI targetURI, HttpResponse response, HttpEntityFactory hef) throws IOException {
        this(null, targetURI, response, hef);
    }

    public static HttpResponseWarcRecord fromPayload(HeaderGroup warcHeaders, BoundSessionInputBuffer payloadBuffer) throws IOException {
        return new HttpResponseWarcRecord(warcHeaders, null, HttpResponseWarcRecord.readPayload(payloadBuffer), IdentityHttpEntityFactory.INSTANCE);
    }

    private HttpResponseWarcRecord(HeaderGroup warcHeaders, URI targetURI, HttpResponse response, HttpEntityFactory hef) throws IOException {
        super(targetURI, warcHeaders);
        this.getWarcTargetURI();
        this.warcHeaders.updateHeader(WarcRecord.Type.warcHeader(WarcRecord.Type.RESPONSE));
        this.warcHeaders.updateHeader((Header)new WarcHeader(WarcHeader.Name.CONTENT_TYPE, HTTP_RESPONSE_MSGTYPE));
        this.protocolVersion = response.getProtocolVersion();
        this.statusLine = response.getStatusLine();
        this.setHeaders(response.getAllHeaders());
        this.entity = (hef == null ? IdentityHttpEntityFactory.INSTANCE : hef).newEntity(response.getEntity());
    }

    private static HttpResponse readPayload(BoundSessionInputBuffer buffer) throws IOException {
        Header entityLengthHeader;
        HttpResponse response;
        DefaultHttpResponseParser responseParser = new DefaultHttpResponseParser((SessionInputBuffer)buffer);
        try {
            response = (HttpResponse)responseParser.parse();
        }
        catch (HttpException e) {
            throw new WarcFormatException("Can't parse the response", e);
        }
        long remaining = buffer.remaining();
        if (LOGGER.isDebugEnabled() && (entityLengthHeader = response.getFirstHeader("Content-Length")) != null) {
            try {
                long entityLength = Long.parseLong(entityLengthHeader.getValue());
                if (entityLength < remaining) {
                    LOGGER.debug("Content length header value {} is smaller than remaning bytes {}", (Object)entityLength, (Object)remaining);
                } else if (entityLength > remaining) {
                    LOGGER.debug("Content length header value {} is greater than remaning bytes {} (this is probably due to truncation)", (Object)entityLength, (Object)remaining);
                }
            }
            catch (NumberFormatException entityLength) {
                // empty catch block
            }
        }
        ContentLengthInputStream payload = new ContentLengthInputStream((SessionInputBuffer)buffer, remaining);
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContentLength(remaining);
        entity.setContent((InputStream)payload);
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        response.setEntity((HttpEntity)entity);
        return response;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    protected InputStream writePayload(ByteArraySessionOutputBuffer buffer) throws IOException {
        DefaultHttpResponseWriter pw = new DefaultHttpResponseWriter((SessionOutputBuffer)buffer);
        try {
            pw.write((HttpMessage)this);
        }
        catch (HttpException e) {
            throw new RuntimeException("Unexpected HttpException.", e);
        }
        buffer.contentLength((long)buffer.size() + this.entity.getContentLength());
        return new SequenceInputStream(buffer.toInputStream(), this.entity.getContent());
    }

    public String toString() {
        return "Warc headers: " + Arrays.toString(this.warcHeaders.getAllHeaders()) + "\nResponse status line: " + this.statusLine + "\nResponse headers: " + Arrays.toString(this.getAllHeaders());
    }

    public void setStatusLine(StatusLine statusline) {
        throw new UnsupportedOperationException();
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        throw new UnsupportedOperationException();
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        throw new UnsupportedOperationException();
    }

    public void setStatusCode(int code) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void setEntity(HttpEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setLocale(Locale loc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI uri() {
        return this.getWarcTargetURI();
    }

    @Override
    public HttpResponse response() {
        return this;
    }
}

