/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.processors;

import it.unimi.di.law.warc.processors.ParallelFilteredProcessorRunner;
import it.unimi.di.law.warc.records.HttpResponseWarcRecord;
import it.unimi.di.law.warc.records.WarcHeader;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.IOException;
import java.io.PrintStream;

public class URLDigestFinalPositionWriter
implements ParallelFilteredProcessorRunner.Writer<WarcRecord> {
    private long finalPosition;
    private final long storeIndexMask;
    private final LongOpenHashSet repeatedSet;

    public URLDigestFinalPositionWriter(String storeIndex, String repeatedSetFile) throws ClassNotFoundException, IOException, IllegalArgumentException {
        this.storeIndexMask = (long)Integer.parseInt(storeIndex) << 48;
        this.repeatedSet = (LongOpenHashSet)BinIO.loadObject((CharSequence)repeatedSetFile);
    }

    @Override
    public void write(WarcRecord warcRecord, long storePosition, PrintStream out) throws IOException {
        long l;
        if (this.repeatedSet.contains(this.storeIndexMask | storePosition)) {
            return;
        }
        boolean isDuplicate = warcRecord.getWarcHeader(WarcHeader.Name.BUBING_IS_DUPLICATE) != null;
        out.print(warcRecord.getWarcTargetURI());
        out.print('\t');
        out.print(warcRecord.getWarcHeader(WarcHeader.Name.WARC_PAYLOAD_DIGEST).getValue());
        out.print('\t');
        if (isDuplicate) {
            l = -1L;
        } else {
            long l2 = this.finalPosition;
            l = l2;
            this.finalPosition = l2 + 1L;
        }
        out.print(l);
        out.write(9);
        out.print(((HttpResponseWarcRecord)warcRecord).getStatusLine());
        out.write(10);
    }

    @Override
    public void close() throws IOException {
    }
}

