/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.processors;

import it.unimi.di.law.warc.processors.ParallelFilteredProcessorRunner;
import it.unimi.di.law.warc.records.HttpResponseWarcRecord;
import it.unimi.di.law.warc.records.WarcRecord;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseContentExtractor
implements ParallelFilteredProcessorRunner.Processor<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseContentExtractor.class);
    private static final ResponseContentExtractor INSTANCE = new ResponseContentExtractor();

    private ResponseContentExtractor() {
    }

    public static ResponseContentExtractor getInstance() {
        return INSTANCE;
    }

    @Override
    public String process(WarcRecord r, long storePosition) {
        if (r.getWarcType() != WarcRecord.Type.RESPONSE) {
            return null;
        }
        HttpResponseWarcRecord resp = (HttpResponseWarcRecord)r;
        try {
            return EntityUtils.toString((HttpEntity)resp.getEntity());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception during entity convertion to string", (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
    }

    public ResponseContentExtractor copy() {
        return INSTANCE;
    }
}

