/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.processors;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.di.law.warc.filters.Filter;
import it.unimi.di.law.warc.filters.parser.FilterParser;
import it.unimi.di.law.warc.io.CompressedWarcCachingReader;
import it.unimi.di.law.warc.io.WarcFormatException;
import it.unimi.di.law.warc.io.WarcReader;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.di.law.warc.util.ReorderingBlockingQueue;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.FlyweightPrototype;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelFilteredProcessorRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelFilteredProcessorRunner.class);
    private final ObjectArrayList<Step<?>> steps = new ObjectArrayList();
    private final InputStream in;
    private final Filter<WarcRecord> filter;
    private ReorderingBlockingQueue<Result<?>[]> queue;
    protected volatile IOException flushingThreadException;

    public ParallelFilteredProcessorRunner(InputStream in, Filter<WarcRecord> filter) {
        this.in = in;
        this.filter = filter;
    }

    public ParallelFilteredProcessorRunner(InputStream in) {
        this(in, null);
    }

    private static ObjectArrayList<Step<?>> copySteps(ObjectArrayList<Step<?>> steps) {
        ObjectArrayList copy = new ObjectArrayList(steps.size());
        for (Step step : steps) {
            copy.add((Object)step.copy());
        }
        return copy;
    }

    public <T> ParallelFilteredProcessorRunner add(Processor<T> p, Writer<? super T> s, PrintStream out) {
        this.steps.add(new Step(p, s, out));
        return this;
    }

    public void runSequentially() throws WarcFormatException, Exception {
        WarcReader r;
        CompressedWarcCachingReader reader = new CompressedWarcCachingReader(this.in);
        ProgressLogger pl = new ProgressLogger(LOGGER, 1L, TimeUnit.MINUTES, "records");
        pl.itemsName = "records";
        pl.displayFreeMemory = true;
        pl.displayLocalSpeed = true;
        pl.start((CharSequence)"Scanning...");
        long storePosition = 0L;
        while ((r = reader.cache()) != null) {
            WarcRecord record = r.read();
            if (this.filter == null || this.filter != null && this.filter.apply(record)) {
                for (Step s : this.steps) {
                    Result result = s.run(r, storePosition);
                    if (result == null) continue;
                    result.write();
                }
            }
            pl.lightUpdate();
            ++storePosition;
        }
        pl.done();
        for (Step s : this.steps) {
            s.processor.close();
            s.writer.close();
        }
    }

    public void run() throws WarcFormatException, IOException, InterruptedException {
        this.run(Runtime.getRuntime().availableProcessors());
    }

    public void run(int numberOfThreads) throws WarcFormatException, IOException, InterruptedException {
        int i;
        this.queue = new ReorderingBlockingQueue(2 * numberOfThreads);
        ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setPriority(10).setNameFormat("FlushingThread").build());
        Future<Void> future = singleThreadExecutor.submit(new FlushingThread());
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, new ThreadFactoryBuilder().setNameFormat("ProcessingThread-%d").build());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        final MutableLong counter = new MutableLong();
        final MutableBoolean end = new MutableBoolean();
        final Result[] nullResult = new Result[this.steps.size()];
        for (i = nullResult.length - 1; i >= 0; --i) {
            nullResult[i] = null;
        }
        i = numberOfThreads;
        while (i-- != 0) {
            executorCompletionService.submit(new Callable<Void>(){
                private final ObjectArrayList<Step<?>> stepsCopy;
                private final CompressedWarcCachingReader reader;
                private final Filter<WarcRecord> filterCopy;
                {
                    this.stepsCopy = ParallelFilteredProcessorRunner.copySteps(ParallelFilteredProcessorRunner.this.steps);
                    this.reader = new CompressedWarcCachingReader(ParallelFilteredProcessorRunner.this.in);
                    this.filterCopy = ParallelFilteredProcessorRunner.this.filter == null ? null : (Filter)ParallelFilteredProcessorRunner.this.filter.copy();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    while (true) {
                        Result[] result;
                        WarcRecord record;
                        long storePosition;
                        WarcReader r = null;
                        MutableLong mutableLong = counter;
                        synchronized (mutableLong) {
                            if (end.booleanValue()) {
                                return null;
                            }
                            try {
                                r = this.reader.cache();
                            }
                            catch (Exception e) {
                                LOGGER.error("Exception while reading store", (Throwable)e);
                            }
                            if (r == null) {
                                end.setValue(true);
                                return null;
                            }
                            storePosition = counter.longValue();
                            counter.increment();
                        }
                        boolean passFilter = true;
                        if (this.filterCopy != null && !this.filterCopy.apply(record = r.read())) {
                            passFilter = false;
                        }
                        if (passFilter) {
                            result = new Result[this.stepsCopy.size()];
                            int i = 0;
                            for (Step s : this.stepsCopy) {
                                result[i++] = s.run(r, storePosition);
                            }
                        } else {
                            result = nullResult;
                        }
                        ParallelFilteredProcessorRunner.this.queue.put(result, storePosition);
                    }
                }
            });
        }
        Throwable readingProblem = null;
        int i2 = numberOfThreads;
        while (i2-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception in parallel thread", e.getCause());
                readingProblem = e.getCause();
            }
        }
        executorService.shutdown();
        try {
            this.queue.put(Result.END_OF_RESULTS, counter.longValue());
            future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause.getMessage(), cause);
        }
        finally {
            singleThreadExecutor.shutdown();
        }
        for (Step s : this.steps) {
            s.processor.close();
            s.writer.close();
        }
    }

    public static void main(String[] arg) throws Exception {
        int i;
        Filter<WarcRecord> filter;
        SimpleJSAP jsap = new SimpleJSAP(ParallelFilteredProcessorRunner.class.getName(), "Processes a store.", new Parameter[]{new FlaggedOption("filter", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'f', "filter", "A WarcRecord filter that recods must pass in order to be processed."), new FlaggedOption("processor", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, 'p', "processor", "A processor to be applied to data.").setAllowMultipleDeclarations(true), new FlaggedOption("writer", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, 'w', "writer", "A writer to be applied to the results.").setAllowMultipleDeclarations(true), new FlaggedOption("output", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'o', "output", "The output filename  (- for stdout).").setAllowMultipleDeclarations(true), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, Integer.toString(Runtime.getRuntime().availableProcessors()), false, 'T', "threads", "The number of threads to be used."), new Switch("sequential", 'S', "sequential"), new UnflaggedOption("store", (StringParser)JSAP.STRING_PARSER, false, "The name of the store (if omitted, stdin).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String filterSpec = jsapResult.getString("filter");
        if (filterSpec != null) {
            FilterParser<WarcRecord> parser = new FilterParser<WarcRecord>(WarcRecord.class);
            filter = parser.parse(filterSpec);
        } else {
            filter = null;
        }
        InputStream in = jsapResult.userSpecified("store") ? new FastBufferedInputStream((InputStream)new FileInputStream(jsapResult.getString("store"))) : System.in;
        ParallelFilteredProcessorRunner parallelFilteredProcessorRunner = new ParallelFilteredProcessorRunner(in, filter);
        String[] processor = jsapResult.getStringArray("processor");
        String[] writer = jsapResult.getStringArray("writer");
        String[] output = jsapResult.getStringArray("output");
        if (processor.length != writer.length) {
            throw new IllegalArgumentException("You must specify the same number or processors and writers");
        }
        if (output.length != writer.length) {
            throw new IllegalArgumentException("You must specify the same number or output specifications and writers");
        }
        String[] packages = new String[]{ParallelFilteredProcessorRunner.class.getPackage().getName()};
        PrintStream[] ops = new PrintStream[processor.length];
        for (i = 0; i < processor.length; ++i) {
            ops[i] = "-".equals(output[i]) ? System.out : new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(output[i])), false, "UTF-8");
            parallelFilteredProcessorRunner.add((Processor)ObjectParser.fromSpec((String)processor[i], Processor.class, (String[])packages, (String[])new String[]{"getInstance"}), (Writer)ObjectParser.fromSpec((String)writer[i], Writer.class, (String[])packages, (String[])new String[]{"getInstance"}), ops[i]);
        }
        if (jsapResult.userSpecified("sequential")) {
            parallelFilteredProcessorRunner.runSequentially();
        } else {
            parallelFilteredProcessorRunner.run(jsapResult.getInt("threads"));
        }
        for (i = 0; i < processor.length; ++i) {
            ops[i].close();
        }
    }

    private final class FlushingThread
    implements Callable<Void> {
        private FlushingThread() {
        }

        @Override
        public Void call() throws Exception {
            ProgressLogger pl = new ProgressLogger(LOGGER, 1L, TimeUnit.MINUTES, "records");
            pl.itemsName = "records";
            pl.displayFreeMemory = true;
            pl.displayLocalSpeed = true;
            pl.start((CharSequence)"Scanning...");
            try {
                while (true) {
                    Result[] result;
                    if ((result = (Result[])ParallelFilteredProcessorRunner.this.queue.take()) == Result.END_OF_RESULTS) {
                        pl.done();
                        return null;
                    }
                    for (Result r : result) {
                        if (r == null) continue;
                        r.write();
                    }
                    pl.lightUpdate();
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception in flushing thread", (Throwable)e);
                throw e;
            }
        }
    }

    private static class Step<T>
    implements FlyweightPrototype<Step<T>> {
        private final Processor<T> processor;
        private final Writer<? super T> writer;
        private final PrintStream out;

        private Step(Processor<T> processor, Writer<? super T> writer, PrintStream out) {
            this.processor = processor;
            this.writer = writer;
            this.out = out;
        }

        private Result<T> run(WarcReader reader, long storePosition) throws Exception {
            Args.notNull((Object)reader, (String)"reader");
            T result = this.processor.process(reader.read(), storePosition);
            if (result == null) {
                return null;
            }
            return new Result(result, this.writer, storePosition, this.out);
        }

        public Step<T> copy() {
            return new Step<T>((Processor)this.processor.copy(), this.writer, this.out);
        }
    }

    private static final class Result<T> {
        public static final Result<?>[] END_OF_RESULTS = new Result[0];
        private final T result;
        private final Writer<? super T> writer;
        private final PrintStream out;
        private final long storePosition;

        private Result(T result, Writer<? super T> writer, long storePosition, PrintStream out) {
            this.result = result;
            this.writer = writer;
            this.storePosition = storePosition;
            this.out = out;
        }

        private void write() throws IOException {
            this.writer.write(this.result, this.storePosition, this.out);
        }
    }

    public static interface Writer<T>
    extends Closeable {
        public void write(T var1, long var2, PrintStream var4) throws IOException;
    }

    public static interface Processor<T>
    extends Closeable,
    FlyweightPrototype<Processor<T>> {
        public T process(WarcRecord var1, long var2);
    }
}

