/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.processors;

import com.google.common.io.Closeables;
import it.unimi.di.law.warc.io.UncompressedWarcWriter;
import it.unimi.di.law.warc.processors.ParallelFilteredProcessorRunner;
import it.unimi.di.law.warc.records.WarcRecord;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityWriter
implements ParallelFilteredProcessorRunner.Writer<WarcRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityWriter.class);
    private UncompressedWarcWriter writer;

    @Override
    public void write(WarcRecord r, long storePosition, PrintStream out) throws IOException {
        if (this.writer == null) {
            this.writer = new UncompressedWarcWriter(out);
        }
        try {
            this.writer.write(r);
        }
        catch (Exception e) {
            LOGGER.error("Exception while writing record", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        Closeables.close((Closeable)this.writer, (boolean)true);
    }
}

