/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.io.gzarc;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.di.law.warc.io.gzarc.GZIPArchive;
import it.unimi.di.law.warc.io.gzarc.GZIPArchiveReader;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.longs.LongBigArrayBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GZIPIndexer.class);

    public static LongBigArrayBigList index(InputStream in) throws IOException {
        return GZIPIndexer.index(in, null);
    }

    public static LongBigArrayBigList index(InputStream in, ProgressLogger pl) throws IOException {
        GZIPArchive.ReadEntry re;
        LongBigArrayBigList pointers = new LongBigArrayBigList();
        long current = 0L;
        GZIPArchiveReader gzar = new GZIPArchiveReader(in);
        while ((re = gzar.skipEntry()) != null) {
            pointers.add(current);
            current += (long)re.compressedSkipLength;
            if (pl == null) continue;
            pl.lightUpdate();
        }
        in.close();
        return pointers;
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(GZIPIndexer.class.getName(), "Computes and stores a quasi-succinct index for a compressed archive.", new Parameter[]{new UnflaggedOption("archive", (StringParser)JSAP.STRING_PARSER, true, "The name a GZIP's archive."), new UnflaggedOption("index", (StringParser)JSAP.STRING_PARSER, true, "The output (a serialized LongBigList of pointers to the records in the archive) filename.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        FastBufferedInputStream input = new FastBufferedInputStream((InputStream)new FileInputStream(jsapResult.getString("archive")));
        ProgressLogger pl = new ProgressLogger(LOGGER, 1L, TimeUnit.MINUTES, "records");
        pl.start((CharSequence)"Scanning...");
        EliasFanoMonotoneLongBigList list = new EliasFanoMonotoneLongBigList((LongIterable)GZIPIndexer.index((InputStream)input, pl));
        pl.done();
        BinIO.storeObject((Object)list, (CharSequence)jsapResult.getString("index"));
    }
}

