/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.io.gzarc;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import it.unimi.di.law.warc.io.gzarc.GZIPArchive;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPArchiveReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(GZIPArchiveReader.class);
    private final CRC32 crc = new CRC32();
    private static final int HEADER_BUFFER_SIZE = 16384;
    private final byte[] headerBuffer = new byte[16384];
    private final CountingInputStream input;
    private final RepositionableStream repositionableInput;

    public GZIPArchiveReader(InputStream input) {
        this.input = new CountingInputStream(input);
        this.repositionableInput = input instanceof RepositionableStream ? (RepositionableStream)input : null;
    }

    public void position(long position) throws IOException {
        if (this.repositionableInput == null) {
            throw new UnsupportedOperationException();
        }
        this.repositionableInput.position(position);
    }

    public GZIPArchive.ReadEntry getEntry() throws IOException {
        return this.getEntry(false);
    }

    public GZIPArchive.ReadEntry skipEntry() throws IOException {
        long headerCount = this.input.getCount();
        GZIPArchive.ReadEntry entry = this.readHeader();
        long compressedBlockCount = this.input.getCount();
        if (entry == null) {
            return null;
        }
        long reminingCompressedBytes = (long)entry.compressedSkipLength - (compressedBlockCount - headerCount) - 8L;
        this.input.skip(reminingCompressedBytes);
        this.readTrailer(entry);
        return entry;
    }

    public GZIPArchive.ReadEntry getEntry(final boolean cached) throws IOException {
        long headerCount = this.input.getCount();
        final GZIPArchive.ReadEntry entry = this.readHeader();
        final long compressedBlockCount = this.input.getCount();
        if (entry == null) {
            return null;
        }
        final long reminingCompressedBytes = (long)entry.compressedSkipLength - (compressedBlockCount - headerCount) - 8L;
        final InputStream limitInputStream = ByteStreams.limit((InputStream)this.input, (long)reminingCompressedBytes);
        final InputStream boundingInputStream = cached ? new FastByteArrayInputStream(ByteStreams.toByteArray((InputStream)limitInputStream)) : limitInputStream;
        entry.lazyInflater = new GZIPArchive.ReadEntry.LazyInflater(){
            private InputStream inflaterInputStream;

            @Override
            public void consume() throws IOException {
                long read;
                boolean uncompress;
                if (this.inflaterInputStream == null && !cached) {
                    throw new IllegalStateException("Can't call 'consume' before 'get' if not cached");
                }
                boolean bl = uncompress = GZIPArchiveReader.this.input.getCount() - compressedBlockCount < 1024L;
                if (uncompress && !cached) {
                    read = this.inflaterInputStream.skip(Long.MAX_VALUE);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Read remaining {} uncompressed bytes", (Object)read);
                    }
                } else {
                    read = limitInputStream.skip(Long.MAX_VALUE);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Read remaining {} compressed bytes", (Object)read);
                    }
                }
                assert (GZIPArchiveReader.this.input.getCount() - compressedBlockCount == reminingCompressedBytes) : "Wrong reminingCompressedBytes after consuming content.";
                GZIPArchiveReader.this.readTrailer(entry);
                if (uncompress && !cached) {
                    int actualCrc = (int)(GZIPArchiveReader.this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("CRC as computed while reading {}", (Object)actualCrc);
                    }
                    if (entry.crc32 != actualCrc) {
                        throw new GZIPArchive.FormatException("CRC32 mismatch, expected: " + entry.crc32 + ", actual: " + actualCrc);
                    }
                } else {
                    entry.crc32 = 0;
                }
                assert (!cached || reminingCompressedBytes == (long)((FastByteArrayInputStream)boundingInputStream).available()) : "Wrong reminingCompressedBytes after reading the trailer";
            }

            @Override
            public InputStream get() throws IOException {
                Inflater inflater = new Inflater(true);
                GZIPArchiveReader.this.crc.reset();
                if (cached) {
                    ((FastByteArrayInputStream)boundingInputStream).position(0L);
                }
                InputStream inputStream = this.inflaterInputStream = cached ? new InflaterInputStream(boundingInputStream, inflater) : new CheckedInputStream(new InflaterInputStream(boundingInputStream, inflater), GZIPArchiveReader.this.crc);
                assert (!cached || reminingCompressedBytes == (long)((FastByteArrayInputStream)boundingInputStream).available()) : "Wrong reminingCompressedBytes count after get";
                return this.inflaterInputStream;
            }
        };
        return entry;
    }

    private void readTrailer(GZIPArchive.ReadEntry entry) throws IOException {
        int iSize;
        entry.crc32 = GZIPArchiveReader.readLEInt((InputStream)this.input);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("CRC read from stream {}", (Object)entry.crc32);
        }
        if (entry.uncompressedSkipLength != (iSize = GZIPArchiveReader.readLEInt((InputStream)this.input))) {
            throw new GZIPArchive.FormatException("Length mismatch between (warc) extra gzip fields uncompressed-skip-length (" + entry.uncompressedSkipLength + ") and ISIZE (" + iSize + ")");
        }
    }

    private GZIPArchive.ReadEntry readHeader() throws IOException {
        int b;
        int len;
        GZIPArchive.ReadEntry entry = new GZIPArchive.ReadEntry();
        byte[] buffer = this.headerBuffer;
        if (this.input.read(buffer, 0, 4) == -1) {
            return null;
        }
        if (buffer[0] != GZIPArchive.GZIP_START[0] || buffer[1] != GZIPArchive.GZIP_START[1]) {
            throw new GZIPArchive.FormatException("Missing GZip magic numbers, found: " + buffer[0] + " " + buffer[1]);
        }
        if (buffer[2] != GZIPArchive.GZIP_START[2]) {
            throw new GZIPArchive.FormatException("Unknown compression method: " + buffer[2]);
        }
        byte flg = buffer[3];
        entry.mtime = GZIPArchiveReader.readLEInt((InputStream)this.input);
        this.input.read(buffer, 0, 2);
        entry.compressedSkipLength = -1;
        if ((flg & 4) != 0) {
            short xlen = GZIPArchiveReader.readLEShort((InputStream)this.input);
            while (xlen > 0) {
                this.input.read(buffer, 0, 2);
                short len2 = GZIPArchiveReader.readLEShort((InputStream)this.input);
                if (buffer[0] == GZIPArchive.SKIP_LEN[0] && buffer[1] == GZIPArchive.SKIP_LEN[1]) {
                    entry.compressedSkipLength = GZIPArchiveReader.readLEInt((InputStream)this.input);
                    entry.uncompressedSkipLength = GZIPArchiveReader.readLEInt((InputStream)this.input);
                } else {
                    this.input.read(buffer, 0, (int)len2);
                }
                xlen = (short)(xlen - (len2 + GZIPArchive.SKIP_LEN.length + 2));
            }
        } else {
            throw new GZIPArchive.FormatException("Missing SL extra field");
        }
        if (entry.compressedSkipLength < 0) {
            throw new GZIPArchive.FormatException("Negative compressed-skip-length (" + entry.compressedSkipLength + ")");
        }
        if ((flg & 8) != 0) {
            len = 0;
            while ((b = this.input.read()) != 0) {
                buffer[len++] = (byte)b;
            }
            entry.name = Arrays.copyOf(buffer, len);
        }
        if ((flg & 0x10) != 0) {
            len = 0;
            while ((b = this.input.read()) != 0) {
                buffer[len++] = (byte)b;
            }
            entry.comment = Arrays.copyOf(buffer, len);
        }
        if ((flg & 2) != 0) {
            this.input.read(buffer, 0, 2);
        }
        return entry;
    }

    private static int readLEInt(InputStream in) throws IOException {
        int i = in.read() & 0xFF;
        i |= (in.read() & 0xFF) << 8;
        i |= (in.read() & 0xFF) << 16;
        return i |= (in.read() & 0xFF) << 24;
    }

    private static short readLEShort(InputStream in) throws IOException {
        short s = (byte)in.read();
        s = (short)(s | (byte)in.read() << 8);
        return s;
    }
}

