/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.io.gzarc;

import it.unimi.di.law.bubing.util.Util;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GZIPArchive {
    public static final int CHECKSUM_THRESHOLD = 1024;
    public static final byte XFL = 9;
    public static final byte FTEXT = 1;
    public static final byte FHCRC = 2;
    public static final byte FEXTRA = 4;
    public static final byte FNAME = 8;
    public static final byte FCOMMENT = 16;
    public static final byte[] GZIP_START = new byte[]{31, -117, 8, 28};
    public static final byte[] XFL_OS = new byte[]{9, -1};
    public static final short SHORT_LEN = 2;
    public static final short INT_LEN = 4;
    public static final byte[] SKIP_LEN = new byte[]{115, 108};
    public static final short SUB_LEN = 8;
    public static final short XLEN = (short)(SKIP_LEN.length + 2 + 8);
    public static final short TRAILER_LEN = 8;
    public static final int FIX_LEN = GZIP_START.length + 4 + XFL_OS.length + 2 + XLEN + 8;

    public static class FormatException
    extends IOException {
        public FormatException(String message) {
            super(message);
        }

        public FormatException(String message, Throwable e) {
            super(message, e);
        }
    }

    public static class WriteEntry
    extends Entry {
        public OutputStream deflater = null;
    }

    public static class ReadEntry
    extends Entry {
        public LazyInflater lazyInflater = null;

        public static interface LazyInflater {
            public InputStream get() throws IOException;

            public void consume() throws IOException;
        }
    }

    public static class Entry {
        public int compressedSkipLength;
        public int uncompressedSkipLength;
        public int mtime;
        public int crc32;
        protected byte[] name = ByteArrays.EMPTY_ARRAY;
        protected byte[] comment = ByteArrays.EMPTY_ARRAY;

        private Entry() {
        }

        public String getName() {
            return Util.toString(this.name);
        }

        public void setName(String name) {
            this.name = Util.toByteArray(name);
        }

        public String getComment() {
            return Util.toString(this.comment);
        }

        public void setComment(String comment) {
            this.comment = Util.toByteArray(comment);
        }

        public String toString() {
            return "<" + this.getName() + ", " + this.getComment() + ", csl = " + this.compressedSkipLength + ", usl = " + this.uncompressedSkipLength + ", mtime = " + this.mtime + ", crc32 = " + (this.crc32 != 0 ? Integer.valueOf(this.crc32) : "[not checked]") + ">";
        }
    }
}

