/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.io;

import it.unimi.di.law.warc.io.AbstractWarcReader;
import it.unimi.di.law.warc.io.WarcFormatException;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import java.io.IOException;
import java.io.InputStream;

public class UncompressedWarcReader
extends AbstractWarcReader {
    private final RepositionableStream repositionableInput;
    private boolean consecutive;

    public UncompressedWarcReader(InputStream input) {
        this.repositionableInput = input instanceof RepositionableStream ? (RepositionableStream)input : null;
        this.consecutive = true;
        super.setInput(input);
    }

    @Override
    public WarcRecord read() throws IOException, WarcFormatException {
        WarcRecord record = super.read(this.consecutive);
        this.consecutive = true;
        return record;
    }

    @Override
    public void position(long position) throws IOException {
        if (this.repositionableInput == null) {
            throw new UnsupportedOperationException();
        }
        this.repositionableInput.position(position);
        this.consecutive = false;
    }
}

