/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.io;

import it.unimi.di.law.warc.io.AbstractWarcReader;
import it.unimi.di.law.warc.io.WarcFormatException;
import it.unimi.di.law.warc.io.gzarc.GZIPArchive;
import it.unimi.di.law.warc.io.gzarc.GZIPArchiveReader;
import it.unimi.di.law.warc.records.WarcRecord;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedWarcReader
extends AbstractWarcReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressedWarcReader.class);
    private final GZIPArchiveReader gzar;
    private GZIPArchive.ReadEntry previous;

    public CompressedWarcReader(InputStream input) {
        this.gzar = new GZIPArchiveReader(input);
        this.previous = null;
    }

    @Override
    public WarcRecord read() throws IOException, WarcFormatException, GZIPArchive.FormatException {
        GZIPArchive.ReadEntry e;
        if (this.previous != null) {
            this.previous.lazyInflater.consume();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Consumed {}", (Object)this.previous);
            }
        }
        if ((e = this.gzar.getEntry()) == null) {
            this.previous = null;
            return null;
        }
        this.previous = e;
        super.setInput(e.lazyInflater.get());
        return super.read(false);
    }

    @Override
    public void position(long position) throws IOException {
        this.previous = null;
        this.gzar.position(position);
    }
}

