/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;

public class ResponseMatches
extends AbstractFilter<HttpResponse> {
    private final Pattern pattern;

    public ResponseMatches(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean apply(HttpResponse httpResponse) {
        try {
            InputStream content = httpResponse.getEntity().getContent();
            return this.pattern.matcher(IOUtils.toString((InputStream)content, (Charset)StandardCharsets.ISO_8859_1)).matches();
        }
        catch (IOException shouldntReallyHappen) {
            throw new RuntimeException(shouldntReallyHappen);
        }
    }

    public static ResponseMatches valueOf(String spec) {
        return new ResponseMatches(Pattern.compile(spec));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.pattern.toString() + ")";
    }

    public Filter<HttpResponse> copy() {
        return new ResponseMatches(this.pattern);
    }
}

