/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;

public class IsProbablyBinary
extends AbstractFilter<HttpResponse> {
    public static final IsProbablyBinary INSTANCE = new IsProbablyBinary();
    public static final int BINARY_CHECK_SCAN_LENGTH = 1000;
    public static final int THRESHOLD = 3;

    private IsProbablyBinary() {
    }

    public boolean apply(HttpResponse httpResponse) {
        try {
            InputStream content = httpResponse.getEntity().getContent();
            int count = 0;
            int i = 1000;
            while (i-- != 0) {
                int b = content.read();
                if (b == -1) {
                    return false;
                }
                if (b != 0 || ++count != 3) continue;
                return true;
            }
        }
        catch (IOException shouldntReallyHappen) {
            throw new RuntimeException(shouldntReallyHappen);
        }
        return false;
    }

    @Deprecated
    public static IsProbablyBinary valueOf(String emptySpec) {
        if (emptySpec.length() > 0) {
            throw new IllegalArgumentException();
        }
        return INSTANCE;
    }

    public static IsProbablyBinary valueOf() {
        return INSTANCE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "()";
    }

    public Filter<HttpResponse> copy() {
        return this;
    }
}

