/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import it.unimi.di.law.warc.records.WarcHeader;
import it.unimi.di.law.warc.records.WarcRecord;
import org.apache.http.Header;

public class IsHttpResponse
extends AbstractFilter<WarcRecord> {
    public static final IsHttpResponse INSTANCE = new IsHttpResponse();

    private IsHttpResponse() {
    }

    public boolean apply(WarcRecord x) {
        Header messageType = x.getWarcHeader(WarcHeader.Name.CONTENT_TYPE);
        return x.getWarcType() == WarcRecord.Type.RESPONSE && messageType != null && messageType.getValue().equals("application/http;msgtype=response");
    }

    public static IsHttpResponse valueOf(String emptySpec) {
        if (emptySpec.length() > 0) {
            throw new IllegalArgumentException();
        }
        return INSTANCE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "()";
    }

    public Filter<WarcRecord> copy() {
        return this;
    }
}

