/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import java.net.URI;

public class HostEndsWith
extends AbstractFilter<URI> {
    private final String suffix;

    public HostEndsWith(String suffix) {
        this.suffix = suffix.toLowerCase();
    }

    public boolean apply(URI uri) {
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("URI \"" + uri + "\" has no host");
        }
        return uri.getHost().endsWith(this.suffix);
    }

    public static HostEndsWith valueOf(String spec) {
        return new HostEndsWith(spec);
    }

    public String toString() {
        return this.toString(this.suffix);
    }

    public boolean equals(Object x) {
        if (x instanceof HostEndsWith) {
            return ((HostEndsWith)x).suffix.equals(this.suffix);
        }
        return false;
    }

    public int hashCode() {
        return this.suffix.hashCode() ^ HostEndsWith.class.hashCode();
    }

    public Filter<URI> copy() {
        return this;
    }
}

