/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.bubing.util.FetchData;
import it.unimi.di.law.bubing.util.Link;
import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.ContentTypeStartsWith;
import it.unimi.di.law.warc.filters.DigestEquals;
import it.unimi.di.law.warc.filters.DuplicateSegmentsLessThan;
import it.unimi.di.law.warc.filters.Filter;
import it.unimi.di.law.warc.filters.HostEndsWith;
import it.unimi.di.law.warc.filters.HostEndsWithOneOf;
import it.unimi.di.law.warc.filters.HostEquals;
import it.unimi.di.law.warc.filters.IsHttpResponse;
import it.unimi.di.law.warc.filters.IsProbablyBinary;
import it.unimi.di.law.warc.filters.PathEndsWithOneOf;
import it.unimi.di.law.warc.filters.ResponseMatches;
import it.unimi.di.law.warc.filters.SchemeEquals;
import it.unimi.di.law.warc.filters.StatusCategory;
import it.unimi.di.law.warc.filters.URIResponse;
import it.unimi.di.law.warc.filters.URLEquals;
import it.unimi.di.law.warc.filters.URLMatchesRegex;
import it.unimi.di.law.warc.filters.URLShorterThan;
import it.unimi.di.law.warc.filters.parser.ParseException;
import it.unimi.di.law.warc.records.HttpResponseWarcRecord;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.lang.FlyweightPrototype;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;

public class Filters {
    public static final Filter<?>[] EMPTY_ARRAY = new Filter[0];
    private static final ObjectOpenHashSet<Class<? extends Filter<?>>> FILTERS = new ObjectOpenHashSet((Object[])new Class[]{ContentTypeStartsWith.class, DigestEquals.class, DuplicateSegmentsLessThan.class, HostEndsWith.class, HostEndsWithOneOf.class, HostEquals.class, IsHttpResponse.class, IsProbablyBinary.class, PathEndsWithOneOf.class, ResponseMatches.class, SchemeEquals.class, StatusCategory.class, URLEquals.class, URLMatchesRegex.class, URLShorterThan.class});
    public static Filter TRUE = new Filter(){

        public boolean apply(Object x) {
            return true;
        }

        public String toString() {
            return "true";
        }

        public FlyweightPrototype copy() {
            return this;
        }
    };
    public static Filter FALSE = new Filter(){

        public boolean apply(Object x) {
            return false;
        }

        public String toString() {
            return "false";
        }

        public FlyweightPrototype copy() {
            return this;
        }
    };

    @SafeVarargs
    public static <T> Filter<T> and(final Filter<T> ... f) {
        return new Filter<T>(){

            public boolean apply(T x) {
                for (Filter filter : f) {
                    if (filter.apply(x)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "(" + StringUtils.join((Object[])f, (String)" and ") + ")";
            }

            public Filter<T> copy() {
                return Filters.and(Filters.copy(f));
            }
        };
    }

    @SafeVarargs
    public static <T> Filter<T> or(final Filter<T> ... f) {
        return new Filter<T>(){

            public boolean apply(T x) {
                for (Filter filter : f) {
                    if (!filter.apply(x)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "(" + StringUtils.join((Object[])f, (String)" or ") + ")";
            }

            public Filter<T> copy() {
                return Filters.or(Filters.copy(f));
            }
        };
    }

    public static <T> Filter<T> not(final Filter<T> filter) {
        return new AbstractFilter<T>(){

            public boolean apply(T x) {
                return !filter.apply(x);
            }

            public String toString() {
                return "(not " + filter + ")";
            }

            public Filter<T> copy() {
                return Filters.not((Filter)filter.copy());
            }
        };
    }

    public static <T> Filter<T> getFilterFromSpec(String className, String spec, Class<T> tClass) throws ParseException {
        String filterClassName = className.indexOf(46) >= 0 ? className : Filter.FILTER_PACKAGE_NAME + "." + className;
        try {
            Method adaptMethod;
            int i;
            Class<?> c = Class.forName(filterClassName);
            if (!Filter.class.isAssignableFrom(c)) {
                throw new ParseException(filterClassName + " is not a valid filter class");
            }
            Filter filter = spec.length() != 0 ? (Filter)c.getMethod("valueOf", String.class).invoke(null, spec) : (Filter)c.getMethod("valueOf", new Class[0]).invoke(null, new Object[0]);
            Method[] method = filter.getClass().getMethods();
            for (i = 0; i < method.length && (method[i].isSynthetic() || !method[i].getName().equals("apply")); ++i) {
            }
            if (i == method.length) {
                throw new NoSuchMethodException("Could not find apply method in filter " + filter);
            }
            Class<?>[] parameterTypes = method[i].getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new NoSuchMethodException("Could not find one-argument apply method in filter " + filter);
            }
            Class<?> toClass = parameterTypes[0];
            if (toClass.equals(tClass)) {
                return filter;
            }
            try {
                adaptMethod = Filters.class.getMethod("adaptFilter" + toClass.getSimpleName() + "2" + tClass.getSimpleName(), Filter.class);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodException("Cannot adapt a Filter<" + toClass.getSimpleName() + "> into Filter<" + tClass.getSimpleName() + ">");
            }
            return (Filter)adaptMethod.invoke(null, filter);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Filter<URI> adaptFilterString2URI(final Filter<String> original) {
        return new AbstractFilter<URI>(){

            public boolean apply(URI uri) {
                return original.apply(uri.toString());
            }

            public String toString() {
                return original.toString();
            }

            public Filter<URI> copy() {
                return Filters.adaptFilterString2URI((Filter)original.copy());
            }
        };
    }

    public static Filter<HttpResponseWarcRecord> adaptFilterURI2HttpResponseWarcRecord(final Filter<URI> original) {
        return new AbstractFilter<HttpResponseWarcRecord>(){

            public boolean apply(HttpResponseWarcRecord response) {
                return original.apply(response.getWarcTargetURI());
            }

            public String toString() {
                return original.toString();
            }

            public Filter<HttpResponseWarcRecord> copy() {
                return Filters.adaptFilterURI2HttpResponseWarcRecord((Filter)original.copy());
            }
        };
    }

    public static Filter<Link> adaptFilterURI2Link(final Filter<URI> original) {
        return new AbstractFilter<Link>(){

            public boolean apply(Link link) {
                return original.apply(link.target);
            }

            public String toString() {
                return original.toString();
            }

            public Filter<Link> copy() {
                return Filters.adaptFilterURI2Link((Filter)original.copy());
            }
        };
    }

    public static Filter<WarcRecord> adaptFilterURI2WarcRecord(final Filter<URI> original) {
        return new AbstractFilter<WarcRecord>(){

            public boolean apply(WarcRecord x) {
                return original.apply(x.getWarcTargetURI());
            }

            public String toString() {
                return original.toString();
            }

            public Filter<WarcRecord> copy() {
                return Filters.adaptFilterURI2WarcRecord((Filter)original.copy());
            }
        };
    }

    public static Filter<WarcRecord> adaptFilterHttpResponse2WarcRecord(final Filter<HttpResponse> original) {
        return new AbstractFilter<WarcRecord>(){

            public boolean apply(WarcRecord x) {
                if (x.getWarcType() == WarcRecord.Type.RESPONSE) {
                    return original.apply((HttpResponseWarcRecord)x);
                }
                return false;
            }

            public String toString() {
                return original.toString();
            }

            public Filter<WarcRecord> copy() {
                return Filters.adaptFilterHttpResponse2WarcRecord((Filter)original.copy());
            }
        };
    }

    public static Filter<FetchData> adaptFilterHttpResponse2FetchData(final Filter<HttpResponse> original) {
        return new AbstractFilter<FetchData>(){

            public boolean apply(FetchData x) {
                return original.apply(x.response());
            }

            public String toString() {
                return original.toString();
            }

            public Filter<FetchData> copy() {
                return Filters.adaptFilterHttpResponse2FetchData((Filter)original.copy());
            }
        };
    }

    public static Filter<FetchData> adaptFilterURI2FetchData(final Filter<URI> original) {
        return new AbstractFilter<FetchData>(){

            public boolean apply(FetchData x) {
                return original.apply(x.uri());
            }

            public String toString() {
                return original.toString();
            }

            public Filter<FetchData> copy() {
                return Filters.adaptFilterURI2FetchData((Filter)original.copy());
            }
        };
    }

    public static Filter<URIResponse> adaptFilterHttpResponse2URIResponse(final Filter<HttpResponse> original) {
        return new AbstractFilter<URIResponse>(){

            public boolean apply(URIResponse x) {
                return original.apply(x.response());
            }

            public String toString() {
                return original.toString();
            }

            public Filter<URIResponse> copy() {
                return Filters.adaptFilterHttpResponse2URIResponse((Filter)original.copy());
            }
        };
    }

    public static AbstractFilter<URIResponse> adaptFilterURI2URIResponse(final Filter<URI> original) {
        return new AbstractFilter<URIResponse>(){

            public boolean apply(URIResponse x) {
                return original.apply(x.uri());
            }

            public String toString() {
                return original.toString();
            }

            public Filter<URIResponse> copy() {
                return Filters.adaptFilterURI2URIResponse((Filter)original.copy());
            }
        };
    }

    public static Class<? extends Filter<?>>[] standardFilters() {
        return (Class[])FILTERS.toArray((Object[])new Class[FILTERS.size()]);
    }

    @SafeVarargs
    public static <T> Filter<T>[] copy(Filter<T> ... f) {
        Filter[] result = (Filter[])f.clone();
        for (int i = 0; i < f.length; ++i) {
            f[i] = (Filter)f[i].copy();
        }
        return result;
    }
}

