/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import it.unimi.di.law.warc.records.WarcHeader;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.di.law.warc.util.Util;
import java.util.Arrays;
import org.apache.http.Header;

public class DigestEquals
extends AbstractFilter<WarcRecord> {
    private final byte[] digest;

    private DigestEquals(byte[] digest) {
        this.digest = digest;
    }

    public boolean apply(WarcRecord x) {
        Header s = x.getWarcHeader(WarcHeader.Name.WARC_PAYLOAD_DIGEST);
        return s != null && Arrays.equals(this.digest, Util.fromHexString(s.getValue()));
    }

    public static DigestEquals valueOf(String spec) {
        return new DigestEquals(Util.fromHexString(spec));
    }

    public String toString() {
        return this.toString(Util.toHexString(this.digest));
    }

    public Filter<WarcRecord> copy() {
        return this;
    }
}

