/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.util.XoRoShiRo128PlusRandom;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.lang.BooleanUtils;

public class Util {
    private static final XoRoShiRo128PlusRandom RND = new XoRoShiRo128PlusRandom();
    private static final Object CREATION_LOCK = new Object();

    public static boolean parseBoolean(String s) {
        return BooleanUtils.toBoolean((String)s.toLowerCase(), (String)"true", (String)"false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createHierarchicalTempFile(File baseDirectory, int pathElements, String prefix, String suffix) throws IOException {
        long x;
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException(baseDirectory + " is not a directory.");
        }
        if (pathElements < 0 || pathElements > 8) {
            throw new IllegalArgumentException();
        }
        XoRoShiRo128PlusRandom xoRoShiRo128PlusRandom = RND;
        synchronized (xoRoShiRo128PlusRandom) {
            x = RND.nextLong();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < pathElements; ++i) {
            if (i != 0) {
                stringBuilder.append(File.separatorChar);
            }
            stringBuilder.append(Long.toHexString(x & 0xFL));
            stringBuilder.append(Long.toHexString((x >>= 4) & 0xFL));
            x >>= 4;
        }
        File directory = baseDirectory;
        if (pathElements > 0) {
            directory = new File(baseDirectory, stringBuilder.toString());
            Object object = CREATION_LOCK;
            synchronized (object) {
                if (directory.exists() && !directory.isDirectory() || !directory.exists() && !directory.mkdirs()) {
                    throw new IOException("Cannot create directory " + directory);
                }
            }
        }
        return File.createTempFile(prefix, suffix, directory);
    }

    public static final int vByteLength(int x) {
        return Fast.mostSignificantBit((int)x) / 7 + 1;
    }

    public static int writeVByte(int x, OutputStream os) throws IOException {
        if (x < 128) {
            os.write(x);
            return 1;
        }
        if (x < 16384) {
            os.write(x >>> 7 | 0x80);
            os.write(x & 0x7F);
            return 2;
        }
        if (x < 0x200000) {
            os.write(x >>> 14 | 0x80);
            os.write(x >>> 7 | 0x80);
            os.write(x & 0x7F);
            return 3;
        }
        if (x < 0x10000000) {
            os.write(x >>> 21 | 0x80);
            os.write(x >>> 14 | 0x80);
            os.write(x >>> 7 | 0x80);
            os.write(x & 0x7F);
            return 4;
        }
        os.write(x >>> 28 | 0x80);
        os.write(x >>> 21 | 0x80);
        os.write(x >>> 14 | 0x80);
        os.write(x >>> 7 | 0x80);
        os.write(x & 0x7F);
        return 5;
    }

    public static int readVByte(InputStream is) throws IOException {
        int x = 0;
        while (true) {
            int b = is.read();
            x |= b & 0x7F;
            if ((b & 0x80) == 0) {
                return x;
            }
            x <<= 7;
        }
    }

    public static final void writeByteArray(byte[] a, ObjectOutputStream s) throws IOException {
        Util.writeVByte(a.length, s);
        s.write(a);
    }

    public static final byte[] readByteArray(ObjectInputStream s) throws IOException {
        byte[] a = new byte[Util.readVByte(s)];
        s.readFully(a);
        return a;
    }

    public static byte[] toByteArray(String s) {
        byte[] byteArray = new byte[s.length()];
        int i = s.length();
        while (i-- != 0) {
            assert (s.charAt(i) < '\u0080') : s.charAt(i);
            byteArray[i] = (byte)s.charAt(i);
        }
        return byteArray;
    }

    public static OutputStream toOutputStream(String s, OutputStream os) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            assert (s.charAt(i) < '\u0100') : s.charAt(i);
            os.write(s.charAt(i));
        }
        return os;
    }

    public static ByteArrayList toByteArrayList(String s, ByteArrayList list) {
        list.clear();
        list.size(s.length());
        byte[] array = list.elements();
        int i = list.size();
        while (i-- != 0) {
            assert (s.charAt(i) < '\u0080') : s.charAt(i);
            array[i] = (byte)(s.charAt(i) & 0x7F);
        }
        return list;
    }

    public static String toString(ByteArrayList byteArrayList) {
        char[] charArray = new char[byteArrayList.size()];
        byte[] byteArray = byteArrayList.elements();
        int i = byteArrayList.size();
        while (i-- != 0) {
            assert (byteArray[i] < 128) : byteArray[i];
            charArray[i] = (char)byteArray[i];
        }
        return new String(charArray);
    }

    public static String toString(byte[] byteArray) {
        char[] charArray = new char[byteArray.length];
        int i = charArray.length;
        while (i-- != 0) {
            assert (byteArray[i] < 128) : byteArray[i];
            charArray[i] = (char)byteArray[i];
        }
        return new String(charArray);
    }

    public static String toString(byte[] byteArray, int offset, int length) {
        char[] charArray = new char[length];
        int i = charArray.length;
        while (i-- != 0) {
            assert (byteArray[offset + i] < 128) : byteArray[offset + i];
            charArray[i] = (char)byteArray[offset + i];
        }
        return new String(charArray);
    }
}

