/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.io.ByteDiskQueue;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ObjectDiskQueue<T>
implements Closeable,
Size64 {
    private final ByteDiskQueue byteDiskQueue;
    private final FastByteArrayOutputStream fbaos;
    private long size;

    protected ObjectDiskQueue(ByteDiskQueue byteDiskQueue) {
        this.byteDiskQueue = byteDiskQueue;
        this.fbaos = new FastByteArrayOutputStream(1024);
    }

    public static <T> ObjectDiskQueue<T> createNew(File file, int bufferSize, boolean direct) throws IOException {
        return new ObjectDiskQueue<T>(ByteDiskQueue.createNew((File)file, (int)bufferSize, (boolean)direct));
    }

    public static <T> ObjectDiskQueue<T> createFromFile(long size, File file, int bufferSize, boolean direct) throws IOException {
        ObjectDiskQueue<T> byteArrayDiskQueue = new ObjectDiskQueue<T>(ByteDiskQueue.createFromFile((File)file, (int)bufferSize, (boolean)direct));
        byteArrayDiskQueue.size = size;
        return byteArrayDiskQueue;
    }

    public synchronized void enqueue(T o) throws IOException {
        assert (o != null);
        this.fbaos.reset();
        BinIO.storeObject(o, (OutputStream)this.fbaos);
        this.byteDiskQueue.enqueueInt(this.fbaos.length);
        this.byteDiskQueue.enqueue(this.fbaos.array, 0, this.fbaos.length);
        ++this.size;
    }

    public synchronized T dequeue() throws IOException {
        int length = this.byteDiskQueue.dequeueInt();
        this.fbaos.array = ByteArrays.grow((byte[])this.fbaos.array, (int)length);
        this.byteDiskQueue.dequeue(this.fbaos.array, 0, length);
        --this.size;
        try {
            return (T)BinIO.loadObject((InputStream)new FastByteArrayInputStream(this.fbaos.array, 0, length));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Deprecated
    public synchronized int size() {
        throw new UnsupportedOperationException();
    }

    public synchronized long size64() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public synchronized void close() throws IOException {
        this.byteDiskQueue.close();
    }

    public synchronized void freeze() throws IOException {
        this.byteDiskQueue.freeze();
    }

    public synchronized void clear() {
        this.byteDiskQueue.clear();
        this.size = 0L;
    }

    public synchronized void trim() throws IOException {
        this.byteDiskQueue.trim();
    }

    public synchronized void suspend() throws IOException {
        this.byteDiskQueue.suspend();
    }

    public synchronized void enlargeBuffer(int newBufferSize) {
        this.byteDiskQueue.enlargeBuffer(newBufferSize);
    }
}

