/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.di.law.bubing.RuntimeConfiguration;
import it.unimi.di.law.bubing.frontier.VisitState;
import it.unimi.di.law.bubing.parser.BinaryParser;
import it.unimi.di.law.bubing.test.RandomNamedGraphServer;
import it.unimi.di.law.bubing.util.Util;
import it.unimi.di.law.warc.filters.URIResponse;
import it.unimi.di.law.warc.util.InspectableCachedHttpEntity;
import it.unimi.dsi.fastutil.io.InspectableFileCachedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.security.NoSuchAlgorithmException;
import java.util.Queue;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchData
implements URIResponse,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchData.class);
    private static final boolean FAKE = false;
    private static final RandomNamedGraphServer GRAPH_SERVER = null;
    private static final Header FAKE_CONTENT_TYPE = null;
    private final HttpResponse FAKE_RESPONSE = null;
    public static final int OVERFLOW_FILES_RANDOM_PATH_ELEMENTS = 1;
    protected volatile URI url;
    public volatile VisitState visitState;
    protected volatile HttpResponse response;
    protected volatile boolean truncated;
    public volatile long startTime;
    public volatile long endTime;
    public volatile Throwable exception;
    public boolean robots;
    private final InspectableCachedHttpEntity wrappedEntity;
    private final InspectableFileCachedInputStream inspectableFileCachedInputStream;
    private volatile byte[] digest;
    private volatile boolean isDuplicate;
    public final BinaryParser binaryParser;
    private final HttpGet httpGet;
    public volatile boolean inUse;
    private final RuntimeConfiguration rc;

    public FetchData(RuntimeConfiguration rc) throws NoSuchAlgorithmException, IllegalArgumentException, IOException {
        this.inspectableFileCachedInputStream = new InspectableFileCachedInputStream(rc.fetchDataBufferByteSize, Util.createHierarchicalTempFile(rc.responseCacheDir, 1, this.getClass().getSimpleName() + "-", ".overflow"));
        this.rc = rc;
        this.wrappedEntity = new InspectableCachedHttpEntity(this.inspectableFileCachedInputStream);
        this.httpGet = new HttpGet();
        this.binaryParser = new BinaryParser(rc.digestAlgorithm);
    }

    public long length() {
        if (this.response == null) {
            return 0L;
        }
        long length = 0L;
        for (Header header : this.response.getAllHeaders()) {
            length += (long)(header.getName().length() + header.getValue().length() + 1);
        }
        return length + this.wrappedEntity.getContentLength();
    }

    @Override
    public URI uri() {
        return this.url;
    }

    @Override
    public HttpResponse response() {
        return this.response;
    }

    public void fetch(URI url, HttpClient httpClient, RequestConfig requestConfig, VisitState visitState, boolean robots) throws IOException {
        this.visitState = visitState;
        this.url = url;
        this.response = null;
        this.exception = null;
        this.truncated = false;
        this.isDuplicate = false;
        this.robots = robots;
        assert (url.getHost() != null) : url;
        this.httpGet.setURI(url);
        if (requestConfig != null) {
            this.httpGet.setConfig(requestConfig);
        }
        this.wrappedEntity.clear();
        this.startTime = System.currentTimeMillis();
        try {
            URI uri = this.httpGet.getURI();
            String scheme = uri.getScheme();
            int port = uri.getPort() == -1 ? (scheme.equals("https") ? 443 : 80) : uri.getPort();
            HttpHost httpHost = visitState != null ? new HttpHost(InetAddress.getByAddress(visitState.workbenchEntry.ipAddress), uri.getHost(), port, scheme) : new HttpHost(uri.getHost(), port, scheme);
            httpClient.execute(httpHost, (HttpRequest)this.httpGet, response -> {
                this.response = response;
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    LOGGER.warn("Null entity for URL " + url);
                } else {
                    this.wrappedEntity.setEntity(entity);
                    this.truncated = this.wrappedEntity.copyContent(this.rc.responseBodyMaxByteSize, this.startTime, this.rc.connectionTimeout, 10L);
                    if (this.truncated) {
                        this.httpGet.abort();
                    }
                }
                return null;
            });
            this.response.setEntity((HttpEntity)this.wrappedEntity);
        }
        catch (IOException e) {
            this.exception = e instanceof ClientProtocolException ? e.getCause() : e;
        }
        this.endTime = Math.max(System.currentTimeMillis(), this.startTime);
        this.httpGet.reset();
    }

    public void digest(byte[] digest) {
        this.digest = digest;
    }

    public byte[] digest() {
        return this.digest;
    }

    public void isDuplicate(boolean isDuplicate) {
        this.isDuplicate = isDuplicate;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public String toString() {
        return "[" + this.url + " (" + this.response.getStatusLine() + ")]";
    }

    public void abort() {
        this.httpGet.abort();
    }

    @Override
    public void close() throws IOException {
        this.inspectableFileCachedInputStream.dispose();
    }

    private static final class EnqueueFetchedHttpResponseFutureCallback
    implements FutureCallback<Void> {
        private static final Exception CANCELLED = new Exception();
        private final FetchData fetchData;
        public volatile Queue<FetchData> results;

        public EnqueueFetchedHttpResponseFutureCallback(FetchData fetchData) {
            this.fetchData = fetchData;
        }

        private void common() {
            this.fetchData.endTime = System.currentTimeMillis();
            this.fetchData.httpGet.reset();
        }

        public void completed(Void result) {
            this.common();
            this.results.add(this.fetchData);
        }

        public void failed(Exception ex) {
            this.common();
            this.fetchData.exception = ex instanceof ClosedChannelException && this.fetchData.truncated ? null : ex;
            this.results.add(this.fetchData);
        }

        public void cancelled() {
            this.common();
            this.fetchData.exception = CANCELLED;
            this.results.add(this.fetchData);
        }
    }
}

