/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.longs.LongHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;

public class ByteArrayDiskQueues
implements Closeable,
Size64 {
    private static final boolean DEBUG = false;
    public static final int DEFAULT_LOG2_LOG_FILE_SIZE = 26;
    protected final int log2LogFileSize;
    protected final int logFileSize;
    protected final int logFilePositionMask;
    public final Reference2ObjectOpenHashMap<Object, QueueData> key2QueueData;
    public final ObjectArrayList<RandomAccessFile> files;
    public final ObjectArrayList<ByteBuffer> buffers;
    public long size;
    public long used;
    public long allocated;
    public long appendPointer;
    private int currBufferIndex;
    private ByteBuffer currBuffer;
    private File dir;

    public ByteArrayDiskQueues(File dir) {
        this(dir, 26);
    }

    public ByteArrayDiskQueues(File dir, int log2LogFileSize) {
        this.dir = dir;
        this.log2LogFileSize = log2LogFileSize;
        this.logFileSize = 1 << log2LogFileSize;
        this.logFilePositionMask = (1 << log2LogFileSize) - 1;
        this.key2QueueData = new Reference2ObjectOpenHashMap();
        this.files = new ObjectArrayList();
        this.buffers = new ObjectArrayList();
    }

    private File file(int logFileIndex) {
        String t = "00000000" + Integer.toHexString(logFileIndex);
        return new File(this.dir, t.substring(t.length() - 8));
    }

    private int bufferIndex(long pointer) {
        return (int)(pointer >>> this.log2LogFileSize);
    }

    private int bufferPosition(long pointer) {
        return (int)(pointer & (long)this.logFilePositionMask);
    }

    public void enqueue(Object key, byte[] array) throws FileNotFoundException, IOException {
        this.enqueue(key, array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object key, byte[] array, int offset, int length) throws FileNotFoundException, IOException {
        QueueData queueData = (QueueData)this.key2QueueData.get(key);
        if (queueData == null) {
            queueData = new QueueData();
            queueData.head = this.appendPointer;
            Reference2ObjectOpenHashMap<Object, QueueData> reference2ObjectOpenHashMap = this.key2QueueData;
            synchronized (reference2ObjectOpenHashMap) {
                this.key2QueueData.put(key, (Object)queueData);
            }
        } else {
            this.pointer(queueData.tail);
            this.writeLong(this.appendPointer);
        }
        ++queueData.count;
        queueData.tail = this.appendPointer;
        long start = this.appendPointer;
        this.pointer(this.appendPointer);
        this.writeLong(0L);
        this.encodeInt(length);
        this.write(array, offset, length);
        this.appendPointer = this.pointer();
        long bytes = this.appendPointer - start;
        this.used += bytes;
        queueData.usage += bytes;
        assert (this.used >= 0L) : this.used;
        ++this.size;
    }

    public byte[] dequeue(Object key) throws IOException {
        QueueData queueData = (QueueData)this.key2QueueData.get(key);
        if (queueData == null) {
            throw new NoSuchElementException();
        }
        long head = queueData.head;
        this.pointer(queueData.head);
        --queueData.count;
        queueData.head = this.readLong();
        int length = this.decodeInt();
        byte[] result = new byte[length];
        this.read(result, 0, length);
        long bytes = this.pointer() - head;
        this.used -= bytes;
        queueData.usage -= bytes;
        if (queueData.count == 0L) {
            this.remove(key);
        }
        --this.size;
        assert (this.used >= 0L) : this.used;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        QueueData queueData;
        Reference2ObjectOpenHashMap<Object, QueueData> reference2ObjectOpenHashMap = this.key2QueueData;
        synchronized (reference2ObjectOpenHashMap) {
            queueData = (QueueData)this.key2QueueData.remove(key);
        }
        if (queueData == null) {
            return;
        }
        this.size -= queueData.count;
        this.used -= queueData.usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(Object key) {
        QueueData queueData;
        Reference2ObjectOpenHashMap<Object, QueueData> reference2ObjectOpenHashMap = this.key2QueueData;
        synchronized (reference2ObjectOpenHashMap) {
            queueData = (QueueData)this.key2QueueData.get(key);
        }
        return queueData == null ? 0L : queueData.count;
    }

    public int numKeys() {
        return this.key2QueueData.size();
    }

    protected int read() throws IOException {
        if (!this.currBuffer.hasRemaining()) {
            this.nextBuffer();
        }
        return this.currBuffer.get() & 0xFF;
    }

    protected long readLong() throws IOException {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l |= (long)this.read();
        }
        return l;
    }

    protected void read(byte[] b, int offset, int length) throws IOException {
        int remaining;
        if (length == 0) {
            return;
        }
        for (int read = 0; read < length; read += Math.min(length - read, remaining)) {
            remaining = this.currBuffer.remaining();
            if (remaining == 0) {
                this.nextBuffer();
                remaining = this.logFileSize;
            }
            this.currBuffer.get(b, offset + read, Math.min(length - read, remaining));
        }
    }

    protected void write(byte b) throws IOException {
        if (!this.currBuffer.hasRemaining()) {
            this.nextBuffer();
        }
        this.currBuffer.put(b);
    }

    protected void writeLong(long l) throws IOException {
        int i = 8;
        while (i-- != 0) {
            this.write((byte)(l >>> i * 8));
        }
    }

    protected void write(byte[] b, int offset, int length) throws IOException {
        int remaining;
        if (length == 0) {
            return;
        }
        for (int written = 0; written < length; written += Math.min(length - written, remaining)) {
            remaining = this.currBuffer.remaining();
            if (remaining == 0) {
                this.nextBuffer();
                remaining = this.logFileSize;
            }
            this.currBuffer.put(b, offset + written, Math.min(length - written, remaining));
        }
    }

    public long pointer() {
        return ((long)this.currBufferIndex << this.log2LogFileSize) + (long)this.currBuffer.position();
    }

    public void pointer(long pointer) throws FileNotFoundException, IOException {
        this.currBufferIndex = this.bufferIndex(pointer);
        assert (this.currBufferIndex <= this.buffers.size());
        if (this.currBufferIndex == this.buffers.size() || (this.currBuffer = (ByteBuffer)this.buffers.get(this.currBufferIndex)) == null) {
            File file;
            if (this.currBufferIndex == this.buffers.size()) {
                this.files.size(this.currBufferIndex + 1);
                this.buffers.size(this.currBufferIndex + 1);
            }
            if (!(file = this.file(this.currBufferIndex)).exists()) {
                this.allocated += (long)this.logFileSize;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            this.files.set(this.currBufferIndex, (Object)randomAccessFile);
            this.currBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.logFileSize);
            this.buffers.set(this.currBufferIndex, (Object)this.currBuffer);
        }
        this.currBuffer.position(this.bufferPosition(pointer));
    }

    private void nextBuffer() throws FileNotFoundException, IOException {
        assert ((this.pointer() & (long)this.logFilePositionMask) == 0L);
        this.pointer(this.pointer());
    }

    public double ratio() {
        if (this.size == 0L) {
            return 1.0;
        }
        return (double)this.used / (double)(this.allocated - (long)(this.logFileSize - this.bufferPosition(this.appendPointer) & this.logFilePositionMask));
    }

    private double gainedRatio(long gain) {
        if (this.size == 0L) {
            return 1.0;
        }
        return (double)this.used / (double)(this.allocated - (long)(this.logFileSize - this.bufferPosition(this.appendPointer) & this.logFilePositionMask) - (gain << this.log2LogFileSize));
    }

    public void collect(double targetRatio) throws IOException {
        int n = this.key2QueueData.size();
        if (n == 0 || this.ratio() >= targetRatio) {
            return;
        }
        Object[] key = new Object[n];
        long[] currentPointer = new long[n];
        long[] previousPointer = new long[n];
        int[] array = new int[n];
        ObjectIterator fastIterator = this.key2QueueData.reference2ObjectEntrySet().fastIterator();
        int i = n;
        while (i-- != 0) {
            Reference2ObjectMap.Entry e = (Reference2ObjectMap.Entry)fastIterator.next();
            key[i] = e.getKey();
            previousPointer[i] = currentPointer[i] = ((QueueData)e.getValue()).head;
            array[i] = i;
        }
        LongHeapSemiIndirectPriorityQueue queue = new LongHeapSemiIndirectPriorityQueue(currentPointer, array);
        LongArrayBitVector deleted = LongArrayBitVector.ofLength((long)this.buffers.size());
        long collectPointer = currentPointer[queue.first()] & (long)(~this.logFilePositionMask);
        int buffer = this.bufferIndex(collectPointer);
        while (buffer-- != 0) {
            this.deleteBuffer(buffer);
        }
        long gain = 0L;
        long moved = 0L;
        int top = queue.first();
        byte[] t = new byte[1024];
        while ((moved & 0x3FFL) != 0L || this.gainedRatio(gain) < targetRatio) {
            int i2;
            this.pointer(currentPointer[top]);
            ++moved;
            long nextPointer = this.readLong();
            int length = this.decodeInt();
            if (length > t.length) {
                t = new byte[length];
            }
            this.read(t, 0, length);
            assert (collectPointer <= currentPointer[top]) : Long.toHexString(collectPointer) + " > " + Long.toHexString(currentPointer[top]);
            long movedEntryPointer = collectPointer;
            this.pointer(collectPointer);
            this.writeLong(nextPointer);
            this.encodeInt(length);
            this.write(t, 0, length);
            collectPointer = this.pointer();
            if (currentPointer[top] == previousPointer[top]) {
                ((QueueData)this.key2QueueData.get((Object)key[top])).head = movedEntryPointer;
            } else {
                this.pointer(previousPointer[top]);
                this.writeLong(movedEntryPointer);
            }
            previousPointer[top] = movedEntryPointer;
            long previousCurrentPointerTop = currentPointer[top];
            if (nextPointer != 0L) {
                currentPointer[top] = nextPointer;
                assert (nextPointer >= collectPointer);
                queue.changed();
            } else {
                ((QueueData)this.key2QueueData.get((Object)key[top])).tail = movedEntryPointer;
                queue.dequeue();
                if (queue.isEmpty()) break;
            }
            top = queue.first();
            for (i2 = this.bufferIndex(previousCurrentPointerTop); i2 < this.bufferIndex(currentPointer[top]); ++i2) {
                if (!this.file(i2).exists() || deleted.set(i2, true)) continue;
                ++gain;
            }
            for (i2 = this.bufferIndex(movedEntryPointer); i2 <= this.bufferIndex(collectPointer); ++i2) {
                if (!deleted.set(i2, false)) continue;
                --gain;
            }
            assert (gain == deleted.count()) : gain + " != " + deleted.count() + " " + deleted;
        }
        if (queue.isEmpty()) {
            int usedBuffers;
            this.appendPointer = collectPointer;
            for (int buffer2 = usedBuffers = this.bufferIndex(collectPointer) + 1; buffer2 < this.buffers.size(); ++buffer2) {
                this.deleteBuffer(buffer2);
            }
            this.buffers.size(usedBuffers);
            this.files.size(usedBuffers);
            assert (this.ratio() == 1.0) : this.ratio() + " != 1";
        } else {
            int d = 0;
            for (int buffer3 = this.bufferIndex(collectPointer + (long)this.logFileSize - 1L); buffer3 < this.bufferIndex(currentPointer[top]); ++buffer3) {
                if (!this.deleteBuffer(buffer3)) continue;
                ++d;
            }
            assert ((long)d == gain) : deleted + " != " + gain;
            assert (this.ratio() >= targetRatio) : this.ratio() + " < " + targetRatio;
        }
    }

    private boolean deleteBuffer(int buffer) throws IOException {
        if (this.buffers.get(buffer) != null) {
            this.buffers.set(buffer, null);
            ((RandomAccessFile)this.files.get(buffer)).close();
            this.files.set(buffer, null);
            this.file(buffer).delete();
            this.allocated -= (long)this.logFileSize;
            return true;
        }
        assert (!this.file(buffer).exists());
        return false;
    }

    protected int encodeInt(int value) throws IOException {
        if (value < 128) {
            this.write((byte)value);
            return 1;
        }
        if (value < 16384) {
            this.write((byte)(value >>> 7 | 0x80));
            this.write((byte)(value & 0x7F));
            return 2;
        }
        if (value < 0x200000) {
            this.write((byte)(value >>> 14 | 0x80));
            this.write((byte)(value >>> 7 | 0x80));
            this.write((byte)(value & 0x7F));
            return 3;
        }
        if (value < 0x10000000) {
            this.write((byte)(value >>> 21 | 0x80));
            this.write((byte)(value >>> 14 | 0x80));
            this.write((byte)(value >>> 7 | 0x80));
            this.write((byte)(value & 0x7F));
            return 4;
        }
        this.write((byte)(value >>> 28 | 0x80));
        this.write((byte)(value >>> 21 | 0x80));
        this.write((byte)(value >>> 14 | 0x80));
        this.write((byte)(value >>> 7 | 0x80));
        this.write((byte)(value & 0x7F));
        return 5;
    }

    protected int decodeInt() throws IOException {
        int x = 0;
        while (true) {
            int b = this.read();
            x |= b & 0x7F;
            if ((b & 0x80) == 0) {
                return x;
            }
            x <<= 7;
        }
    }

    public long size64() {
        return this.size;
    }

    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size);
    }

    @Override
    public void close() throws IOException {
        for (RandomAccessFile file : this.files) {
            if (file == null) continue;
            file.close();
        }
    }

    public static final class QueueData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public long head;
        public long tail;
        public long count;
        public long usage;
    }
}

