/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import it.unimi.dsi.fastutil.bytes.ByteArrays;

public class ByteArrayCharSequence
implements CharSequence {
    private byte[] b;
    private int offset;
    private int length;

    public ByteArrayCharSequence(byte[] b, int offset, int length) {
        this.wrap(b, offset, length);
    }

    public ByteArrayCharSequence(byte[] b) {
        this(b, 0, b.length);
    }

    public ByteArrayCharSequence() {
        this(ByteArrays.EMPTY_ARRAY);
    }

    public ByteArrayCharSequence wrap(byte[] b, int offset, int length) {
        ByteArrays.ensureOffsetLength((byte[])b, (int)offset, (int)length);
        this.b = b;
        this.offset = offset;
        this.length = length;
        return this;
    }

    public void wrap(byte[] b) {
        this.wrap(b, 0, b.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return (char)(this.b[this.offset + index] & 0xFF);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end > this.length || end < 0 || end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteArrayCharSequence(this.b, start + this.offset, end - start);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            builder.append((char)(this.b[this.offset + i] & 0xFF));
        }
        return builder.toString();
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.length; ++i) {
            h = 31 * h + this.b[this.offset + i];
        }
        return h;
    }
}

