/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import com.google.common.base.Charsets;
import it.unimi.di.law.bubing.util.BURL;
import it.unimi.di.law.bubing.util.MurmurHash3;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.jai4j.Job;
import java.io.Serializable;

public class BubingJob
implements Job,
Serializable {
    private static final long serialVersionUID = 1L;
    public final ByteArrayList url;

    public BubingJob(ByteArrayList url) {
        this.url = url;
    }

    public long hash64() {
        byte[] urlBuffer = this.url.elements();
        int startOfHost = BURL.startOfHost(urlBuffer);
        return MurmurHash3.hash(urlBuffer, startOfHost, BURL.lengthOfHost(urlBuffer, startOfHost));
    }

    public String toString() {
        return "[" + new String(this.url.elements(), 0, this.url.size(), Charsets.ISO_8859_1) + "]";
    }
}

