/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.util;

import com.google.common.base.Charsets;
import com.google.common.primitives.Bytes;
import it.unimi.di.law.bubing.util.Util;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.lang.MutableString;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BURL {
    private static final Logger LOGGER = LoggerFactory.getLogger(BURL.class);
    private static final boolean DEBUG = false;
    public static final char[] FORBIDDEN_CHARS = new char[]{'\n', '\r'};
    public static final char[] BAD_CHAR = new char[]{'\\', ' ', '\t', '[', ']', '\"', '|', '{', '}', '^', '<', '>', '`'};
    public static final String[] BAD_CHAR_SUBSTITUTE = new String[BAD_CHAR.length];
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private BURL() {
    }

    public static URI parse(String spec) {
        return BURL.parse(new MutableString(spec));
    }

    public static URI parse(MutableString spec) {
        int l;
        spec.loose().trim();
        if (spec.indexOfAnyOf(FORBIDDEN_CHARS) != -1) {
            return null;
        }
        spec.replace(BAD_CHAR, BAD_CHAR_SUBSTITUTE);
        char[] a = spec.array();
        int i = l = spec.length();
        while (i-- != 0) {
            if (a[i] != '%') continue;
            if (i >= l - 2 || !BURL.isHexDigit(a[i + 1]) || !BURL.isHexDigit(a[i + 2])) {
                spec.insert(i + 1, "25");
                continue;
            }
            spec.setCharAt(i + 1, Character.toUpperCase(spec.charAt(i + 1)));
            spec.setCharAt(i + 2, Character.toUpperCase(spec.charAt(i + 2)));
        }
        try {
            String scheme;
            URI uri = new URI(spec.toString()).normalize();
            if (uri.isOpaque()) {
                return null;
            }
            if (uri.isAbsolute()) {
                uri.parseServerAuthority();
            }
            if ((scheme = uri.getScheme()) != null) {
                if (scheme.indexOf(0) != -1) {
                    return null;
                }
                scheme = scheme.toLowerCase();
            }
            if (uri.isAbsolute() && uri.getAuthority() == null) {
                return null;
            }
            if (uri.getPath() != null && uri.getPath().indexOf(0) != -1) {
                return null;
            }
            if (uri.getUserInfo() != null && uri.getUserInfo().indexOf(0) != -1) {
                return null;
            }
            if (uri.getQuery() != null && uri.getQuery().indexOf(0) != -1) {
                return null;
            }
            String host = uri.getHost();
            if (host != null) {
                if (host.indexOf(0) != -1) {
                    return null;
                }
                if (host.endsWith(".")) {
                    host = host.substring(0, host.length() - 1);
                }
                host = host.toLowerCase();
            }
            String rawPath = uri.getRawPath();
            if (host != null && (rawPath == null || rawPath.length() == 0)) {
                rawPath = "/";
            }
            return new URI(BURL.sanitizeAndRepack(scheme, uri.getRawUserInfo(), host, uri.getPort(), rawPath, uri.getRawQuery())).normalize();
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception while parsing " + spec, (Throwable)e);
            return null;
        }
    }

    private static String sanitize(String s) {
        int i = s.length();
        i = s.length();
        while (i-- != 0 && s.charAt(i) < '\u0080') {
        }
        if (i == -1) {
            return s;
        }
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(CharBuffer.wrap(s));
        StringBuilder stringBuilder = new StringBuilder();
        while (byteBuffer.hasRemaining()) {
            int b = byteBuffer.get() & 0xFF;
            if (b >= 128) {
                stringBuilder.append('%').append(HEX_DIGIT[b >> 4 & 0xF]).append(HEX_DIGIT[b & 0xF]);
                continue;
            }
            stringBuilder.append((char)b);
        }
        return stringBuilder.toString();
    }

    private static String sanitizeAndRepack(String scheme, String userInfo, String host, int port, String path, String query) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(BURL.sanitize(scheme)).append(':');
            if (scheme.equalsIgnoreCase("http") && port == 80 || scheme.equalsIgnoreCase("https") && port == 443) {
                port = -1;
            }
        }
        if (host != null) {
            boolean needBrackets;
            sb.append("//");
            if (userInfo != null) {
                sb.append(BURL.sanitize(userInfo)).append('@');
            }
            boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
            if (needBrackets) {
                sb.append('[');
            }
            sb.append(BURL.sanitize(host));
            if (needBrackets) {
                sb.append(']');
            }
            if (port != -1) {
                sb.append(':').append(port);
            }
        }
        if (path != null) {
            sb.append(BURL.sanitize(path));
        }
        if (query != null) {
            sb.append('?').append(BURL.sanitize(query));
        }
        return sb.toString();
    }

    public static URI fromNormalizedByteArray(byte[] normalized) {
        return URI.create(Util.toString(normalized));
    }

    public static URI fromNormalizedSchemeAuthorityAndPathQuery(String schemeAuthority, byte[] normalizedPathQuery) {
        char[] array = new char[schemeAuthority.length() + normalizedPathQuery.length];
        schemeAuthority.getChars(0, schemeAuthority.length(), array, 0);
        int i = array.length;
        int j = normalizedPathQuery.length;
        while (j-- != 0) {
            array[--i] = (char)normalizedPathQuery[j];
        }
        return URI.create(new String(array));
    }

    public static URI fromNormalizedSchemeAuthorityAndPathQuery(byte[] schemeAuthority, byte[] normalizedPathQuery) {
        char[] array = new char[schemeAuthority.length + normalizedPathQuery.length];
        int i = schemeAuthority.length;
        while (i-- != 0) {
            array[i] = (char)schemeAuthority[i];
        }
        i = array.length;
        int j = normalizedPathQuery.length;
        while (j-- != 0) {
            array[--i] = (char)normalizedPathQuery[j];
        }
        return URI.create(new String(array));
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static byte[] toByteArray(URI url) {
        return Util.toByteArray(url.toString());
    }

    public static ByteArrayList toByteArrayList(URI url, ByteArrayList list) {
        return Util.toByteArrayList(url.toString(), list);
    }

    public static byte[] pathAndQueryAsByteArray(URI url) {
        String query = url.getRawQuery();
        String path = url.getRawPath();
        byte[] result = new byte[path.length() + (query != null ? 1 + query.length() : 0)];
        int i = path.length();
        while (i-- != 0) {
            assert (path.charAt(i) < '\u0080') : path.charAt(i);
            result[i] = (byte)(path.charAt(i) & 0x7F);
        }
        if (query != null) {
            result[path.length()] = 63;
            int j = query.length();
            int i2 = result.length;
            while (j-- != 0) {
                assert (query.charAt(j) < '\u0080') : query.charAt(j);
                result[--i2] = (byte)(query.charAt(j) & 0x7F);
            }
        }
        return result;
    }

    public static String pathAndQuery(URI url) {
        String query = url.getRawQuery();
        return query != null ? url.getRawPath() + '?' + query : url.getRawPath();
    }

    public static String schemeAndAuthority(URI url) {
        return url.getScheme() + "://" + url.getRawAuthority();
    }

    public static byte[] pathAndQueryAsByteArray(byte[] url) {
        int startOfAuthority = Bytes.indexOf((byte[])url, (byte)58) + 3;
        assert (url[startOfAuthority - 1] == 47) : url[startOfAuthority - 1];
        assert (url[startOfAuthority - 2] == 47) : url[startOfAuthority - 2];
        return Arrays.copyOfRange(url, ArrayUtils.indexOf((byte[])url, (byte)47, (int)startOfAuthority), url.length);
    }

    public static byte[] pathAndQueryAsByteArray(ByteArrayList url) {
        byte[] array = url.elements();
        int startOfAuthority = Bytes.indexOf((byte[])array, (byte)58) + 3;
        assert (array[startOfAuthority - 1] == 47) : array[startOfAuthority - 1];
        assert (array[startOfAuthority - 2] == 47) : array[startOfAuthority - 2];
        return Arrays.copyOfRange(array, ArrayUtils.indexOf((byte[])array, (byte)47, (int)startOfAuthority), url.size());
    }

    public static int startOfpathAndQuery(byte[] url) {
        int i = 0;
        int j = 2;
        while (url[i] != 47 || j-- != 0) {
            ++i;
        }
        return i;
    }

    public static byte[] schemeAndAuthorityAsByteArray(byte[] url) {
        return Arrays.copyOfRange(url, 0, BURL.startOfpathAndQuery(url));
    }

    public static String hostFromSchemeAndAuthority(byte[] schemeAuthority) {
        int startOfHost;
        int endOfHost;
        int startOfAuthority;
        int length = schemeAuthority.length;
        for (int atPosition = startOfAuthority = ArrayUtils.indexOf((byte[])schemeAuthority, (byte)58) + 3; atPosition < length && schemeAuthority[atPosition] != 64; ++atPosition) {
        }
        for (endOfHost = startOfHost = atPosition != length ? atPosition + 1 : startOfAuthority; endOfHost < length && schemeAuthority[endOfHost] != 58; ++endOfHost) {
        }
        char[] host = new char[endOfHost - startOfHost];
        for (int i = startOfHost; i < endOfHost; ++i) {
            host[i - startOfHost] = (char)schemeAuthority[i];
        }
        return new String(host);
    }

    public static final int startOfHost(byte[] url) {
        int atPosition;
        int startOfAuthority = ArrayUtils.indexOf((byte[])url, (byte)58) + 3;
        int endOfAuthority = ArrayUtils.indexOf((byte[])url, (byte)47, (int)startOfAuthority);
        for (atPosition = startOfAuthority; atPosition < endOfAuthority && url[atPosition] != 64; ++atPosition) {
        }
        return atPosition != endOfAuthority ? atPosition + 1 : startOfAuthority;
    }

    public static final int lengthOfHost(byte[] url, int startOfHost) {
        int endOfHost = startOfHost;
        while (url[++endOfHost] != 58 && url[endOfHost] != 47) {
        }
        return endOfHost - startOfHost;
    }

    public static String schemeAndAuthority(byte[] url) {
        int i = 0;
        int j = 2;
        while (url[i] != 47 || j-- != 0) {
            ++i;
        }
        char[] array = new char[i];
        i = array.length;
        while (i-- != 0) {
            array[i] = (char)url[i];
        }
        return new String(array);
    }

    public static int memoryUsageOf(byte[] array) {
        return (16 + array.length + 7 & 0xFFFFFFF8) + 8;
    }

    static {
        BURL.BAD_CHAR_SUBSTITUTE[0] = "/";
        int i = BAD_CHAR.length;
        while (i-- != 1) {
            BURL.BAD_CHAR_SUBSTITUTE[i] = (BAD_CHAR[i] < '\u0010' ? "%0" : "%") + Integer.toHexString(BAD_CHAR[i]).toUpperCase();
        }
    }
}

