/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.tool;

import com.google.common.base.Charsets;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;

public class GenerateGraphMap {
    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(GenerateGraphMap.class.getName(), "Generates a graph map, and prints on standard output the number of nodes of the graph.", new Parameter[]{new FlaggedOption("input", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, 'i', "input", "An input file.").setAllowMultipleDeclarations(true), new UnflaggedOption("urls", (StringParser)JSAP.STRING_PARSER, false, "The name of the file that will contain all URLs."), new UnflaggedOption("nodes", (StringParser)JSAP.STRING_PARSER, false, "The name of the binary file that will contain the corresponding nodes."), new UnflaggedOption("nonDuplicateUrls", (StringParser)JSAP.STRING_PARSER, false, "The name of the file that will contain non-duplicate URLs, prefixed with their node and followed by their status line.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        MutableString s = new MutableString();
        ProgressLogger pl = new ProgressLogger();
        long maxGlobalPosition = -1L;
        PrintStream urls = new PrintStream((OutputStream)new FileOutputStream(jsapResult.getString("urls")), false, "US-ASCII");
        PrintStream nonDuplicateUrls = new PrintStream((OutputStream)new FileOutputStream(jsapResult.getString("nonDuplicateUrls")), false, "US-ASCII");
        DataOutputStream positions = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(jsapResult.getString("nodes"))));
        for (String input : jsapResult.getStringArray("input")) {
            FastBufferedReader fastBufferedReader = new FastBufferedReader((Reader)new InputStreamReader((InputStream)new FileInputStream(input), Charsets.US_ASCII));
            long globalOffset = maxGlobalPosition + 1L;
            pl.itemsName = "lines";
            pl.start((CharSequence)"Reading... ");
            long lastLocalFinalPosition = Long.MIN_VALUE;
            long line = 0L;
            while (fastBufferedReader.readLine(s) != null) {
                try {
                    int firstTab = s.indexOf('\t');
                    int secondTab = s.indexOf('\t', firstTab + 1);
                    int thirdTab = s.indexOf('\t', secondTab + 1);
                    long localFinalPosition = Long.parseLong(new String(s.array(), secondTab + 1, thirdTab - secondTab - 1));
                    MutableString url = s.substring(0, firstTab);
                    MutableString status = s.substring(thirdTab + 1);
                    url.println(urls);
                    if (localFinalPosition != -1L) {
                        lastLocalFinalPosition = localFinalPosition;
                        if (lastLocalFinalPosition + globalOffset > maxGlobalPosition) {
                            maxGlobalPosition = lastLocalFinalPosition + globalOffset;
                        }
                        nonDuplicateUrls.print(lastLocalFinalPosition + globalOffset);
                        nonDuplicateUrls.print('\t');
                        url.print(nonDuplicateUrls);
                        nonDuplicateUrls.print('\t');
                        status.println(nonDuplicateUrls);
                        assert (status.indexOf('\n') < 0);
                    }
                    positions.writeLong(lastLocalFinalPosition + globalOffset);
                    pl.lightUpdate();
                }
                catch (Exception e) {
                    System.err.println("Exception at line " + line);
                    throw new RuntimeException(e);
                }
                ++line;
            }
            pl.done();
            fastBufferedReader.close();
        }
        urls.close();
        nonDuplicateUrls.close();
        positions.close();
        System.out.println(maxGlobalPosition + 1L);
    }
}

