/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.test;

import com.google.common.base.Charsets;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.di.law.bubing.test.ImmutableGraphNamedGraphServer;
import it.unimi.di.law.bubing.test.NamedGraphServer;
import it.unimi.di.law.bubing.test.RandomNamedGraphServer;
import it.unimi.di.law.bubing.util.ByteArrayCharSequence;
import it.unimi.di.law.bubing.util.MurmurHash3;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.StringMap;
import it.unimi.dsi.util.XoRoShiRo128PlusRandom;
import it.unimi.dsi.webgraph.ImmutableGraph;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringEscapeUtils;

public class NamedGraphServerHttpProxy
extends Thread {
    private static AtomicLong busyTime = new AtomicLong();

    public static void generate(long hashCode, StringBuilder content, CharSequence[] successors, boolean notescurl) {
        content.append("<html>\n<head></head>\n<body>\n");
        content.append("<h1>").append((char)((hashCode & 0xFL) + 65L)).append((char)((hashCode >>> 4 & 0xFL) + 65L)).append((char)((hashCode >>> 8 & 0xFL) + 65L)).append((char)((hashCode >>> 12 & 0xFL) + 65L)).append("</h1>\n");
        for (CharSequence s : successors) {
            String ref = s.toString();
            if (!notescurl) {
                ref = StringEscapeUtils.escapeHtml((String)s.toString());
            }
            content.append("<p>Lorem ipsum dolor sit amet <a href=\"" + ref + "\">" + ref + "</a>, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n");
        }
        content.append("</body>\n</html>\n");
    }

    private static void generateUnique(long hashCode, StringBuilder content, CharSequence[] successors, boolean notescurl) {
        content.append("<h1>");
        content.append(("" + hashCode).replace('0', 'g').replace('1', 'h').replace('2', 'i').replace('3', 'l').replace('4', 'm').replace('5', 'n').replace('6', 'o').replace('7', 'p').replace('8', 'q').replace('9', 'r'));
        content.append("</h1>\n");
        content.append("<h1>").append(hashCode).append("</h1>\n");
        NamedGraphServerHttpProxy.generate(hashCode, content, successors, notescurl);
    }

    public static final int estimateLength(CharSequence[] successors) {
        return 600 * (successors == null ? 1 : successors.length + 1);
    }

    public static void main(String[] arg) throws IOException, JSAPException, ClassNotFoundException {
        int port;
        SimpleJSAP jsap = new SimpleJSAP(NamedGraphServerHttpProxy.class.getName(), "Starts a HTTP Proxy Server for a given named immutable graph.", new Parameter[]{new FlaggedOption("sites", (StringParser)JSAP.INTSIZE_PARSER, JSAP.NO_DEFAULT, false, 's', "sites", "The number of sites for a random server."), new FlaggedOption("degree", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 'd', "degree", "The (out)degree of for a random server."), new FlaggedOption("maxDepth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 'm', "max-depth", "The maximum depth of a site for a random server."), new FlaggedOption("frac404", (StringParser)JSAP.DOUBLE_PARSER, "0", false, '4', "frac-404", "The fraction of 404 pages."), new FlaggedOption("frac500", (StringParser)JSAP.DOUBLE_PARSER, "0", false, '5', "frac-500", "The fraction of 505 pages."), new FlaggedOption("fracDelayed", (StringParser)JSAP.DOUBLE_PARSER, "0", false, 'D', "frac-delayed", "The fraction of pages that exhibit delays in the connection."), new FlaggedOption("averageDelay", (StringParser)JSAP.LONGSIZE_PARSER, "1000", false, 'A', "average-delay", "The average delay (in ms) per line in a delayed connection."), new FlaggedOption("generalPageSpeed", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(Integer.MAX_VALUE), false, 'g', "general-page-speed", "The page speed in bytes per second."), new FlaggedOption("delayDeviation", (StringParser)JSAP.LONGSIZE_PARSER, "1000", false, 'S', "delay-deviation", "The standard deviation of delays (in ms) per line in a delayed connection."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "1", false, 't', "threads", "The number of threads for a multithreaded server."), new FlaggedOption("port", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(8080), false, 'p', "port", "The proxy port."), new FlaggedOption("seed", (StringParser)JSAP.LONG_PARSER, "0", false, 'r', "seed", "The seed used to decide delays."), new Switch("uniquify", 'u', "uniquify", "Append at the beginning of each page a string representation of the hashcode of the URL (to avoid duplicated pages when all links differ only for the presence of digits)."), new Switch("notescurl", 'e', "notescurl", "If true the URLs in the produced page are not escaped"), new Switch("padding", 'h', "padding", "If true the URLs are not padded, meaning that each host is of the type x.x.x.x, where x starts with a number (just for random server)"), new UnflaggedOption("graph", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of graph (- for a random server)."), new UnflaggedOption("map", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The string map for a graph-based server.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        if ((port = jsapResult.getInt("port")) <= 0 || port > 65536) {
            System.err.println("Port value must be in (0, 65535].");
            System.exit(1);
        }
        String graphBasename = jsapResult.getString("graph");
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            System.err.println("Started on: " + port);
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: " + port);
            System.exit(1);
            return;
        }
        NamedGraphServer graphServer = null;
        if ("-".equals(graphBasename)) {
            if (!jsapResult.userSpecified("sites")) {
                throw new IllegalArgumentException("You must specify the number of sites of the random server.");
            }
            if (!jsapResult.userSpecified("degree")) {
                throw new IllegalArgumentException("You must specify the degree of the random server.");
            }
            if (!jsapResult.userSpecified("maxDepth")) {
                throw new IllegalArgumentException("You must specify the maximum depth of the random server.");
            }
            if (jsapResult.userSpecified("map")) {
                throw new IllegalArgumentException("You must specify the map only for a graph-based server.");
            }
            graphServer = new RandomNamedGraphServer(jsapResult.getInt("sites"), jsapResult.getInt("degree"), jsapResult.getInt("maxDepth"), jsapResult.getBoolean("padding"));
        } else {
            if (jsapResult.getBoolean("padding")) {
                throw new IllegalArgumentException("You can specify the padding option only for a random server.");
            }
            if (jsapResult.userSpecified("sites")) {
                throw new IllegalArgumentException("You must specify the number of sites only for a random server.");
            }
            if (jsapResult.userSpecified("degree")) {
                throw new IllegalArgumentException("You must specify the degree only for a random server.");
            }
            if (jsapResult.userSpecified("maxDepth")) {
                throw new IllegalArgumentException("You must specify the maximum depth only for a random server.");
            }
            if (!jsapResult.userSpecified("map")) {
                throw new IllegalArgumentException("You must specify the map of a graph-based server.");
            }
            ImmutableGraph graph = ImmutableGraph.load((CharSequence)graphBasename);
            StringMap map = (StringMap)BinIO.loadObject((CharSequence)jsapResult.getString("map"));
            graphServer = new ImmutableGraphNamedGraphServer(graph, (StringMap<? extends CharSequence>)map);
        }
        int numThreads = jsapResult.getInt("threads");
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        Semaphore stuckInCapriciousWriting = new Semaphore(Math.max(numThreads / 10, 1));
        long lastReportTime = System.currentTimeMillis();
        long lastBusyTime = 0L;
        long startTime = lastReportTime;
        long i = 0L;
        while (true) {
            long currentTime;
            Task task = new Task(serverSocket.accept(), (NamedGraphServer)graphServer.copy(), stuckInCapriciousWriting, jsapResult.getInt("generalPageSpeed"), jsapResult.getDouble("frac404"), jsapResult.getDouble("frac500"), jsapResult.getDouble("fracDelayed"), jsapResult.getLong("averageDelay"), jsapResult.getLong("delayDeviation"), jsapResult.getBoolean("uniquify"), jsapResult.getBoolean("notescurl"));
            exec.execute(task);
            if ((i & 0xFFFFL) != 0L && (currentTime = System.currentTimeMillis()) - lastReportTime > 10000L) {
                long currentBusyTime = busyTime.get();
                System.err.println(Util.format((double)((double)currentBusyTime / 10000.0 / (double)numThreads / (double)(currentTime - startTime))) + "% [" + Util.format((double)((double)(currentBusyTime - lastBusyTime) / 10000.0 / (double)numThreads / (double)(currentTime - lastReportTime))) + "%]");
                lastReportTime = currentTime;
                lastBusyTime = currentBusyTime;
            }
            ++i;
        }
    }

    private static class Task
    implements Runnable {
        private final Socket socket;
        private final NamedGraphServer graphServer;
        private final double frac404;
        private final double frac500;
        private final XoRoShiRo128PlusRandom frac500Random;
        private final double fracDelayed;
        private final long averageDelay;
        private final long delayDeviation;
        private final Semaphore stuckInCapriciousWriting;
        private final int generalPageSpeed;
        private final boolean uniquify;
        private final boolean notescurl;

        public Task(Socket socket, NamedGraphServer graphServer, Semaphore stuckInCapriciousWriting, int generalPageSpeed, double frac404, double frac500, double fracDelayed, long averageDelay, long delayDeviation, boolean undigitize, boolean notescurl) {
            this.socket = socket;
            this.graphServer = graphServer;
            this.stuckInCapriciousWriting = stuckInCapriciousWriting;
            this.generalPageSpeed = generalPageSpeed;
            this.frac404 = frac404;
            this.frac500 = frac500;
            this.frac500Random = new XoRoShiRo128PlusRandom();
            this.fracDelayed = fracDelayed;
            this.averageDelay = averageDelay;
            this.delayDeviation = delayDeviation;
            this.uniquify = undigitize;
            this.notescurl = notescurl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.nanoTime();
                FastBufferedInputStream in = new FastBufferedInputStream(this.socket.getInputStream());
                byte[] array = new byte[4096];
                int len = in.readLine(array);
                int first = -1;
                int second = -1;
                for (int i = 0; i < len; ++i) {
                    if (array[i] != 32) continue;
                    if (first == -1) {
                        first = i;
                        continue;
                    }
                    second = i;
                    break;
                }
                if (this.frac500Random.nextDouble() > 1.0 - this.frac500 || first == -1 || second == -1) {
                    PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FastBufferedOutputStream(this.socket.getOutputStream()), Charsets.ISO_8859_1));
                    out.println("HTTP/1.1 500 Server error");
                    out.println();
                    out.close();
                } else {
                    ByteArrayCharSequence name = new ByteArrayCharSequence(array, first + 1, second - first - 1);
                    int hashCode = name.hashCode();
                    XoRoShiRo128PlusRandom random = new XoRoShiRo128PlusRandom((long)hashCode);
                    PrintWriter out = random.nextDouble() < this.fracDelayed && this.stuckInCapriciousWriting.tryAcquire() ? new CapriciousPrintWriter(new OutputStreamWriter((OutputStream)new FastBufferedOutputStream(this.socket.getOutputStream()), Charsets.ISO_8859_1), this.averageDelay, this.delayDeviation, random) : new PrintWriter(new OutputStreamWriter((OutputStream)new FastBufferedOutputStream(this.socket.getOutputStream()), Charsets.ISO_8859_1));
                    try {
                        CharSequence[] successors = this.graphServer.successors(name);
                        MutableString currentName = new MutableString((CharSequence)name);
                        while (in.readLine(array) > 0) {
                        }
                        StringBuilder content = new StringBuilder(NamedGraphServerHttpProxy.estimateLength(successors));
                        if (successors == null || random.nextDouble() < this.frac404) {
                            content.append("<html>\n");
                            content.append("<head></head>\n");
                            content.append("<body>\n");
                            content.append("<h1>404 Not found</h1>\n");
                            content.append("</body>\n");
                            content.append("</html>\n");
                            out.println("HTTP/1.1 404 Not found");
                            out.println("Connection: close");
                            out.println("Content-Type: text/html; charset=iso-8859-1");
                            out.println("Content-Length: " + content.length());
                            out.println();
                            out.println(content.toString());
                            out.println();
                        } else {
                            if (this.uniquify) {
                                NamedGraphServerHttpProxy.generateUnique(MurmurHash3.hash(currentName.toString().getBytes()), content, successors, this.notescurl);
                            } else {
                                NamedGraphServerHttpProxy.generate(hashCode, content, successors, this.notescurl);
                            }
                            out.println("HTTP/1.1 200 OK");
                            out.println("Connection: close");
                            out.println("Content-Type: text/html; charset=iso-8859-1");
                            out.println("Content-Length: " + content.length());
                            out.println();
                            out.println(content.toString());
                            out.println();
                        }
                        try {
                            Thread.sleep((long)(1000.0 * (double)content.length() / (double)this.generalPageSpeed));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        out.close();
                    }
                    finally {
                        if (out instanceof CapriciousPrintWriter) {
                            this.stuckInCapriciousWriting.release();
                        }
                    }
                }
                in.close();
                this.socket.close();
                busyTime.addAndGet(System.nanoTime() - startTime);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class CapriciousPrintWriter
    extends PrintWriter {
        private final XoRoShiRo128PlusRandom random;
        private final long averageDelay;
        private final long delayDeviation;

        public CapriciousPrintWriter(Writer writer, long averageDelay, long delayDeviation, XoRoShiRo128PlusRandom random) {
            super(writer);
            this.averageDelay = averageDelay;
            this.delayDeviation = delayDeviation;
            this.random = random;
        }

        private void sleep() {
            long delay = Math.abs((long)(this.random.nextGaussian() * (double)this.delayDeviation + (double)this.averageDelay));
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void println(String s) {
            this.sleep();
            super.println(s);
            super.flush();
        }

        @Override
        public void print(String s) {
            this.sleep();
            super.print(s);
            super.flush();
        }

        @Override
        public void println() {
            this.sleep();
            super.println();
            super.flush();
        }
    }
}

