/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.test;

import it.unimi.di.law.bubing.test.NamedGraphServer;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.util.StringMap;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;

public class ImmutableGraphNamedGraphServer
implements NamedGraphServer {
    private final ImmutableGraph graph;
    private StringMap<? extends CharSequence> map;
    private ObjectList<? extends CharSequence> list;

    public ImmutableGraphNamedGraphServer(ImmutableGraph graph, StringMap<? extends CharSequence> map) {
        if (graph.numNodes() != map.size()) {
            throw new IllegalArgumentException("The graph has " + graph.numNodes() + " nodes, but the map has " + map.size() + " keys.");
        }
        this.graph = graph;
        this.map = map;
        this.list = map.list();
    }

    @Override
    public CharSequence[] successors(CharSequence name) {
        int s;
        long srcNode = this.map.getLong((Object)name);
        if (srcNode < 0L) {
            return null;
        }
        int degree = this.graph.outdegree((int)srcNode);
        CharSequence[] result = new CharSequence[degree];
        LazyIntIterator successors = this.graph.successors((int)srcNode);
        int i = 0;
        while ((s = successors.nextInt()) != -1) {
            result[i] = (CharSequence)this.list.get(s);
            ++i;
        }
        return result;
    }

    public ImmutableGraphNamedGraphServer copy() {
        return new ImmutableGraphNamedGraphServer(this.graph.copy(), this.map);
    }
}

