/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.store;

import it.unimi.di.law.bubing.RuntimeConfiguration;
import it.unimi.di.law.bubing.store.Store;
import it.unimi.di.law.warc.io.CompressedWarcWriter;
import it.unimi.di.law.warc.io.UncompressedWarcWriter;
import it.unimi.di.law.warc.io.WarcWriter;
import it.unimi.di.law.warc.records.HttpResponseWarcRecord;
import it.unimi.di.law.warc.records.WarcHeader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.message.HeaderGroup;

public class UnbufferedFileStore
implements Closeable,
Store {
    public final int OUTPUT_STREAM_BUFFER_SIZE = 0x100000;
    public static final String STORE_NAME = "store";
    private final FileOutputStream outputStream;
    private final WarcWriter writer;

    public UnbufferedFileStore(RuntimeConfiguration rc) throws IOException {
        File file = new File(rc.storeDir, STORE_NAME);
        if (rc.crawlIsNew) {
            if (file.exists() && file.length() != 0L) {
                throw new IOException("Store exists and it is not empty, but the crawl is new; it will not be overwritten: " + file);
            }
            this.outputStream = new FileOutputStream(file);
        } else {
            if (!file.exists()) {
                throw new IOException("Store does not exist, but the crawl is not new; it will not be created: " + file);
            }
            this.outputStream = new FileOutputStream(file, true);
        }
        this.writer = STORE_NAME.endsWith(".gz") ? new CompressedWarcWriter(this.outputStream) : new UncompressedWarcWriter(this.outputStream);
    }

    @Override
    public synchronized void store(URI uri, HttpResponse response, boolean isDuplicate, byte[] contentDigest, String guessedCharset) throws IOException, InterruptedException {
        if (contentDigest == null) {
            throw new NullPointerException("Content digest is null");
        }
        HttpResponseWarcRecord record = new HttpResponseWarcRecord(uri, response);
        HeaderGroup warcHeaders = record.getWarcHeaders();
        warcHeaders.updateHeader((Header)new WarcHeader(WarcHeader.Name.WARC_PAYLOAD_DIGEST, "bubing:" + Hex.encodeHexString((byte[])contentDigest)));
        if (guessedCharset != null) {
            warcHeaders.updateHeader((Header)new WarcHeader(WarcHeader.Name.BUBING_GUESSED_CHARSET, guessedCharset));
        }
        if (isDuplicate) {
            warcHeaders.updateHeader((Header)new WarcHeader(WarcHeader.Name.BUBING_IS_DUPLICATE, "true"));
        }
        this.writer.write(record);
    }

    @Override
    public synchronized void close() throws IOException {
        this.writer.close();
    }
}

