/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.sieve;

import it.unimi.di.law.bubing.sieve.ByteSerializerDeserializer;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.lang.MutableString;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class CharSequenceByteSerializerDeserializer
implements ByteSerializerDeserializer<CharSequence> {
    private static final CharSequenceByteSerializerDeserializer INSTANCE = new CharSequenceByteSerializerDeserializer();

    protected CharSequenceByteSerializerDeserializer() {
    }

    public static CharSequenceByteSerializerDeserializer getInstance() {
        return INSTANCE;
    }

    @Override
    public void toStream(CharSequence src, OutputStream os) throws IOException {
        new MutableString(src).writeSelfDelimUTF8(os);
    }

    @Override
    public CharSequence fromStream(InputStream is) throws IOException {
        return new MutableString().readSelfDelimUTF8(is);
    }

    @Override
    public void skip(FastBufferedInputStream is) throws IOException {
        int b;
        int length = 0;
        while (true) {
            if ((b = is.read()) < 0) {
                throw new EOFException();
            }
            if ((b & 0x80) == 0) break;
            length |= b & 0x7F;
            length <<= 7;
        }
        length |= b;
        block6: for (int i = 0; i < length; ++i) {
            b = is.read() & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    continue block6;
                }
                case 12: 
                case 13: {
                    is.skip(1L);
                    continue block6;
                }
                case 14: {
                    is.skip(2L);
                    continue block6;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
    }
}

