/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.VisitState;
import it.unimi.di.law.bubing.util.MurmurHash3;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class VisitStateSet
implements Serializable,
Hash {
    private static final long serialVersionUID = 0L;
    protected transient VisitState[] visitState;
    protected transient int n = 1024;
    protected transient int mask = this.n - 1;
    protected int size;
    protected int maxFill = 3 * (this.n / 4);

    public VisitStateSet() {
        this.visitState = new VisitState[this.n];
    }

    public VisitState[] visitStates() {
        return this.visitState;
    }

    public void ensureCapacity(int capacity) {
        this.rehash(HashCommon.arraySize((int)capacity, (float)0.75f));
    }

    public boolean add(VisitState v) {
        int pos = (int)(MurmurHash3.hash(v.schemeAuthority) & (long)this.mask);
        while (this.visitState[pos] != null) {
            if (Arrays.equals(this.visitState[pos].schemeAuthority, v.schemeAuthority)) {
                return false;
            }
            pos = pos + 1 & this.mask;
        }
        this.visitState[pos] = v;
        if (++this.size >= this.maxFill && this.n < 0x40000000) {
            this.rehash(2 * this.n);
        }
        return true;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.visitState[pos] != null) {
                int slot = (int)(MurmurHash3.hash(this.visitState[pos].schemeAuthority) & (long)this.mask);
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (this.visitState[pos] == null) break;
            this.visitState[last] = this.visitState[pos];
        }
        this.visitState[last] = null;
        return last;
    }

    public boolean remove(VisitState k) {
        int pos = (int)(MurmurHash3.hash(k.schemeAuthority) & (long)this.mask);
        while (this.visitState[pos] != null) {
            if (this.visitState[pos] == k) {
                --this.size;
                this.shiftKeys(pos);
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    private static final boolean equals(byte[] a, byte[] b, int offset, int length) {
        while (length-- != 0) {
            if (a[length] == b[offset + length]) continue;
            return false;
        }
        return true;
    }

    public VisitState get(byte[] array) {
        int pos = (int)(MurmurHash3.hash(array) & (long)this.mask);
        while (this.visitState[pos] != null) {
            if (Arrays.equals(this.visitState[pos].schemeAuthority, array)) {
                return this.visitState[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public VisitState get(byte[] array, int offset, int length) {
        int pos = (int)(MurmurHash3.hash(array, offset, length) & (long)this.mask);
        while (this.visitState[pos] != null) {
            if (this.visitState[pos].schemeAuthority.length == length && VisitStateSet.equals(this.visitState[pos].schemeAuthority, array, offset, length)) {
                return this.visitState[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.visitState, null);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected void rehash(int newN) {
        int i = 0;
        VisitState[] visitState = this.visitState;
        int newMask = newN - 1;
        VisitState[] newVisitState = new VisitState[newN];
        int j = this.size;
        while (j-- != 0) {
            while (visitState[i] == null) {
                ++i;
            }
            VisitState v = visitState[i];
            int pos = (int)(MurmurHash3.hash(v.schemeAuthority) & (long)newMask);
            while (newVisitState[pos] != null) {
                pos = pos + 1 & newMask;
            }
            newVisitState[pos] = v;
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = 3 * (this.n / 4);
        this.visitState = newVisitState;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int i = this.visitState.length;
        while (i-- != 0) {
            if (this.visitState[i] == null) continue;
            s.writeObject(this.visitState[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize((int)this.size, (float)0.75f);
        this.maxFill = 3 * (this.n / 4);
        this.mask = this.n - 1;
        this.visitState = new VisitState[this.n];
        VisitState[] visitState = this.visitState;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            VisitState v = (VisitState)s.readObject();
            pos = (int)(MurmurHash3.hash(v.schemeAuthority) & (long)this.mask);
            while (visitState[pos] != null) {
                pos = pos + 1 & this.mask;
            }
        }
    }
}

