/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.util.ByteArrayDiskQueue;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuickMessageThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuickMessageThread.class);
    private final Frontier frontier;
    public volatile boolean stop;

    public QuickMessageThread(Frontier frontier) {
        this.setName(this.getClass().getSimpleName());
        this.setPriority(10);
        this.frontier = frontier;
    }

    @Override
    public void run() {
        try {
            ByteArrayDiskQueue receivedURLs = this.frontier.receivedURLs;
            ArrayBlockingQueue<ByteArrayList> quickReceivedURLs = this.frontier.quickReceivedURLs;
            while (!this.stop) {
                ByteArrayList list = quickReceivedURLs.poll(1L, TimeUnit.SECONDS);
                if (list == null) continue;
                receivedURLs.enqueue(list.elements(), 0, list.size());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected exception ", t);
        }
        LOGGER.info("Completed");
    }
}

