/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.util.ByteArrayDiskQueue;
import it.unimi.di.law.bubing.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageThread.class);
    private final Frontier frontier;
    public volatile boolean stop;

    public MessageThread(Frontier frontier) {
        this.setName(this.getClass().getSimpleName());
        this.frontier = frontier;
    }

    @Override
    public void run() {
        try {
            ByteArrayDiskQueue receivedURLs = this.frontier.receivedURLs;
            while (true) {
                int round = 0;
                while (this.frontier.rc.paused || receivedURLs.isEmpty() || !this.frontier.agent.isConnected() || this.frontier.agent.getAliveCount() == 0) {
                    if (this.stop) {
                        return;
                    }
                    Thread.sleep(1 << Math.min(10, round));
                    ++round;
                }
                receivedURLs.dequeue();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Dequeued URL {} from the message queue", (Object)Util.toString(receivedURLs.buffer()));
                }
                this.frontier.numberOfReceivedURLs.incrementAndGet();
                this.frontier.enqueueLocal(receivedURLs.buffer());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected exception ", t);
            LOGGER.info("Completed");
            return;
        }
    }
}

