/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import com.google.common.primitives.Ints;
import it.unimi.di.law.bubing.RuntimeConfiguration;
import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.frontier.VisitState;
import it.unimi.di.law.bubing.util.BURL;
import it.unimi.di.law.bubing.util.FetchData;
import it.unimi.di.law.bubing.util.LockFreeQueue;
import it.unimi.di.law.bubing.util.URLRespectsRobots;
import it.unimi.di.law.bubing.util.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FetchingThread
extends Thread
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchingThread.class);
    public volatile boolean stop;
    private final Frontier frontier;
    private final HttpClient httpClient;
    private final FetchData fetchData;
    private final BasicCookieStore cookieStore;
    private static final SSLContext TRUST_SELF_SIGNED_SSL_CONTEXT;
    private static final SSLContext TRUST_ALL_CERTIFICATES_SSL_CONTEXT;

    private static int length(String s) {
        return s == null ? 0 : s.length();
    }

    public static Cookie[] getCookies(URI url, CookieStore cookieStore, int cookieMaxByteSize) {
        int overallLength = 0;
        int i = 0;
        List cookies = cookieStore.getCookies();
        for (Cookie cookie : cookies) {
            overallLength += FetchingThread.length(cookie.getName());
            overallLength += FetchingThread.length(cookie.getValue());
            overallLength += FetchingThread.length(cookie.getDomain());
            if ((overallLength += FetchingThread.length(cookie.getPath())) > cookieMaxByteSize) {
                LOGGER.warn("URL " + url + " returned too large cookies (" + overallLength + " characters)");
                return cookies.subList(0, i).toArray(new Cookie[i]);
            }
            ++i;
        }
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    public FetchingThread(Frontier frontier, int index) throws NoSuchAlgorithmException, IllegalArgumentException, IOException {
        this.setName(this.getClass().getSimpleName() + '-' + index);
        this.setPriority(1);
        this.frontier = frontier;
        BasicHttpClientConnectionManagerWithAlternateDNS connManager = new BasicHttpClientConnectionManagerWithAlternateDNS(frontier.rc.dnsResolver);
        connManager.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        connManager.setConnectionConfig(ConnectionConfig.custom().setBufferSize(8192).build());
        this.cookieStore = new BasicCookieStore();
        Object[] headers = new BasicHeader[]{new BasicHeader("From", frontier.rc.userAgentFrom), new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.95,text/*;q=0.9,*/*;q=0.8")};
        this.httpClient = HttpClients.custom().setSSLContext(frontier.rc.acceptAllCertificates ? TRUST_ALL_CERTIFICATES_SSL_CONTEXT : TRUST_SELF_SIGNED_SSL_CONTEXT).setConnectionManager((HttpClientConnectionManager)connManager).setConnectionReuseStrategy((ConnectionReuseStrategy)(frontier.rc.keepAliveTime == 0L ? NoConnectionReuseStrategy.INSTANCE : DefaultConnectionReuseStrategy.INSTANCE)).setUserAgent(frontier.rc.userAgent).setDefaultCookieStore((CookieStore)this.cookieStore).setDefaultHeaders((Collection)ObjectArrayList.wrap((Object[])headers)).build();
        this.fetchData = new FetchData(frontier.rc);
    }

    public void abort() {
        this.fetchData.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            RuntimeConfiguration rc = this.frontier.rc;
            int cookieMaxByteSize = rc.cookieMaxByteSize;
            LockFreeQueue<FetchData> results = this.frontier.results;
            while (!this.stop) {
                VisitState visitState;
                long waitTime = 0L;
                this.frontier.rc.ensureNotPaused();
                int i = 0;
                while ((visitState = this.frontier.todo.poll()) == null) {
                    this.frontier.rc.ensureNotPaused();
                    if (this.stop) {
                        return;
                    }
                    waitTime += (long)(1 << Math.min(i, 10));
                    Thread.sleep(1 << Math.min(i, 10));
                    ++i;
                }
                if (waitTime > 0L) {
                    this.frontier.updateRequestedFrontSize();
                    this.frontier.updateFetchingThreadsWaitingStats(waitTime);
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Acquired visit state {}", (Object)visitState);
                }
                long startTime = System.currentTimeMillis();
                while (!visitState.isEmpty()) {
                    byte[] path = visitState.firstPath();
                    URI url = BURL.fromNormalizedSchemeAuthorityAndPathQuery(visitState.schemeAuthority, path);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Next URL: {}", (Object)url);
                    }
                    if (path == VisitState.ROBOTS_PATH) {
                        this.fetchData.inUse = true;
                        this.cookieStore.clear();
                        try {
                            this.fetchData.fetch(url, this.httpClient, this.frontier.robotsRequestConfig, visitState, true);
                        }
                        catch (Exception shouldntHappen) {
                            LOGGER.error("Unexpected exception during fetch of " + url, (Throwable)shouldntHappen);
                            this.fetchData.inUse = false;
                            visitState.robotsFilter = URLRespectsRobots.EMPTY_ROBOTS_FILTER;
                            long endTime = System.currentTimeMillis();
                            visitState.workbenchEntry.nextFetch = endTime + rc.ipDelay;
                            visitState.nextFetch = endTime + rc.schemeAuthorityDelay;
                            visitState.dequeue();
                            break;
                        }
                        this.frontier.speedDist.incrementAndGet(Math.min(this.frontier.speedDist.length() - 1, Fast.mostSignificantBit((long)(8L * this.fetchData.length() / (1L + this.fetchData.endTime - this.fetchData.startTime))) + 1));
                        this.frontier.transferredBytes.addAndGet(this.fetchData.length());
                        results.add(this.fetchData);
                        try {
                            FetchData shouldntHappen = this.fetchData;
                            synchronized (shouldntHappen) {
                                while (this.fetchData.inUse) {
                                    this.fetchData.wait();
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            LOGGER.warn("Interrupted while waiting for ParsingThread to consume robots FetchData");
                            break;
                        }
                        if (this.fetchData.exception == null && this.frontier.rc.keepAliveTime != 0L && System.currentTimeMillis() - startTime < this.frontier.rc.keepAliveTime) continue;
                        break;
                    }
                    if (!this.frontier.rc.fetchFilter.apply(url)) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("I'm not fetching URL {}", (Object)url);
                        }
                        visitState.dequeue();
                        continue;
                    }
                    if (visitState.robotsFilter != null && !URLRespectsRobots.apply(visitState.robotsFilter, url)) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("URL {} disallowed by robots filter", (Object)url);
                        }
                        visitState.dequeue();
                        continue;
                    }
                    if (visitState.robotsFilter == null) {
                        LOGGER.error("Null robots filter for " + Util.toString(visitState.schemeAuthority));
                    }
                    Lock lock = this.frontier.rc.blackListedHostHashesLock.readLock();
                    boolean dequeued = false;
                    lock.lock();
                    try {
                        if (this.frontier.rc.blackListedHostHashes.contains(url.getHost().hashCode())) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("URL {} disallowed by last-minute check for host blacklisting", (Object)url);
                            }
                            visitState.dequeue();
                            dequeued = true;
                            continue;
                        }
                        dequeued = true;
                    }
                    finally {
                        if (!dequeued) {
                            visitState.dequeue();
                        }
                        lock.unlock();
                        continue;
                    }
                    byte[] address = visitState.workbenchEntry.ipAddress;
                    if (address.length == 4) {
                        lock = this.frontier.rc.blackListedIPv4Lock.readLock();
                        dequeued = false;
                        lock.lock();
                        try {
                            if (this.frontier.rc.blackListedIPv4Addresses.contains(Ints.fromBytes((byte)address[0], (byte)address[1], (byte)address[2], (byte)address[3]))) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("URL {} disallowed by last-minute check for IP blacklisting", (Object)url);
                                }
                                visitState.dequeue();
                                dequeued = true;
                                continue;
                            }
                            dequeued = true;
                        }
                        finally {
                            if (!dequeued) {
                                visitState.dequeue();
                            }
                            lock.unlock();
                            continue;
                        }
                    }
                    this.fetchData.inUse = true;
                    this.cookieStore.clear();
                    if (visitState.cookies != null) {
                        for (Cookie cookie : visitState.cookies) {
                            this.cookieStore.addCookie(cookie);
                        }
                    }
                    try {
                        this.fetchData.fetch(url, this.httpClient, this.frontier.defaultRequestConfig, visitState, false);
                    }
                    catch (Exception shouldntHappen) {
                        LOGGER.error("Unexpected exception during fetch of " + url, (Throwable)shouldntHappen);
                        this.fetchData.inUse = false;
                        long endTime = System.currentTimeMillis();
                        visitState.workbenchEntry.nextFetch = endTime + rc.ipDelay;
                        visitState.nextFetch = endTime + rc.schemeAuthorityDelay;
                        visitState.dequeue();
                        break;
                    }
                    this.frontier.speedDist.incrementAndGet(Math.min(this.frontier.speedDist.length() - 1, Fast.mostSignificantBit((long)(8L * this.fetchData.length() / (1L + this.fetchData.endTime - this.fetchData.startTime))) + 1));
                    this.frontier.transferredBytes.addAndGet(this.fetchData.length());
                    results.add(this.fetchData);
                    if (this.fetchData.exception == null) {
                        visitState.cookies = FetchingThread.getCookies(this.fetchData.uri(), (CookieStore)this.cookieStore, cookieMaxByteSize);
                    }
                    try {
                        FetchData shouldntHappen = this.fetchData;
                        synchronized (shouldntHappen) {
                            while (this.fetchData.inUse) {
                                this.fetchData.wait();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("Interrupted while waiting for ParsingThread to consume FetchData");
                        break;
                    }
                    if (this.fetchData.exception == null && this.frontier.rc.keepAliveTime != 0L && System.currentTimeMillis() - startTime < this.frontier.rc.keepAliveTime) continue;
                    break;
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Releasing visit state {}", (Object)visitState);
                }
                this.frontier.done.add(visitState);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Unexpected exception", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.fetchData.close();
    }

    static {
        try {
            TRUST_SELF_SIGNED_SSL_CONTEXT = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (Exception cantHappen) {
            throw new RuntimeException(cantHappen.getMessage(), cantHappen);
        }
        try {
            TRUST_ALL_CERTIFICATES_SSL_CONTEXT = SSLContexts.custom().loadTrustMaterial(null, (arg0, arg1) -> true).build();
        }
        catch (Exception cantHappen) {
            throw new RuntimeException(cantHappen.getMessage(), cantHappen);
        }
    }

    protected static final class BasicHttpClientConnectionManagerWithAlternateDNS
    extends BasicHttpClientConnectionManager {
        static Registry<ConnectionSocketFactory> getDefaultRegistry() {
            return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createSystemDefault(), new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3", "SSLv2Hello"}, null, (HostnameVerifier)new NoopHostnameVerifier())).build();
        }

        public BasicHttpClientConnectionManagerWithAlternateDNS(DnsResolver dnsResolver) {
            super(BasicHttpClientConnectionManagerWithAlternateDNS.getDefaultRegistry(), null, null, dnsResolver);
        }
    }
}

