/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing.frontier;

import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.frontier.StatsThread;
import it.unimi.di.law.bubing.frontier.VisitState;
import it.unimi.di.law.bubing.frontier.VisitStateSet;
import it.unimi.di.law.bubing.sieve.AbstractSieve;
import it.unimi.di.law.bubing.util.BURL;
import it.unimi.di.law.bubing.util.Util;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Distributor
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(Distributor.class);
    private static final long PURGE_DELAY = TimeUnit.DAYS.toMillis(1L);
    private static final long LOW_COST_STATS_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    private static final long HIGH_COST_STATS_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private static final long PURGE_CHECK_INTERVAL = TimeUnit.MINUTES.toMillis(15L);
    private final Frontier frontier;
    protected final VisitStateSet schemeAuthority2VisitState;
    protected final StatsThread statsThread;
    protected volatile long lastHighCostStat;
    protected volatile long lastPurgeCheck;

    public Distributor(Frontier frontier) {
        this.frontier = frontier;
        this.schemeAuthority2VisitState = new VisitStateSet();
        this.setName(this.getClass().getSimpleName());
        this.setPriority(10);
        this.statsThread = new StatsThread(frontier, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long movedFromQueues = 0L;
            long deletedFromQueues = 0L;
            long lastLowCostStat = 0L;
            long fullWorkbenchSleepTime = 0L;
            long largeFrontSleepTime = 0L;
            long noReadyURLsSleepTime = 0L;
            long movedFromSieveToVirtualizer = 0L;
            long movedFromSieveToOverflow = 0L;
            long movedFromSieveToWorkbench = 0L;
            long deletedFromSieve = 0L;
            int round = 0;
            while (true) {
                this.frontier.rc.ensureNotPaused();
                if (this.frontier.rc.stopping) break;
                long now = System.currentTimeMillis();
                boolean workbenchIsFull = this.frontier.workbenchIsFull();
                boolean frontIsSmall = this.frontIsSmall();
                if (!workbenchIsFull) {
                    AbstractSieve<ByteArrayList, Void> abstractSieve = this.frontier.sieve;
                    synchronized (abstractSieve) {
                    }
                    VisitState visitState = this.frontier.refill.poll();
                    if (visitState != null) {
                        round = -1;
                        if (this.frontier.virtualizer.count(visitState) == 0L) {
                            LOGGER.info("No URLs on disk during refill: " + visitState);
                        } else {
                            int pathQueryLimit = visitState.pathQueryLimit();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Refilling {} with {} URLs", (Object)visitState, (Object)pathQueryLimit);
                            }
                            visitState.checkRobots(now);
                            int dequeuedURLs = this.frontier.virtualizer.dequeuePathQueries(visitState, pathQueryLimit);
                            movedFromQueues += (long)dequeuedURLs;
                        }
                    } else if (frontIsSmall) {
                        if (this.frontier.readyURLs.isEmpty() && now >= this.frontier.nextFlush) {
                            round = -1;
                            this.frontier.sieve.flush();
                            long endOfFlush = System.currentTimeMillis();
                            this.frontier.nextFlush = endOfFlush + Math.max(10000L, (endOfFlush - now) * 10L);
                            now = endOfFlush;
                        }
                        int i = 100;
                        while (i-- != 0 && !this.frontier.readyURLs.isEmpty()) {
                            round = -1;
                            this.frontier.readyURLs.dequeue();
                            ByteArrayList url = this.frontier.readyURLs.buffer();
                            byte[] urlBuffer = url.elements();
                            int startOfpathAndQuery = BURL.startOfpathAndQuery(urlBuffer);
                            int currentlyInStore = this.frontier.schemeAuthority2Count.get(urlBuffer, 0, startOfpathAndQuery);
                            if (currentlyInStore < this.frontier.rc.maxUrlsPerSchemeAuthority) {
                                visitState = this.schemeAuthority2VisitState.get(urlBuffer, 0, startOfpathAndQuery);
                                if (visitState == null) {
                                    byte[] schemeAuthority = BURL.schemeAndAuthorityAsByteArray(urlBuffer);
                                    if (LOGGER.isTraceEnabled()) {
                                        LOGGER.trace("New scheme+authority {} with path+query {}", (Object)Util.toString(schemeAuthority), (Object)Util.toString(BURL.pathAndQueryAsByteArray(url)));
                                    }
                                    visitState = new VisitState(this.frontier, schemeAuthority);
                                    visitState.lastRobotsFetch = Long.MAX_VALUE;
                                    visitState.enqueueRobots();
                                    visitState.enqueuePathQuery(BURL.pathAndQueryAsByteArray(url));
                                    this.schemeAuthority2VisitState.add(visitState);
                                    this.frontier.newVisitStates.add(visitState);
                                    ++movedFromSieveToWorkbench;
                                    continue;
                                }
                                if (this.frontier.virtualizer.count(visitState) > 0L) {
                                    ++movedFromSieveToVirtualizer;
                                    this.frontier.virtualizer.enqueueURL(visitState, url);
                                    continue;
                                }
                                if (visitState.size() < visitState.pathQueryLimit() && visitState.workbenchEntry != null && visitState.lastExceptionClass == null) {
                                    visitState.checkRobots(now);
                                    visitState.enqueuePathQuery(BURL.pathAndQueryAsByteArray(url));
                                    ++movedFromSieveToWorkbench;
                                    continue;
                                }
                                ++movedFromSieveToVirtualizer;
                                this.frontier.virtualizer.enqueueURL(visitState, url);
                                continue;
                            }
                            ++deletedFromSieve;
                        }
                    }
                }
                if (now - LOW_COST_STATS_INTERVAL > lastLowCostStat) {
                    long overallSieve = movedFromSieveToVirtualizer + movedFromSieveToWorkbench + movedFromSieveToOverflow + deletedFromSieve;
                    long overallQueues = movedFromQueues + deletedFromQueues;
                    if (overallSieve != 0L) {
                        LOGGER.info("Moved " + overallSieve + " URLs from sieve (" + it.unimi.dsi.Util.format((double)(100.0 * (double)deletedFromSieve / (double)overallSieve)) + "% deleted, " + it.unimi.dsi.Util.format((double)(100.0 * (double)movedFromSieveToWorkbench / (double)overallSieve)) + "% to workbench, " + it.unimi.dsi.Util.format((double)(100.0 * (double)movedFromSieveToVirtualizer / (double)overallSieve)) + "% to virtual queues, " + it.unimi.dsi.Util.format((double)(100.0 * (double)movedFromSieveToOverflow / (double)overallSieve)) + "% to overflow)");
                    }
                    if (overallQueues != 0L) {
                        LOGGER.info("Moved " + overallQueues + " URLs from queues (" + it.unimi.dsi.Util.format((double)(100.0 * (double)deletedFromQueues / (double)overallQueues)) + "% deleted)");
                    }
                    deletedFromQueues = 0L;
                    deletedFromSieve = 0L;
                    movedFromQueues = 0L;
                    movedFromSieveToOverflow = 0L;
                    movedFromSieveToWorkbench = 0L;
                    movedFromSieveToVirtualizer = 0L;
                    LOGGER.info("Sleeping: large front " + largeFrontSleepTime + ", full workbench " + fullWorkbenchSleepTime + ", no ready URLs " + noReadyURLsSleepTime);
                    largeFrontSleepTime = 0L;
                    fullWorkbenchSleepTime = 0L;
                    noReadyURLsSleepTime = 0L;
                    this.statsThread.emit();
                    lastLowCostStat = now;
                    this.frontier.virtualizer.collectIf(0.5, 0.75);
                }
                if (now - HIGH_COST_STATS_INTERVAL > this.lastHighCostStat) {
                    this.lastHighCostStat = Long.MAX_VALUE;
                    Thread thread = new Thread((Runnable)this.statsThread, this.statsThread.getClass().getSimpleName());
                    thread.start();
                }
                if (now - PURGE_CHECK_INTERVAL > this.lastPurgeCheck) {
                    for (VisitState visitState : this.schemeAuthority2VisitState.visitStates()) {
                        if (visitState == null || visitState.nextFetch != Long.MAX_VALUE && (visitState.nextFetch == 0L || visitState.nextFetch >= now - PURGE_DELAY || !visitState.isEmpty() || visitState.acquired || visitState.lastExceptionClass != null)) continue;
                        LOGGER.info((visitState.nextFetch == Long.MAX_VALUE ? "Purging " : "Purging by delay ") + visitState);
                        this.frontier.virtualizer.remove(visitState);
                        this.schemeAuthority2VisitState.remove(visitState);
                    }
                    this.lastPurgeCheck = now;
                }
                if (round != -1) {
                    int sleepTime = 1 << Math.min(10, round);
                    if (!frontIsSmall) {
                        largeFrontSleepTime += (long)sleepTime;
                    } else if (workbenchIsFull) {
                        fullWorkbenchSleepTime += (long)sleepTime;
                    } else {
                        noReadyURLsSleepTime += (long)sleepTime;
                    }
                    if (this.frontier.rc.stopping) break;
                    Thread.sleep(sleepTime);
                }
                ++round;
            }
            LOGGER.info("Completed.");
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected exception", t);
            return;
        }
    }

    private boolean frontIsSmall() {
        return this.frontier.todo.size() + this.frontier.workbench.approximatedSize() - this.frontier.workbench.broken.get() <= this.frontier.requiredFrontSize.get();
    }
}

