/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import com.martiansoftware.jsap.stringparsers.LongSizeStringParser;
import it.unimi.di.law.bubing.store.Store;
import it.unimi.di.law.bubing.util.Link;
import it.unimi.di.law.warc.filters.Filter;
import it.unimi.di.law.warc.filters.URIResponse;
import it.unimi.di.law.warc.filters.parser.FilterParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.http.conn.DnsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartupConfiguration.class);
    public String name;
    public String group;
    public int weight;
    public int maxUrlsPerSchemeAuthority;
    public int fetchingThreads;
    public int parsingThreads;
    public int dnsThreads;
    @FilterSpecification(type=URI.class)
    public Filter<URI> fetchFilter;
    @FilterSpecification(type=Link.class)
    public Filter<Link> scheduleFilter;
    @FilterSpecification(type=URIResponse.class)
    public Filter<URIResponse> parseFilter;
    @FilterSpecification(type=URIResponse.class)
    public Filter<URIResponse> followFilter;
    @FilterSpecification(type=URIResponse.class)
    public Filter<URIResponse> storeFilter;
    @OptionalSpecification(value="0")
    @TimeSpecification
    public long keepAliveTime;
    @TimeSpecification
    public long schemeAuthorityDelay;
    @TimeSpecification
    public long ipDelay;
    @OptionalSpecification(value="0")
    public double ipDelayFactor;
    public long maxUrls;
    public double bloomFilterPrecision;
    @ManyValuesSpecification
    public String[] seed;
    @ManyValuesSpecification
    @OptionalSpecification(value="")
    public String[] blackListedIPv4Addresses;
    @ManyValuesSpecification
    @OptionalSpecification(value="")
    public String[] blackListedHosts;
    @TimeSpecification
    public int socketTimeout;
    @TimeSpecification
    public int connectionTimeout;
    public int fetchDataBufferByteSize;
    @OptionalSpecification(value="")
    public String proxyHost;
    @OptionalSpecification(value="8080")
    public int proxyPort;
    public String cookiePolicy;
    public int cookieMaxByteSize;
    public String userAgent;
    @OptionalSpecification(value="")
    public String userAgentFrom;
    @TimeSpecification
    public long robotsExpiration;
    @OptionalSpecification(value="true")
    public boolean acceptAllCertificates;
    public String rootDir;
    @OptionalSpecification(value="store")
    public String storeDir;
    @OptionalSpecification(value="cache")
    public String responseCacheDir;
    @OptionalSpecification(value="sieve")
    public String sieveDir;
    @OptionalSpecification(value="frontier")
    public String frontierDir;
    public int responseBodyMaxByteSize;
    public String digestAlgorithm;
    @ManyValuesSpecification
    public String[] parserSpec;
    public boolean startPaused;
    @StoreSpecification
    @OptionalSpecification(value="it.unimi.di.law.bubing.store.WarcStore")
    public Class<? extends Store> storeClass;
    public long workbenchMaxByteSize;
    @OptionalSpecification(value="1Gi")
    public long virtualizerMaxByteSize;
    public long urlCacheMaxByteSize;
    public int sieveSize;
    @OptionalSpecification(value="64Ki")
    public int sieveStoreIOBufferByteSize;
    @OptionalSpecification(value="64Ki")
    public int sieveAuxFileIOBufferByteSize;
    @DnsResolverSpecification
    @OptionalSpecification(value="it.unimi.di.law.bubing.frontier.dns.DnsJavaResolver")
    public Class<? extends DnsResolver> dnsResolverClass;
    @OptionalSpecification(value="10000")
    public int dnsCacheMaxSize;
    @OptionalSpecification(value="1h")
    @TimeSpecification
    public long dnsPositiveTtl;
    @OptionalSpecification(value="1m")
    @TimeSpecification
    public long dnsNegativeTtl;
    public boolean crawlIsNew;
    @OptionalSpecification(value="")
    public String spamDetectorUri;
    @OptionalSpecification(value="100")
    public int spamDetectionThreshold;
    @OptionalSpecification(value="2147483647")
    public int spamDetectionPeriodicity;
    private boolean rootDirChecked;

    private void checkUrlDelay() throws ConfigurationException {
        if (this.schemeAuthorityDelay < 1000L) {
            LOGGER.warn("You selected a small URL delay (" + this.schemeAuthorityDelay + "); this is going to disturb people");
        }
    }

    private void checkIpDelay() throws ConfigurationException {
        if (this.ipDelay < 100L) {
            LOGGER.warn("You selected a small IP delay (" + this.ipDelay + "); this is going to disturb people");
        }
    }

    private void checkBloomFilterPrecision() throws ConfigurationException {
        if (this.bloomFilterPrecision > 1.0) {
            LOGGER.error("Bloom-filter precision must be smaller than one");
            throw new IllegalArgumentException("Bloom-filter precision must be smaller than one");
        }
        if (this.bloomFilterPrecision > 1.0E-6) {
            LOGGER.warn("You selected a low Bloom-filter precision (" + this.bloomFilterPrecision + "); you are going to get a lot of false duplicates");
        }
    }

    private void checkRootDir() throws ConfigurationException {
        if (this.rootDirChecked) {
            return;
        }
        File d = new File(this.rootDir);
        if (this.crawlIsNew) {
            if (d.exists()) {
                throw new ConfigurationException("Root directory " + d + " exists");
            }
            if (!d.mkdirs()) {
                throw new ConfigurationException("Cannot create root directory " + d);
            }
        } else if (!d.exists()) {
            throw new ConfigurationException("Cannot find root directory " + this.rootDir + " for the crawl");
        }
        this.rootDirChecked = true;
    }

    private void checkRobotsExpiration() throws ConfigurationException {
        if (this.robotsExpiration < 3600000L) {
            LOGGER.warn("You selected a low robots expiration time (" + this.robotsExpiration + " ms)");
        }
    }

    public static File subDir(String parent, String child) {
        File d = new File(child);
        return d.isAbsolute() ? d : new File(parent, child);
    }

    private void chkSubDir(String dir) throws ConfigurationException {
        File d = StartupConfiguration.subDir(this.rootDir, dir);
        if (this.crawlIsNew) {
            if (d.exists()) {
                throw new ConfigurationException("Directory " + d + " exists");
            }
            if (!d.mkdirs()) {
                throw new ConfigurationException("Cannot create directory " + d);
            }
        } else if (!d.exists()) {
            throw new ConfigurationException("Directory " + d + " does not exist");
        }
    }

    private void checkStoreDir() throws ConfigurationException {
        this.checkRootDir();
        this.chkSubDir(this.storeDir);
    }

    private void checkResponseCacheDir() throws ConfigurationException {
        this.checkRootDir();
        this.chkSubDir(this.responseCacheDir);
    }

    private void checkSieveDir() throws ConfigurationException {
        this.checkRootDir();
        this.chkSubDir(this.sieveDir);
    }

    private void checkFrontierDir() throws ConfigurationException {
        this.checkRootDir();
        this.chkSubDir(this.frontierDir);
    }

    public StartupConfiguration(Configuration configuration) throws ConfigurationException, ClassNotFoundException {
        String name;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Required configuration: " + ConfigurationUtils.toString((Configuration)configuration));
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 8) != 0) continue;
            name = field.getName();
            Class<?> type = field.getType();
            if (!configuration.containsKey(name)) {
                OptionalSpecification optional = field.getAnnotation(OptionalSpecification.class);
                if (optional != null) {
                    configuration.setProperty(name, (Object)optional.value());
                } else {
                    throw new ConfigurationException("No property for field '" + name + "'");
                }
            }
            if (field.getAnnotation(ManyValuesSpecification.class) == null && configuration.getStringArray(name).length > 1) {
                throw new ConfigurationException("Field '" + name + "' has been specified multiple times");
            }
            field.setAccessible(true);
            try {
                if (type == Boolean.TYPE) {
                    field.setBoolean(this, configuration.getBoolean(name));
                } else if (type == Byte.TYPE) {
                    field.setByte(this, configuration.getByte(name));
                } else {
                    String value = configuration.getString(name);
                    if (value.isEmpty() && type != String.class && type != String[].class) {
                        throw new ConfigurationException("Empty string specified for configuration property " + name);
                    }
                    if (type == Character.TYPE) {
                        field.setChar(this, value.charAt(0));
                    } else if (type == Double.TYPE) {
                        field.setDouble(this, configuration.getDouble(name));
                    } else if (type == Float.TYPE) {
                        field.setFloat(this, configuration.getFloat(name));
                    } else if (type == Integer.TYPE) {
                        if (field.getAnnotation(TimeSpecification.class) != null) {
                            long time = StartupConfiguration.parseTime(value);
                            if (time > Integer.MAX_VALUE) {
                                throw new IllegalArgumentException("Time specification exceeds integer maximum value: " + value);
                            }
                            field.setInt(this, (int)time);
                        } else {
                            field.setInt(this, (Integer)IntSizeStringParser.getParser().parse(value));
                        }
                    } else if (type == Long.TYPE) {
                        if (field.getAnnotation(TimeSpecification.class) != null) {
                            field.setLong(this, StartupConfiguration.parseTime(value));
                        } else {
                            field.setLong(this, (Long)LongSizeStringParser.getParser().parse(value));
                        }
                    } else if (type == Short.TYPE) {
                        field.setShort(this, configuration.getShort(name));
                    } else if (type == String.class) {
                        field.set(this, value);
                    } else if (type == String[].class) {
                        field.set(this, configuration.getStringArray(name));
                    } else if (field.getAnnotation(StoreSpecification.class) != null) {
                        field.set(this, Class.forName(value));
                    } else if (field.getAnnotation(DnsResolverSpecification.class) != null) {
                        field.set(this, Class.forName(value));
                    } else {
                        Class filterType = field.getAnnotation(FilterSpecification.class).type();
                        field.set(this, new FilterParser(filterType).parse(value));
                    }
                }
            }
            catch (IllegalAccessException impossible) {
                throw new RuntimeException(impossible);
            }
            catch (ParseException jsap) {
                throw new ConfigurationException((Throwable)jsap);
            }
            catch (it.unimi.di.law.warc.filters.parser.ParseException filterException) {
                throw new ConfigurationException((Throwable)filterException);
            }
            field.setAccessible(false);
        }
        for (AccessibleObject accessibleObject : this.getClass().getDeclaredMethods()) {
            name = ((Method)accessibleObject).getName();
            if (!name.startsWith("check")) continue;
            try {
                ((Method)accessibleObject).invoke(this, new Object[0]);
            }
            catch (IllegalAccessException impossible) {
                throw new RuntimeException(impossible);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof ConfigurationException) {
                    throw (ConfigurationException)e.getCause();
                }
                throw new ConfigurationException(e.getCause());
            }
        }
        Iterator keys = configuration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Field field = this.getClass().getField(key);
                if ((field.getModifiers() & 1) != 0 && (field.getModifiers() & 8) == 0) continue;
                throw new NoSuchFieldException();
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("There is no configuration parameter named \"" + key + "\"");
            }
        }
    }

    public StartupConfiguration(File file, Configuration additionalProp) throws ConfigurationException, IllegalArgumentException, ClassNotFoundException {
        this(StartupConfiguration.append((Configuration)new PropertiesConfiguration(file), additionalProp));
    }

    public StartupConfiguration(String fileName, Configuration additionalProp) throws ConfigurationException, IllegalArgumentException, ClassNotFoundException {
        this(StartupConfiguration.append((Configuration)new PropertiesConfiguration(fileName), additionalProp));
    }

    public StartupConfiguration(File file) throws ConfigurationException, ClassNotFoundException {
        this((Configuration)new PropertiesConfiguration(file));
    }

    public StartupConfiguration(String fileName) throws ConfigurationException, ClassNotFoundException {
        this((Configuration)new PropertiesConfiguration(fileName));
    }

    private static Configuration append(Configuration base, Configuration additional) {
        CompositeConfiguration result = new CompositeConfiguration();
        result.addConfiguration(additional);
        result.addConfiguration(base);
        return result;
    }

    public String toString() {
        Class<?> thisClass = this.getClass();
        Object2ObjectOpenHashMap values = new Object2ObjectOpenHashMap();
        for (Field f : thisClass.getDeclaredFields()) {
            if ((f.getModifiers() & 1) == 0 || (f.getModifiers() & 8) != 0) continue;
            try {
                values.put(f.getName(), f.get(this));
            }
            catch (IllegalAccessException e) {
                values.put(f.getName(), "<THIS SHOULD NOT HAPPEN>");
            }
        }
        return values.toString();
    }

    public static long parseTime(String timeSpec) {
        StringTokenizer tokenizer = new StringTokenizer(timeSpec, " dhsm", true);
        double result = 0.0;
        long previousMultiplierValue = Long.MAX_VALUE;
        char previousMultiplier = '?';
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (Character.isWhitespace(token.charAt(0))) continue;
            double element = 0.0;
            try {
                element = Double.parseDouble(token);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number expected, " + token + " found");
            }
            if (tokenizer.hasMoreElements()) {
                do {
                    token = tokenizer.nextToken();
                } while (tokenizer.hasMoreElements() && Character.isWhitespace(token.charAt(0)));
                if (!Character.isWhitespace(token.charAt(0))) {
                    long multiplierValue;
                    String nextToken;
                    String mergedToken = token;
                    String string = nextToken = tokenizer.hasMoreElements() ? tokenizer.nextToken() : "";
                    if (nextToken.length() > 0 && !Character.isWhitespace(nextToken.charAt(0))) {
                        mergedToken = mergedToken + nextToken;
                    }
                    if ("d".equals(mergedToken)) {
                        multiplierValue = TimeUnit.DAYS.toMillis(1L);
                    } else if ("h".equals(mergedToken)) {
                        multiplierValue = TimeUnit.HOURS.toMillis(1L);
                    } else if ("m".equals(mergedToken)) {
                        multiplierValue = TimeUnit.MINUTES.toMillis(1L);
                    } else if ("s".equals(mergedToken)) {
                        multiplierValue = TimeUnit.SECONDS.toMillis(1L);
                    } else if ("ms".equals(mergedToken)) {
                        multiplierValue = TimeUnit.MILLISECONDS.toMillis(1L);
                    } else {
                        throw new IllegalArgumentException("Unknown time specifier " + mergedToken);
                    }
                    if (multiplierValue >= previousMultiplierValue) {
                        throw new IllegalArgumentException("Cannot specify " + token + " after " + previousMultiplier);
                    }
                    previousMultiplier = token.charAt(0);
                    previousMultiplierValue = multiplierValue;
                    element *= (double)multiplierValue;
                }
            }
            result += element;
        }
        return (long)result;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DnsResolverSpecification {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface StoreSpecification {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface FilterSpecification {
        public Class type();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface TimeSpecification {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ManyValuesSpecification {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OptionalSpecification {
        public String value();
    }
}

