/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import it.unimi.di.law.bubing.StartupConfiguration;
import it.unimi.di.law.bubing.parser.Parser;
import it.unimi.di.law.bubing.spam.SpamDetector;
import it.unimi.di.law.bubing.store.Store;
import it.unimi.di.law.bubing.util.BURL;
import it.unimi.di.law.bubing.util.Link;
import it.unimi.di.law.warc.filters.Filter;
import it.unimi.di.law.warc.filters.Filters;
import it.unimi.di.law.warc.filters.URIResponse;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.lang.ObjectParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.http.conn.DnsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeConfiguration.class);
    public static final boolean FETCH_ROBOTS = true;
    public final String name;
    public final String group;
    public final int weight;
    public final int maxUrlsPerSchemeAuthority;
    public volatile int fetchingThreads;
    public volatile int parsingThreads;
    public volatile int dnsThreads;
    public volatile Filter<URI> fetchFilter;
    public volatile Filter<Link> scheduleFilter;
    public volatile Filter<URIResponse> parseFilter;
    public volatile Filter<URIResponse> followFilter;
    public volatile Filter<URIResponse> storeFilter;
    public volatile long keepAliveTime;
    public volatile long schemeAuthorityDelay;
    public volatile long ipDelay;
    public volatile double ipDelayFactor;
    public volatile long maxUrls;
    public final double bloomFilterPrecision;
    public final Iterator<URI> seed;
    public final IntOpenHashSet blackListedIPv4Addresses;
    public final ReadWriteLock blackListedIPv4Lock;
    public final IntOpenHashSet blackListedHostHashes;
    public final ReadWriteLock blackListedHostHashesLock;
    public volatile int socketTimeout;
    public volatile int connectionTimeout;
    public final int fetchDataBufferByteSize;
    public final String proxyHost;
    public final int proxyPort;
    public final String cookiePolicy;
    public final int cookieMaxByteSize;
    public final String userAgent;
    public final String userAgentFrom;
    public volatile long robotsExpiration;
    public volatile boolean acceptAllCertificates;
    public final File rootDir;
    public final File storeDir;
    public final File responseCacheDir;
    public final File sieveDir;
    public final File frontierDir;
    public volatile int responseBodyMaxByteSize;
    public final String digestAlgorithm;
    public final boolean startPaused;
    public final Class<? extends Store> storeClass;
    public volatile long workbenchMaxByteSize;
    public final long virtualizerMaxByteSize;
    public volatile long urlCacheMaxByteSize;
    public final int sieveSize;
    public final int sieveStoreIOBufferByteSize;
    public final int sieveAuxFileIOBufferByteSize;
    public final int dnsCacheMaxSize;
    public final long dnsPositiveTtl;
    public final long dnsNegativeTtl;
    public final boolean crawlIsNew;
    public final SpamDetector<?> spamDetector;
    public final int spamDetectionThreshold;
    public final int spamDetectionPeriodicity;
    public final ArrayList<Parser<?>> parsers;
    public volatile boolean paused;
    public volatile boolean stopping;
    public final DnsResolver dnsResolver;
    public static final Pattern DOTTED_ADDRESS = Pattern.compile("(([0-9A-Fa-f]+[:])*[0-9A-Fa-f]+)|((((0x[0-9A-Fa-f]+)|([0-9]+))\\.)*((0x[0-9A-Fa-f]+)|([0-9]+)))");

    private static URI handleSeedURL(MutableString s) {
        URI url = BURL.parse(s);
        if (url != null) {
            if (url.isAbsolute()) {
                return url;
            }
            LOGGER.error("The seed URL " + s + " is relative");
        } else {
            LOGGER.error("The seed URL " + s + " is malformed");
        }
        return null;
    }

    private int handleIPv4(String s) throws ConfigurationException {
        try {
            if (!DOTTED_ADDRESS.matcher(s).matches()) {
                throw new ConfigurationException("Malformed IPv4 " + s + " for blacklisting");
            }
            byte[] address = InetAddress.getByName(s).getAddress();
            if (address.length > 4) {
                throw new UnknownHostException("Not IPv4");
            }
            return Ints.fromByteArray((byte[])address);
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException("Malformed IPv4 " + s + " for blacklisting", (Throwable)e);
        }
    }

    public void addBlackListedIPv4(String spec) throws ConfigurationException, FileNotFoundException {
        if (spec.length() == 0) {
            return;
        }
        if (spec.startsWith("file:")) {
            LineIterator lineIterator = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader((InputStream)new FileInputStream(spec.substring(5)), Charsets.ISO_8859_1)));
            while (lineIterator.hasNext()) {
                MutableString line = lineIterator.next();
                if (line.length() <= 0) continue;
                this.blackListedIPv4Addresses.add(this.handleIPv4(line.toString()));
            }
        } else {
            this.blackListedIPv4Addresses.add(this.handleIPv4(spec));
        }
    }

    public void addBlackListedHost(String spec) throws ConfigurationException, FileNotFoundException {
        if (spec.length() == 0) {
            return;
        }
        if (spec.startsWith("file:")) {
            LineIterator lineIterator = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader((InputStream)new FileInputStream(spec.substring(5)), Charsets.ISO_8859_1)));
            while (lineIterator.hasNext()) {
                MutableString line = lineIterator.next();
                this.blackListedHostHashes.add(line.toString().trim().hashCode());
            }
        } else {
            this.blackListedHostHashes.add(spec.trim().hashCode());
        }
    }

    public RuntimeConfiguration(StartupConfiguration startupConfiguration) throws ConfigurationException, IOException {
        try {
            this.crawlIsNew = startupConfiguration.crawlIsNew;
            this.name = startupConfiguration.name;
            this.group = startupConfiguration.group;
            this.weight = startupConfiguration.weight;
            this.maxUrlsPerSchemeAuthority = startupConfiguration.maxUrlsPerSchemeAuthority;
            this.fetchingThreads = startupConfiguration.fetchingThreads;
            this.parsingThreads = startupConfiguration.parsingThreads;
            this.dnsThreads = startupConfiguration.dnsThreads;
            this.fetchFilter = startupConfiguration.fetchFilter;
            this.scheduleFilter = startupConfiguration.scheduleFilter;
            this.parseFilter = startupConfiguration.parseFilter;
            this.followFilter = startupConfiguration.followFilter;
            this.storeFilter = startupConfiguration.storeFilter;
            this.keepAliveTime = startupConfiguration.keepAliveTime;
            this.schemeAuthorityDelay = startupConfiguration.schemeAuthorityDelay;
            this.ipDelay = startupConfiguration.ipDelay;
            this.ipDelayFactor = startupConfiguration.ipDelayFactor;
            this.maxUrls = startupConfiguration.maxUrls;
            this.bloomFilterPrecision = startupConfiguration.bloomFilterPrecision;
            this.startPaused = startupConfiguration.startPaused;
            this.storeClass = startupConfiguration.storeClass;
            this.workbenchMaxByteSize = startupConfiguration.workbenchMaxByteSize;
            this.virtualizerMaxByteSize = startupConfiguration.virtualizerMaxByteSize;
            this.urlCacheMaxByteSize = startupConfiguration.urlCacheMaxByteSize;
            this.sieveSize = startupConfiguration.sieveSize & 0xFFFFFFF8;
            this.sieveStoreIOBufferByteSize = startupConfiguration.sieveStoreIOBufferByteSize & 0xFFFFFFF8;
            this.sieveAuxFileIOBufferByteSize = startupConfiguration.sieveStoreIOBufferByteSize & 0xFFFFFFF8;
            this.dnsCacheMaxSize = startupConfiguration.dnsCacheMaxSize;
            this.dnsPositiveTtl = startupConfiguration.dnsPositiveTtl;
            this.dnsNegativeTtl = startupConfiguration.dnsNegativeTtl;
            try {
                this.dnsResolver = startupConfiguration.dnsResolverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            if (startupConfiguration.spamDetectorUri.length() > 0) {
                InputStream spamDetectorStream = new URL(startupConfiguration.spamDetectorUri).openStream();
                this.spamDetector = (SpamDetector)BinIO.loadObject((InputStream)spamDetectorStream);
                spamDetectorStream.close();
            } else {
                this.spamDetector = null;
            }
            this.spamDetectionThreshold = startupConfiguration.spamDetectionThreshold;
            this.spamDetectionPeriodicity = startupConfiguration.spamDetectionPeriodicity;
            ArrayList<1> seedSequence = new ArrayList<1>();
            for (String spec : startupConfiguration.seed) {
                if (spec.length() == 0) continue;
                if (spec.startsWith("file:")) {
                    final LineIterator lineIterator = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader((InputStream)new FileInputStream(spec.substring(5)), Charsets.ISO_8859_1)));
                    seedSequence.add(new Iterator<URI>(){

                        @Override
                        public boolean hasNext() {
                            return lineIterator.hasNext();
                        }

                        @Override
                        public URI next() {
                            return RuntimeConfiguration.handleSeedURL(lineIterator.next());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    });
                    continue;
                }
                seedSequence.add(Iterators.singletonIterator((Object)RuntimeConfiguration.handleSeedURL(new MutableString(spec))));
            }
            this.blackListedIPv4Addresses = new IntOpenHashSet();
            for (String spec : startupConfiguration.blackListedIPv4Addresses) {
                this.addBlackListedIPv4(spec);
            }
            this.blackListedIPv4Lock = new ReentrantReadWriteLock();
            this.blackListedHostHashes = new IntOpenHashSet();
            for (String spec : startupConfiguration.blackListedHosts) {
                this.addBlackListedHost(spec);
            }
            this.blackListedHostHashesLock = new ReentrantReadWriteLock();
            this.seed = Iterators.concat(seedSequence.iterator());
            this.socketTimeout = startupConfiguration.socketTimeout;
            this.connectionTimeout = startupConfiguration.connectionTimeout;
            this.rootDir = new File(startupConfiguration.rootDir);
            this.storeDir = StartupConfiguration.subDir(startupConfiguration.rootDir, startupConfiguration.storeDir);
            this.responseCacheDir = StartupConfiguration.subDir(startupConfiguration.rootDir, startupConfiguration.responseCacheDir);
            this.sieveDir = StartupConfiguration.subDir(startupConfiguration.rootDir, startupConfiguration.sieveDir);
            this.frontierDir = StartupConfiguration.subDir(startupConfiguration.rootDir, startupConfiguration.frontierDir);
            this.fetchDataBufferByteSize = startupConfiguration.fetchDataBufferByteSize;
            this.proxyHost = startupConfiguration.proxyHost;
            this.proxyPort = startupConfiguration.proxyPort;
            this.cookiePolicy = startupConfiguration.cookiePolicy;
            this.cookieMaxByteSize = startupConfiguration.cookieMaxByteSize;
            this.userAgent = startupConfiguration.userAgent;
            this.userAgentFrom = startupConfiguration.userAgentFrom;
            this.robotsExpiration = startupConfiguration.robotsExpiration;
            this.acceptAllCertificates = startupConfiguration.acceptAllCertificates;
            this.responseBodyMaxByteSize = startupConfiguration.responseBodyMaxByteSize;
            this.digestAlgorithm = startupConfiguration.digestAlgorithm;
            this.parsers = RuntimeConfiguration.parsersFromSpecs(startupConfiguration.parserSpec);
            this.paused = this.startPaused;
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException((Throwable)e);
        }
        if (this.sieveSize == 0 && this.followFilter != Filters.FALSE) {
            throw new ConfigurationException("Without a sieve you must specify a FALSE follow filter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureNotPaused() throws InterruptedException {
        if (!this.paused) {
            return;
        }
        boolean waited = false;
        RuntimeConfiguration runtimeConfiguration = this;
        synchronized (runtimeConfiguration) {
            while (this.paused) {
                LOGGER.info("Detected pause--going to wait...");
                waited = true;
                this.wait();
            }
            if (waited) {
                LOGGER.info("Pause terminated.");
            }
        }
    }

    public String toString() {
        Class<?> thisClass = this.getClass();
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        for (Field f : thisClass.getDeclaredFields()) {
            if (ReadWriteLock.class.isAssignableFrom(f.getClass()) || (f.getModifiers() & 8) != 0) continue;
            try {
                values.put(f.getName(), f.get(this));
            }
            catch (IllegalAccessException e) {
                values.put(f.getName(), "<THIS SHOULD NOT HAPPEN>");
            }
        }
        return values.toString();
    }

    public static ArrayList<Parser<?>> parsersFromSpecs(String[] specs) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IOException {
        ArrayList parsers = new ArrayList();
        for (String spec : specs) {
            parsers.add((Parser)ObjectParser.fromSpec((String)spec, Parser.class, (String[])new String[]{"it.unimi.di.law.bubing.parser"}));
        }
        return parsers;
    }
}

