/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.bubing;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.di.law.bubing.RuntimeConfiguration;
import it.unimi.di.law.bubing.StartupConfiguration;
import it.unimi.di.law.bubing.frontier.Frontier;
import it.unimi.di.law.bubing.frontier.MessageThread;
import it.unimi.di.law.bubing.frontier.QuickMessageThread;
import it.unimi.di.law.bubing.store.Store;
import it.unimi.di.law.bubing.util.BURL;
import it.unimi.di.law.bubing.util.BubingJob;
import it.unimi.di.law.bubing.util.Link;
import it.unimi.di.law.warc.filters.URIResponse;
import it.unimi.di.law.warc.filters.parser.FilterParser;
import it.unimi.di.law.warc.filters.parser.ParseException;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.jai4j.AssignmentStrategy;
import it.unimi.dsi.jai4j.ConsistentHashAssignmentStrategy;
import it.unimi.dsi.jai4j.Job;
import it.unimi.dsi.jai4j.NoSuchJobManagerException;
import it.unimi.dsi.jai4j.dropping.DiscardMessagesStrategy;
import it.unimi.dsi.jai4j.dropping.DroppingThreadFactory;
import it.unimi.dsi.jai4j.dropping.PendingMessagesStrategy;
import it.unimi.dsi.jai4j.dropping.TimedDroppingThreadFactory;
import it.unimi.dsi.jai4j.jgroups.JGroupsJobManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.jgroups.JChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.softee.management.annotation.Description;
import org.softee.management.annotation.MBean;
import org.softee.management.annotation.ManagedAttribute;
import org.softee.management.annotation.ManagedOperation;
import org.softee.management.annotation.Parameter;

@MBean
@Description(value="A BUbiNG agent")
public class Agent
extends JGroupsJobManager<BubingJob> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Agent.class);
    public static final String JMX_REMOTE_PORT_SYSTEM_PROPERTY = "com.sun.management.jmxremote.port";
    public static final String JGROUPS_CONFIGURATION_PROPERTY_NAME = "it.unimi.di.law.bubing.jgroups.configurationFile";
    private final RuntimeConfiguration rc;
    private final Frontier frontier;
    private final Store store;
    protected final MessageThread messageThread;
    protected final QuickMessageThread quickMessageThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent(String hostname, int jmxPort, RuntimeConfiguration rc) throws Exception {
        super(rc.name, rc.weight, new InetSocketAddress(hostname, jmxPort), new JChannel(System.getProperty(JGROUPS_CONFIGURATION_PROPERTY_NAME) != null ? new FileInputStream(System.getProperty(JGROUPS_CONFIGURATION_PROPERTY_NAME)) : JGroupsJobManager.class.getResourceAsStream('/' + JGroupsJobManager.class.getPackage().getName().replace('.', '/') + "/jgroups.xml")), rc.group, (AssignmentStrategy)new ConsistentHashAssignmentStrategy(), new LinkedBlockingQueue(), (DroppingThreadFactory)new TimedDroppingThreadFactory(1800000L), (PendingMessagesStrategy)new DiscardMessagesStrategy());
        LOGGER.info("Creating Agent instance with properties {}", (Object)rc);
        this.rc = rc;
        this.store = rc.storeClass.getConstructor(RuntimeConfiguration.class).newInstance(rc);
        this.register();
        this.frontier = new Frontier(rc, this.store, this);
        this.setListener(this.frontier);
        this.messageThread = new MessageThread(this.frontier);
        this.messageThread.start();
        this.quickMessageThread = new QuickMessageThread(this.frontier);
        this.quickMessageThread.start();
        this.connect();
        this.frontier.dnsThreads(rc.dnsThreads);
        this.frontier.parsingThreads(rc.parsingThreads);
        this.frontier.fetchingThreads(rc.fetchingThreads);
        this.frontier.rc.ensureNotPaused();
        ByteArrayList list = new ByteArrayList();
        while (rc.seed.hasNext()) {
            URI nextSeed = rc.seed.next();
            if (nextSeed == null) continue;
            this.frontier.enqueue(BURL.toByteArrayList(nextSeed, list));
        }
        Agent agent = this;
        synchronized (agent) {
            if (!rc.stopping) {
                ((Object)((Object)this)).wait();
            }
        }
        this.messageThread.stop = true;
        this.messageThread.join();
        LOGGER.info("Joined message thread");
        this.frontier.close();
        LOGGER.info("Going to close job manager " + (Object)((Object)this));
        this.close();
        LOGGER.info("Job manager closed");
        this.quickMessageThread.stop = true;
        this.quickMessageThread.join();
        LOGGER.info("Joined quick message thread");
        this.frontier.snap();
        LOGGER.info("Agent " + (Object)((Object)this) + " exits");
    }

    public BubingJob fromString(String s) {
        URI url = BURL.parse(s);
        if (url != null && url.isAbsolute()) {
            return new BubingJob(ByteArrayList.wrap((byte[])BURL.toByteArray(url)));
        }
        throw new IllegalArgumentException();
    }

    public byte[] toByteArray(BubingJob job) throws IllegalArgumentException {
        return job.url.toByteArray();
    }

    public BubingJob fromByteArray(byte[] array, int offset) throws IllegalArgumentException {
        return new BubingJob(ByteArrayList.wrap((byte[])Arrays.copyOfRange(array, offset, array.length)));
    }

    public int getKnownCount() {
        return this.identifier2RemoteJobManager.size();
    }

    @ManagedOperation
    @Description(value="Stop this agent")
    public synchronized void stop() {
        LOGGER.info("Going to stop the agent...");
        this.rc.stopping = true;
        ((Object)((Object)this)).notify();
    }

    @ManagedOperation
    @Description(value="Pause this agent")
    public void pause() {
        LOGGER.info("Going to pause the agent...");
        this.rc.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    @Description(value="Resume a paused agent")
    public void resume() {
        if (this.rc.paused) {
            LOGGER.info("Resuming the agent...");
            RuntimeConfiguration runtimeConfiguration = this.rc;
            synchronized (runtimeConfiguration) {
                this.rc.paused = false;
                this.rc.notifyAll();
            }
        } else {
            LOGGER.warn("Agent not paused: not resuming");
        }
    }

    @ManagedOperation
    @Description(value="Flush the sieve")
    public void flush() throws IOException, InterruptedException {
        this.frontier.sieve.flush();
    }

    @ManagedOperation
    @Description(value="Add a new IPv4 to the black list; it can be a single IP address or a file (prefixed by file:)")
    public void addBlackListedIPv4(@Parameter(value="address") @Description(value="An IPv4 address to be blacklisted") String address) throws ConfigurationException, FileNotFoundException {
        Lock lock = this.rc.blackListedIPv4Lock.writeLock();
        lock.lock();
        try {
            this.rc.addBlackListedIPv4(address);
        }
        finally {
            lock.unlock();
        }
    }

    @ManagedOperation
    @Description(value="Add a new host to the black list; it can be a single host or a file (prefixed by file:)")
    public void addBlackListedHost(@Parameter(value="host") @Description(value="A host to be blacklisted") String host) throws ConfigurationException, FileNotFoundException {
        Lock lock = this.rc.blackListedHostHashesLock.writeLock();
        lock.lock();
        try {
            this.rc.addBlackListedHost(host);
        }
        finally {
            lock.unlock();
        }
    }

    @ManagedOperation
    @Description(value="Get manager for this URL")
    public String getManager(@Parameter(value="url") @Description(value="A URL") String url) throws NoSuchJobManagerException {
        return this.assignmentStrategy.manager((Job)new BubingJob(ByteArrayList.wrap((byte[])BURL.toByteArray(BURL.parse(url))))).toString();
    }

    @ManagedAttribute
    public void setDnsThreads(int dnsThreads) throws IllegalArgumentException {
        this.rc.dnsThreads = dnsThreads;
        this.frontier.dnsThreads(this.rc.dnsThreads);
    }

    @ManagedAttribute
    @Description(value="Number of DNS threads")
    public int getDnsThreads() {
        return this.rc.dnsThreads;
    }

    @ManagedAttribute
    public void setFetchingThreads(int fetchingThreads) throws IllegalArgumentException, NoSuchAlgorithmException, IOException {
        this.rc.fetchingThreads = fetchingThreads;
        this.frontier.fetchingThreads(this.rc.fetchingThreads);
    }

    @ManagedAttribute
    @Description(value="Number of fetching threads")
    public int getFetchingThreads() {
        return this.rc.fetchingThreads;
    }

    @ManagedAttribute
    public void setParsingThreads(int parsingThreads) throws IllegalArgumentException {
        this.rc.parsingThreads = parsingThreads;
        this.frontier.parsingThreads(this.rc.parsingThreads);
    }

    @ManagedAttribute
    @Description(value="Number of parsing threads (usually, no more than the number of available cores)")
    public int getParsingThreads() {
        return this.rc.parsingThreads;
    }

    @ManagedAttribute
    public void setFetchFilter(String spec) throws ParseException {
        this.rc.fetchFilter = new FilterParser<URI>(URI.class).parse(spec);
    }

    @ManagedAttribute
    @Description(value="Filters that will be applied to all URLs out of the frontier to decide whether to fetch them")
    public String getFetchFilter() {
        return this.rc.fetchFilter.toString();
    }

    @ManagedAttribute
    public void setScheduleFilter(String spec) throws ParseException {
        this.rc.scheduleFilter = new FilterParser<Link>(Link.class).parse(spec);
    }

    @ManagedAttribute
    @Description(value="Filter that will be applied to all URLs obtained by parsing a page before scheduling them")
    public String getScheduleFilter() {
        return this.rc.scheduleFilter.toString();
    }

    @ManagedAttribute
    public void setParseFilter(String spec) throws ParseException {
        this.rc.parseFilter = new FilterParser<URIResponse>(URIResponse.class).parse(spec);
    }

    @ManagedAttribute
    @Description(value="Filter that will be applied to all fetched responses to decide whether to parse them")
    public String getParseFilter() {
        return this.rc.parseFilter.toString();
    }

    @ManagedAttribute
    public void setFollowFilter(String spec) throws ParseException {
        this.rc.followFilter = new FilterParser<URIResponse>(URIResponse.class).parse(spec);
    }

    @ManagedAttribute
    @Description(value="Filter that will be applied to all fetched responses to decide whether to follow their links")
    public String getFollowFilter() {
        return this.rc.followFilter.toString();
    }

    @ManagedAttribute
    public void setStoreFilter(String spec) throws ParseException {
        this.rc.storeFilter = new FilterParser<URIResponse>(URIResponse.class).parse(spec);
    }

    @ManagedAttribute
    @Description(value="Filter that will be applied to all fetched responses to decide whether to store them")
    public String getStoreFilter() {
        return this.rc.storeFilter.toString();
    }

    @ManagedAttribute
    public void setResponseBodyMaxByteSize(int responseBodyMaxByteSize) {
        this.rc.responseBodyMaxByteSize = responseBodyMaxByteSize;
    }

    @ManagedAttribute
    @Description(value="The maximum size (in bytes) of a response body (the exceeding part will not be stored)")
    public long getResponseBodyMaxByteSize() {
        return this.rc.responseBodyMaxByteSize;
    }

    @ManagedAttribute
    public void setKeepAliveTime(int keepAliveTime) {
        this.rc.keepAliveTime = keepAliveTime;
    }

    @ManagedAttribute
    @Description(value="If zero, connections are closed at each downloaded resource. Otherwise, the time span to download continuously from the same site using the same connection")
    public long getKeepAliveTime() {
        return this.rc.keepAliveTime;
    }

    @ManagedAttribute
    public void setSchemeAuthorityDelay(long schemeAuthorityDelay) {
        this.rc.schemeAuthorityDelay = schemeAuthorityDelay;
    }

    @ManagedAttribute
    @Description(value="Delay in milliseconds between two consecutive fetches from the same scheme+authority")
    public long getUrlDelay() {
        return this.rc.schemeAuthorityDelay;
    }

    @ManagedAttribute
    public void setIpDelay(long ipDelay) {
        this.rc.ipDelay = ipDelay;
    }

    @ManagedAttribute
    @Description(value="Delay in milliseconds between two consecutive fetches from the same IP address")
    public long getIpDelay() {
        return this.rc.ipDelay;
    }

    @ManagedAttribute
    public void setMaxUrls(long maxUrls) {
        this.rc.maxUrls = maxUrls;
    }

    @ManagedAttribute
    @Description(value="Maximum number of URLs to crawl")
    public long getMaxUrls() {
        return this.rc.maxUrls;
    }

    @ManagedAttribute
    public void setSocketTimeout(int socketTimeout) {
        this.rc.socketTimeout = socketTimeout;
    }

    @ManagedAttribute
    @Description(value="Timeout in milliseconds for opening a socket")
    public int getSocketTimeout() {
        return this.rc.socketTimeout;
    }

    @ManagedAttribute
    public void setConnectionTimeout(int connectionTimeout) {
        this.rc.connectionTimeout = connectionTimeout;
    }

    @ManagedAttribute
    @Description(value="Socket connection timeout in milliseconds")
    public int getConnectionTimeout() {
        return this.rc.connectionTimeout;
    }

    @ManagedAttribute
    public void setRobotsExpiration(long robotsExpiration) {
        this.rc.robotsExpiration = robotsExpiration;
    }

    @ManagedAttribute
    @Description(value="Milliseconds after which the robots.txt file is no longer considered valid")
    public long getRobotsExpiration() {
        return this.rc.robotsExpiration;
    }

    @ManagedAttribute
    public void setWorkbenchMaxByteSize(long workbenchSize) {
        this.rc.workbenchMaxByteSize = workbenchSize;
    }

    @ManagedAttribute
    @Description(value="Maximum size of the workbench in bytes")
    public long getWorkbenchMaxByteSize() {
        return this.rc.workbenchMaxByteSize;
    }

    @ManagedAttribute
    public void setUrlCacheMaxByteSize(long urlCacheSize) {
        this.rc.urlCacheMaxByteSize = urlCacheSize;
    }

    @ManagedAttribute
    @Description(value="Size in bytes of the URL cache")
    public long getUrlCacheMaxByteSize() {
        return this.rc.urlCacheMaxByteSize;
    }

    @ManagedAttribute
    @Description(value="Approximate size of the workbench in bytes")
    public long getWorkbenchByteSize() {
        return this.frontier.weightOfpathQueriesInQueues.get();
    }

    @ManagedAttribute
    @Description(value="Overall size of the store (includes archetypes and duplicates)")
    public long getStoreSize() {
        return this.frontier.archetypes() + this.frontier.duplicates.get();
    }

    @ManagedAttribute
    @Description(value="Number of stored archetypes")
    public long getArchetypes() {
        return this.frontier.archetypes();
    }

    @ManagedAttribute
    @Description(value="Number of stored archetypes having other status")
    public long getArchetypesOther() {
        return this.frontier.archetypesStatus[0].get();
    }

    @ManagedAttribute
    @Description(value="Number of stored archetypes having status 1xx")
    public long getArchetypes1xx() {
        return this.frontier.archetypesStatus[1].get();
    }

    @ManagedAttribute
    @Description(value="Number of stored archetypes having status 2xx")
    public long getArchetypes2xx() {
        return this.frontier.archetypesStatus[2].get();
    }

    @ManagedAttribute
    @Description(value="Number of stored archetypes having status 3xx")
    public long getArchetypes3xx() {
        return this.frontier.archetypesStatus[3].get();
    }

    @ManagedAttribute
    @Description(value="Number of stored archetypes having status 4xx")
    public long getArchetypes4xx() {
        return this.frontier.archetypesStatus[4].get();
    }

    @ManagedAttribute
    @Description(value="Number of stored archetypes having status 5xx")
    public long getArchetypes5xx() {
        return this.frontier.archetypesStatus[5].get();
    }

    @ManagedAttribute
    @Description(value="Statistics about the number of outlinks of each archetype")
    public String getArchetypeOutdegree() {
        return this.frontier.outdegree.toString();
    }

    @ManagedAttribute
    @Description(value="Statistics about the number of outlinks of each archetype, without considering the links to the same corresponding host")
    public String getArchetypeExternalOutdegree() {
        return this.frontier.externalOutdegree.toString();
    }

    @ManagedAttribute
    @Description(value="Statistic about the content length of each archetype")
    public String getArchetypeContentLength() {
        return this.frontier.contentLength.toString();
    }

    @ManagedAttribute
    @Description(value="Number of archetypes whose indicated content type starts with text (case insensitive)")
    public long getArchetypeContentTypeText() {
        return this.frontier.contentTypeText.get();
    }

    @ManagedAttribute
    @Description(value="Number of archetypes whose indicated content type starts with image (case insensitive)")
    public long getArchetypeContentTypeImage() {
        return this.frontier.contentTypeImage.get();
    }

    @ManagedAttribute
    @Description(value="Number of archetypes whose indicated content type starts with application (case insensitive)")
    public long getArchetypeContentTypeApplication() {
        return this.frontier.contentTypeApplication.get();
    }

    @ManagedAttribute
    @Description(value="Number of archetypes whose indicated content type does not start with text, image, or application (case insensitive)")
    public long getArchetypeContentTypeOthers() {
        return this.frontier.contentTypeOthers.get();
    }

    @ManagedAttribute
    @Description(value="Number of requests")
    public long getRequests() {
        return this.frontier.fetchedResources.get() + this.frontier.fetchedRobots.get();
    }

    @ManagedAttribute
    @Description(value="Number of responses")
    public long getResources() {
        return this.frontier.fetchedResources.get();
    }

    @ManagedAttribute
    @Description(value="Number of transferred bytes")
    public long getBytes() {
        return this.frontier.transferredBytes.get();
    }

    @ManagedAttribute
    @Description(value="Number of URLs received from other agents")
    public long getReceivedURLs() {
        return this.frontier.numberOfReceivedURLs.get();
    }

    @ManagedAttribute
    @Description(value="Number of duplicates")
    public long getDuplicates() {
        return this.frontier.duplicates.get();
    }

    @ManagedAttribute
    @Description(value="Percentage of duplicates")
    public double getDuplicatePercentage() {
        return 100.0 * (double)this.frontier.duplicates.get() / (double)(1L + this.frontier.archetypes());
    }

    @ManagedAttribute
    @Description(value="Number of ready URLs")
    public long getReadyURLs() {
        return this.frontier.readyURLs.size64();
    }

    @ManagedAttribute
    @Description(value="Number of FetchingThread waits")
    public long getFetchingThreadWaits() {
        return this.frontier.fetchingThreadWaits.get();
    }

    @ManagedAttribute
    @Description(value="Overall FetchingThread waiting time")
    public long getFetchingThreadTotalWaitTime() {
        return this.frontier.fetchingThreadWaitingTimeSum.get();
    }

    @ManagedAttribute
    @Description(value="URLs in VisitState queues")
    public long getURLsInQueues() {
        return this.frontier.pathQueriesInQueues.get();
    }

    @ManagedAttribute
    @Description(value="Percentage of workbench maximum size in used")
    public double getURLsInQueuesPercentage() {
        return 100.0 * (double)this.frontier.weightOfpathQueriesInQueues.get() / (double)this.frontier.rc.workbenchMaxByteSize;
    }

    @ManagedAttribute
    @Description(value="Distribution of URL among all VisitState instances (in position i, number of instances having 2^i URLs)")
    public int[] getQueueDistribution() {
        return this.frontier.getStatsThread().dist;
    }

    @ManagedAttribute
    @Description(value="Number of unresolved VisitState instances")
    public long getUnresolved() {
        return this.frontier.getStatsThread().unresolved;
    }

    @ManagedAttribute
    @Description(value="Number of path+queries in broken VisitState instances")
    public long getBroken() {
        return this.frontier.getStatsThread().brokenPathQueryCount;
    }

    @ManagedAttribute
    @Description(value="Average number of VisitState instances in a WorkbenchEntry")
    public double getEntryAverage() {
        return this.frontier.getStatsThread().entrySummaryStats.mean();
    }

    @ManagedAttribute
    @Description(value="Maximum number of VisitState instances in a WorkbenchEntry")
    public double getEntryMax() {
        return this.frontier.getStatsThread().entrySummaryStats.max();
    }

    @ManagedAttribute
    @Description(value="Minimum number of VisitState instances in a WorkbenchEntry")
    public double getEntryMin() {
        return this.frontier.getStatsThread().entrySummaryStats.min();
    }

    @ManagedAttribute
    @Description(value="Variance of the number of VisitState instances in a WorkbenchEntry")
    public double getEntryVariance() {
        return this.frontier.getStatsThread().entrySummaryStats.variance();
    }

    @ManagedAttribute
    @Description(value="Number of VisitState instances")
    public int getVisitStates() {
        return this.frontier.getStatsThread().getVisitStates();
    }

    @ManagedAttribute
    @Description(value="Number of resolved VisitState instances")
    public long getResolvedVisitStates() {
        return this.frontier.getStatsThread().resolvedVisitStates;
    }

    @ManagedAttribute
    @Description(value="Number of entries on the workbench")
    public long getIPOnWorkbench() {
        return this.frontier.workbench.approximatedSize();
    }

    @ManagedAttribute
    @Description(value="Number of VisitState instances on the workbench")
    public long getVisitStatesOnWorkbench() {
        return (long)this.frontier.getStatsThread().entrySummaryStats.sum();
    }

    @ManagedAttribute
    @Description(value="Number of VisitState instances on the todo list")
    public long getToDoSize() {
        return this.frontier.todo.size();
    }

    @ManagedAttribute
    @Description(value="Number of FetchingThread instances downloading data")
    public int getActiveFecthingThreads() {
        return (int)((long)this.frontier.rc.fetchingThreads - this.frontier.results.size());
    }

    @ManagedAttribute
    @Description(value="Number of FetchingThread instances waiting for parsing")
    public int getReadyToParse() {
        return (int)this.frontier.results.size();
    }

    @ManagedAttribute
    @Description(value="Number of unknown hosts")
    public int getUnknownHosts() {
        return this.frontier.unknownHosts.size();
    }

    @ManagedAttribute
    @Description(value="Number of broken VisitState instances")
    public long getBrokenVisitStates() {
        return this.frontier.brokenVisitStates.get();
    }

    @ManagedAttribute
    @Description(value="Number of broken VisitState instances on the workbench")
    public long getBrokenVisitStatesOnWorkbench() {
        return this.frontier.getStatsThread().brokenVisitStatesOnWorkbench;
    }

    @ManagedAttribute
    @Description(value="Number of new VisitState instances waiting to be resolved")
    public int getWaitingVisitStates() {
        return this.frontier.newVisitStates.size();
    }

    @ManagedAttribute
    @Description(value="Number of VisitState instances with path+queries on disk")
    public long getVisitStatesOnDisk() {
        return this.frontier.getStatsThread().getVisitStatesOnDisk();
    }

    @ManagedAttribute
    @Description(value="Current required front size")
    public long getRequiredFrontSize() {
        return this.frontier.requiredFrontSize.get();
    }

    public static void main(String[] arg) throws Exception {
        String portProperty;
        SimpleJSAP jsap = new SimpleJSAP(Agent.class.getName(), "Starts a BUbiNG agent (note that you must enable JMX by means of the standard Java system properties).", new com.martiansoftware.jsap.Parameter[]{new FlaggedOption("weight", (StringParser)JSAP.INTEGER_PARSER, "1", false, 'w', "weight", "The agent weight."), new FlaggedOption("group", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, 'g', "group", "The JGroups group identifier (must be the same for all cooperating agents)."), new FlaggedOption("jmxHost", (StringParser)JSAP.STRING_PARSER, InetAddress.getLocalHost().getHostAddress(), true, 'h', "jmx-host", "The IP address (possibly specified by a host name) that will be used to expose the JMX RMI connector to other agents."), new FlaggedOption("rootDir", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'r', "root-dir", "The root directory."), new Switch("new", 'n', "new", "Start a new crawl"), new FlaggedOption("properties", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, 'P', "properties", "The properties used to configure the agent."), new UnflaggedOption("name", (StringParser)JSAP.STRING_PARSER, true, "The agent name (an identifier that must be unique across the group).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        if ((portProperty = System.getProperty(JMX_REMOTE_PORT_SYSTEM_PROPERTY)) == null) {
            throw new IllegalArgumentException("You must specify a JMX service port using the property com.sun.management.jmxremote.port");
        }
        String name = jsapResult.getString("name");
        int weight = jsapResult.getInt("weight");
        String group = jsapResult.getString("group");
        String host = jsapResult.getString("jmxHost");
        int port = Integer.parseInt(portProperty);
        BaseConfiguration additional = new BaseConfiguration();
        additional.addProperty("name", (Object)name);
        additional.addProperty("group", (Object)group);
        additional.addProperty("weight", (Object)Integer.toString(weight));
        additional.addProperty("crawlIsNew", (Object)jsapResult.getBoolean("new"));
        if (jsapResult.userSpecified("rootDir")) {
            additional.addProperty("rootDir", (Object)jsapResult.getString("rootDir"));
        }
        new Agent(host, port, new RuntimeConfiguration(new StartupConfiguration(jsapResult.getString("properties"), (Configuration)additional)));
        System.exit(0);
    }
}

