package voting;

/*		 
 * Voting in social networks
 *
 * Copyright (C) 2009-2010 Paolo Boldi, Francesco Bonchi, Carlos Castillo, Sebastiano Vigna 
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 2.1 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */


import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.lang.MutableString;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.log4j.Logger;

import cern.colt.Sorting;
import cern.colt.function.IntComparator;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.UnflaggedOption;

public class MetisToSCC {
	@SuppressWarnings("unused")
	private final static Logger LOGGER = Util.getLogger( MetisToSCC.class );
		
	@SuppressWarnings("unchecked")
	public static void main( String args[] ) throws IllegalArgumentException, SecurityException, JSAPException, IOException {
		
		SimpleJSAP jsap = new SimpleJSAP( MetisToSCC.class.getName(), "Turns a METIS partitioning output to a pair of scc/sccsizes-like file.",
				new Parameter[] {
						new UnflaggedOption( "metis", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, JSAP.REQUIRED, JSAP.NOT_GREEDY, "A text file containing METIS partitioning data." ),
						new UnflaggedOption( "sccs", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, JSAP.REQUIRED, JSAP.NOT_GREEDY, "The file name containing the SCC-like description." ),
						new UnflaggedOption( "sccsizes", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, JSAP.REQUIRED, JSAP.NOT_GREEDY, "The file name containing the SCC-like sizes." ),
					}		
				);
		
		JSAPResult jsapResult = jsap.parse( args );
		if ( jsap.messagePrinted() ) return;

		ObjectList<MutableString> allLines = new FileLinesCollection( jsapResult.getString( "metis" ), "ASCII" ).allLines();
		int cluster[] = new int[ allLines.size() ];
		int i = 0;
		for( MutableString s: allLines ) cluster[ i++ ] = Integer.parseInt( s.toString() );
		allLines = null;

		int numClusters = 0;
		for( int x: cluster ) numClusters = Math.max( x, numClusters );
		numClusters++;
		final int count[] = new int[ numClusters ];
		for( int x: cluster ) count[ x ]++;
		int[] perm = new int[ numClusters ];
		for( int j = numClusters; j-- != 0; ) perm[ j ] = j;
		Sorting.quickSort( perm, 0, numClusters, new IntComparator() {
			public int compare( int a, int b ) {
				return count[ b ] - count[ a ];
			}
		});
		
		int[] invPerm = new int[ perm.length ];
		for( int j = perm.length; j-- != 0; ) invPerm[ perm[ j ] ] = j;
		
		for( int j = cluster.length; j-- != 0; ) cluster[ j ] = invPerm[ cluster[ j ] ];
		BinIO.storeInts( cluster, jsapResult.getString( "sccs" ) );
		
		final DataOutputStream dos = new DataOutputStream( new FastBufferedOutputStream( new FileOutputStream( jsapResult.getString( "sccsizes" ) ) ) );
		for( int j = 0; j < count.length; j++ ) {
			if ( count[ perm[ j ] ] == 0 ) break;
			dos.writeInt( count[ perm[ j ] ] );
		}
		dos.close();
	}
}