package voting;

/*		 
 * Voting in social networks
 *
 * Copyright (C) 2009-2010 Paolo Boldi, Francesco Bonchi, Carlos Castillo, Sebastiano Vigna 
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 2.1 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */


import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.BinIO;

import java.io.IOException;
import java.util.List;

import org.apache.log4j.Logger;

import cern.colt.Sorting;
import cern.colt.function.IntComparator;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.UnflaggedOption;

public class ComputeCandidatesBySCC {
	@SuppressWarnings("unused")
	private final static Logger LOGGER = Util.getLogger( ComputeCandidatesBySCC.class );
		
	@SuppressWarnings("unchecked")
	public static void main( String args[] ) throws IllegalArgumentException, SecurityException, JSAPException, IOException, ClassNotFoundException {
		
		SimpleJSAP jsap = new SimpleJSAP( ComputeCandidatesBySCC.class.getName(), "Compute list of candidates proportionally to strongly connected components.",
				new Parameter[] {
/*						new FlaggedOption( "graphClass", GraphClassParser.getParser(), null, JSAP.NOT_REQUIRED, 'g', "graph-class", "Forces a Java class for the source graph." ),
						new FlaggedOption( "spec", new ObjectParser(), JSAP.NO_DEFAULT, JSAP.NOT_REQUIRED, 's', "spec", "A specification of the form <ImmutableGraphImplementation>(arg,arg,...)." ),
						new FlaggedOption( "maxIter", JSAP.INTEGER_PARSER, Integer.toString( 1000 ), JSAP.NOT_REQUIRED, 'i', "max-iter", "Maximum number of iterations."),
						new Switch( "once", '1', "once", "Use the read-once load method to read a graph from standard input." ),
						new Switch( "label", 'l', "label", "The graph is labelled, and the integer value associated to the well-known key must be used as a weight during the voting process." ),
						
	*/ 					new FlaggedOption( "seats", JSAP.INTSIZE_PARSER, Integer.toString( 1000 ), JSAP.NOT_REQUIRED, 's', "seats", "The number of seats." ),
						new UnflaggedOption( "names", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, JSAP.REQUIRED, JSAP.NOT_GREEDY, "A Java serialised list containing node names." ),
						new UnflaggedOption( "sccs", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, JSAP.REQUIRED, JSAP.NOT_GREEDY, "The file name containing the SCC description." ),
						new UnflaggedOption( "sccsizes", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, JSAP.REQUIRED, JSAP.NOT_GREEDY, "The file name containing the SCC sizes." ),
						new UnflaggedOption( "scores", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, JSAP.REQUIRED, JSAP.NOT_GREEDY, "The scores." ),
					}		
				);
		
		JSAPResult jsapResult = jsap.parse( args );
		if ( jsap.messagePrinted() ) return;

		final List<CharSequence> names = (List<CharSequence>)BinIO.loadObject( jsapResult.getString( "names" ) );
		final String sccsFilename = jsapResult.getString( "sccs" );
		final String sccSizesFilename = jsapResult.getString( "sccsizes" );
		final String scoreFilename = jsapResult.getString( "scores" );
		final int numSeats = jsapResult.getInt( "seats" );
		
		final double[] score = BinIO.loadDoubles( scoreFilename );
		final int[] sccs = BinIO.loadInts( sccsFilename );
		final int[] sccSizes = BinIO.loadInts( sccSizesFilename );
		final int n = score.length;
		if ( n < sccs.length ) System.err.println( "WARNING: there are more nodes than scores." );
		if ( n > score.length ) throw new IllegalArgumentException();
		final int[] perm = new int[ n ];
		for( int i = perm.length; i-- != 0; ) perm[ i ] = i;
		
		Sorting.quickSort( perm, 0, perm.length, new IntComparator() {
			public int compare( int a, int b ) {
				return score[ b ] - score[ a ] < 0 ? -1 : score[ b ] == score[ a ] ? 0 : 1;
			}
		});
		
		final int seats[][] = new int[ sccSizes.length ][];
		final double peoplePerSeat = n / (double)numSeats; 
		for( int i = 0; i < sccSizes.length; i++ ) seats[ i ] = new int[ (int)Math.floor( sccSizes[ i ] / peoplePerSeat ) ];
		final int count[] = new int[ sccSizes.length ];
		for( int i = 0; i < n; i++ ) {
			final int comp = sccs[ perm[ i ] ];
			if ( count[ comp ] < seats[ comp ].length ) seats[ comp ][ count[ comp ]++ ] = perm[ i ];
		}
		
		for( int i = 0; i < sccSizes.length; i++ ) {
			if ( seats[ i ].length == 0 ) break;
			System.out.println( "******** " + i + " ********");
			for( int j = 0; j < seats[ i ].length; j++ ) {
				System.out.println( names.get( seats[ i ][ j ] ) );
			}
		}
	}

}