package es.yrbcn.graph.triangles;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.NodeIterator;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

import org.slf4j.LoggerFactory;



public class MainmemlongBitbasedTrianglesAlgorithm extends
		BitbasedTrianglesAlgorithm {

	/**
	 * Now we need a single counter, but it can no longer be a single byte
	 * because we will need to accumulator (deg(A)+deg(B)) which can be a larger
	 * number. Even an integer could be too small so we will use a double
	 */
	long minima_accumulator[];
	boolean accumulator_ok[];

	public MainmemlongBitbasedTrianglesAlgorithm(final ImmutableGraph graph,
			int seed, short maxDistance) {
		super(graph, seed, maxDistance);

		// Initialize the accumulator that will count the matches in main memory
		minima_accumulator = new long[numNodes];
		Arrays.fill(minima_accumulator, 0);

		accumulator_ok = new boolean[numNodes];
		Arrays.fill(accumulator_ok, true);
		// We need the degrees in main memory
		readDegree();
	}

	public void step() throws IOException {

		System.err.println();
		System.err.println("Doing pass " + currentPass + "/" + maxPasses);
		initHashFunction(currentPass);
		Arrays.fill(minima, Integer.MAX_VALUE);

		// Stage 1: store the minimum hash value from my neighbors
		System.err
				.println("Reading the graph to store the minimum of my neighbors");
		NodeIterator nodes = graph.nodeIterator();
		ProgressLogger pl = new ProgressLogger(LoggerFactory.getLogger("readgraph"),
				ProgressLogger.TEN_SECONDS, TimeUnit.MILLISECONDS, "nodes");
		pl.expectedUpdates = numNodes;
		pl.start();
		int src;
		while ( nodes.hasNext() ) {
			src = nodes.nextInt();
			LazyIntIterator destL = nodes.successors();
			int aux_outdegree = nodes.outdegree();
			for (int i = 0; i < aux_outdegree; i++) {
				int dest = destL.nextInt();
				if (dest != src) {
					if (minima[src] > getHash(dest)) {
						minima[src] = getHash(dest);
					}
				}
			}
			if (numNodes > 10000) {
				pl.update();
			}
		}
		pl.done();

		// Stage2: store/update the number of times the minima matched
		System.err
				.println("Storing/Updating the number of matches in the minima in main memory");
		
		nodes = graph.nodeIterator();
		pl = new ProgressLogger(LoggerFactory.getLogger("readgraph"),
				ProgressLogger.ONE_SECOND, TimeUnit.MILLISECONDS, "nodes");
		pl.expectedUpdates = numNodes;
		pl.start();
		
		while ( nodes.hasNext() ) {
			src=nodes.nextInt();
			LazyIntIterator destL = nodes.successors();
			int aux_outdegree = nodes.outdegree();
			for (int i = 0; i < aux_outdegree; i++) {
				int dest = destL.nextInt();
				if (dest != src) {
					if (minima[src] == minima[dest]) {
						minima_accumulator[src] += (degree[src] + degree[dest]);
						
						// If it overflows, the result will be less than zero
						if( minima_accumulator[src] < 0 ) {
							accumulator_ok[src] = false;
						}
					}
				}
			}
			if (numNodes > 10000) {
				pl.update();
			}
		}
		pl.done();
		
		if (currentPass == maxPasses) {
			finalStep();
			done = true;
		} else {
			currentPass++;
		}
	}

	void finalStep() throws NumberFormatException, IOException {
		System.err.println();
		System.err.println("Doing final step");

		// Free memory
		minima = null;
		destroyHashFunction();

	}
	
	public void countTriangles() {
		
		System.err.println("Counting the matches");
		
		ProgressLogger pl = new ProgressLogger(LoggerFactory.getLogger("compute"),
				ProgressLogger.ONE_SECOND, TimeUnit.MILLISECONDS, "nodes");
		pl.expectedUpdates = numNodes;
		pl.start();
		
		// The original formula was: sum_i (z_i / (z_i+m)) * (d + d_i)
		// The new formula       is: sum_i (z_i / (3m/2)) * (d+d_i)
		
		// Given that in any case at the end I have to divide by two,
		// I use as multiplier (1/3m)
		
		double multiplier = 1.0 / ( currentPass * 3.0 );
		
		for( int src=0; src<numNodes; src++ ) {
			if( accumulator_ok[src] ) {
				triangles[src] = multiplier * minima_accumulator[src];
			} else {
				triangles[src] = -1000; //Signal the overflow
			}
			
			if (numNodes > 10000) {
				pl.update();
			}
		}
		pl.done();
	}
}
