package es.yrbcn.graph.triangles;

import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.NodeIterator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

import org.slf4j.LoggerFactory;


public class BitbasedTrianglesAlgorithm extends TrianglesAlgorithm {

	public static final int DEFAULT_MAX_PASSES = 50;

	public static final int BUFFER_SIZE = 16777216; // 16M bytes

	int hashvalue[] = null;

	int minima[] = null;

	int maxPasses = DEFAULT_MAX_PASSES;

	public int currentPass = 1;

	/**
	 * Will be used in the last step
	 */
	int degree[] = null;

	public BitbasedTrianglesAlgorithm(final ImmutableGraph graph,
			int seed, short maxDistance) {
		super(graph, seed, maxDistance);
		if (maxDistance > 1) {
			throw new IllegalArgumentException(
					"Not implemented at more than distance 1");
		}
		if (maxPasses > 126) {
			throw new IllegalArgumentException(
					"Counts are implemented as bytes so you cannot have that many passes");
		}
	}

	public void destroyHashFunction() {
		hashvalue = null;
	}

	public void init() {
		minima = new int[numNodes];
		currentPass = 1;
	}

	public void step() throws IOException {

		System.err.println();
		System.err.println("Doing pass " + currentPass + "/" + maxPasses);
		initHashFunction(currentPass);
		Arrays.fill(minima, Integer.MAX_VALUE);

		// Stage 1: store the minimum hash value from my neighbors
		System.err
				.println("Reading the graph to store the minimum of my neighbors");
		NodeIterator nodes = graph.nodeIterator();
		ProgressLogger pl = new ProgressLogger(LoggerFactory.getLogger("readgraph"),
				ProgressLogger.TEN_SECONDS, TimeUnit.MILLISECONDS, "nodes");
		pl.expectedUpdates = numNodes;
		pl.start();
		int src;
		while (nodes.hasNext()) {
			src = nodes.nextInt();
			LazyIntIterator destL = nodes.successors();
			int aux_outdegree = nodes.outdegree();
			for (int i = 0; i < aux_outdegree; i++) {
				int dest = destL.nextInt();
				if (dest != src) {
					if (minima[src] > getHash(dest)) {
						minima[src] = getHash(dest);
					}
				}
			}
			if (numNodes > 10000) {
				pl.update();
			}
		}
		pl.done();

		// Stage2: store/update the number of times the minima matched
		System.err
				.println("Storing/Updating the number of matches in the minima");
		String filename_tmp_in = graph.basename() + ".minima_match_count.tmp";
		String filename_tmp_out = graph.basename() + ".minima_match_count.tmp2";

		// Open input file. Ignore for first pass because it should contain all
		// zeros
		BufferedInputStream inputFile = null;
		if (currentPass > 1) {
			inputFile = new BufferedInputStream(new FileInputStream(new File(
					filename_tmp_in)), BUFFER_SIZE);
		}

		// Open output file
		BufferedOutputStream outputFile = new BufferedOutputStream(
				new FileOutputStream(filename_tmp_out), BUFFER_SIZE);

		// Buffered is handle by BufferedInputStream and BufferedOutputStream
		byte buffer[] = new byte[1];

		nodes = graph.nodeIterator();
		pl = new ProgressLogger(LoggerFactory.getLogger("writegraph"),
				ProgressLogger.TEN_SECONDS, TimeUnit.MILLISECONDS, "nodes");
		pl.expectedUpdates = numNodes;
		pl.start();
		
		while (nodes.hasNext()) {
			src = nodes.nextInt();

			LazyIntIterator destL = nodes.successors();
			int aux_outdegree = nodes.outdegree();
			for (int i = 0; i < aux_outdegree; i++) {
				int dest = destL.nextInt();
				if (dest != src) {
					if (inputFile != null) {
						inputFile.read(buffer, 0, 1);
					} else {
						buffer[0] = 0;
					}
					if (minima[src] == minima[dest]) {
						buffer[0]++;
					}
					outputFile.write(buffer, 0, 1);
				}
			}

			if (numNodes > 10000) {
				pl.update();
			}
		}
		pl.done();

		// Rename the file
		if (inputFile != null) {
			inputFile.close();
		}
		outputFile.close();

		new File(filename_tmp_out).renameTo(new File(filename_tmp_in));

		if (currentPass == maxPasses) {
			finalStep();
			done = true;
		} else {
			currentPass++;
		}
	}

	void readDegree() {

		System.err.println("Reading the degree of nodes");
		degree = new int[numNodes];
		Arrays.fill(degree, 0);
		NodeIterator nodes = graph.nodeIterator();

		ProgressLogger pl = new ProgressLogger(LoggerFactory.getLogger("readgraph"),
				ProgressLogger.TEN_SECONDS, TimeUnit.MILLISECONDS, "nodes");
		pl.expectedUpdates = numNodes;
		pl.start();
		
		int src;
		while (nodes.hasNext()) {
			src = nodes.nextInt();
			// Temporary degree
			int aux_degree = nodes.outdegree();

			// Real degree, without counting self loops
			int outdegree = 0;
			LazyIntIterator destL = nodes.successors();
			for (int i = 0; i < aux_degree; i++) {
				int dest = destL.nextInt();
				if (dest != src) {
					outdegree++;
				}
			}
			degree[src] = outdegree;
			if (numNodes > 10000) {
				pl.update();
			}
		}
		pl.done();

	}

	void finalStep() throws NumberFormatException, IOException {
		System.err.println();
		System.err.println("Doing final step");

		// Free memory
		minima = null;
		destroyHashFunction();
		
		countTriangles();
		
	}
	
	public void countTriangles() throws IOException {

		// Stage 1: read the degree of nodes
		readDegree();

		// Stage 2: compute the approximation
		System.err.println("Counting the matches");
		String filename_tmp = graph.basename() + ".minima_match_count.tmp";
		DataInputStream in = new DataInputStream(new FileInputStream(new File(
				filename_tmp)));

		NodeIterator nodes = graph.nodeIterator();
		ProgressLogger pl = new ProgressLogger(LoggerFactory.getLogger("readgraph"),
				ProgressLogger.ONE_SECOND, TimeUnit.MILLISECONDS, "nodes");
		pl.expectedUpdates = numNodes;
		pl.start();
		byte matches[] = new byte[1];
		int src;
		while (nodes.hasNext()) {
			src = nodes.nextInt();
			LazyIntIterator destL = nodes.successors();
			int mydegree = degree[src];
			triangles[src] = 0;

			int aux_degree = nodes.outdegree();
			for (int i = 0; i < aux_degree; i++) {
				int dest = destL.nextInt();

				if (dest != src) {
					int yourdegree = degree[dest];
					in.read(matches, 0, 1);
					triangles[src] += (((double) mydegree + (double) yourdegree) * (((double) matches[0]) / ((double) matches[0] + (double) currentPass))) / 2.0;
					//triangles[src] += (((double) mydegree + (double) yourdegree) * ((matches[0]) / ((double) matches[0] + (double) currentPass))) / 2.0;
				}
			}
			if (numNodes > 10000) {
				pl.update();
			}
		}
		pl.done();
	}

	public int getHash(int nodeid) {
		return hashvalue[nodeid];
	}

	/** Uses a lookup table for the hash function number x */
	public void initHashFunction(int pass) {

		// Check if it's necessary to request memory
		if (hashvalue == null) {
			hashvalue = new int[numNodes];
		}

		// Init with random numbers
		for (int i = 0; i < numNodes; i++) {
			hashvalue[i] = random.nextInt();
		}
	}

	public void setMaxPasses(int mp) {
		maxPasses = mp;
	}
}
